package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.ResourceInitializer;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.AccessPath;
import org.gcube.informationsystem.resourceregistry.api.rest.SharingPath;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(SharingPath.SHARING_PATH_PART)
public class SharingManagement {

	private static Logger logger = LoggerFactory.getLogger(SharingManagement.class);

	/*
	 * protected void setRESTCalledMethod(HTTPMETHOD httpMethod, String type) {
	 * List<String> list = new ArrayList<>();
	 * list.add(SharingPath.SHARING_PATH_PART); list.add(type); list.add("{" +
	 * AccessPath.UUID_PATH_PARAM + "}"); list.add(SharingPath.CONTEXTS_PATH_PART);
	 * list.add("{" + AccessPath.CONTEXT_UUID_PATH_PARAM + "}");
	 * Access.setRESTCalledMethod(httpMethod, list, null); }
	 */

	/*
	 * GET /sharing/{TYPE_NAME}/{UUID}/contexts/ e.g GET
	 * /resource-registry/sharing/HostingNode/16032d09-3823-444e-a1ff-a67de4f350a8/
	 * contexts Where 16032d09-3823-444e-a1ff-a67de4f350a8 is the HostingNode UUID
	 * 
	 * Return a list of UUID identifying the context the instance belongs to.
	 */
	@GET
	@Path("{" + AccessPath.TYPE_PATH_PARAM + "}" + "/{" + AccessPath.UUID_PATH_PARAM + "}/"
			+ SharingPath.CONTEXTS_PATH_PART)
	@Produces(ResourceInitializer.APPLICATION_JSON_CHARSET_UTF_8)
	public String getInstanceContexts(@PathParam(AccessPath.TYPE_PATH_PARAM) String type,
			@PathParam(AccessPath.UUID_PATH_PARAM) String instanceId,
			@PathParam(AccessPath.CONTEXT_UUID_PATH_PARAM) String contextId)
			throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
		logger.info("Requested to get contexts of {} with UUID {}", type, instanceId);
		CalledMethodProvider.instance.set("getInstanceContexts");

		@SuppressWarnings("rawtypes")
		ElementManagement erManagement = ElementManagementUtility.getERManagement(type);
		erManagement.setUUID(UUID.fromString(instanceId));
		return erManagement.getContexts();
	}

	/*
	 * PUT /sharing/{TYPE_NAME}/{UUID}/contexts/{CONTEXT_UUID} e.g PUT
	 * /resource-registry/sharing/HostingNode/16032d09-3823-444e-a1ff-a67de4f350a8/
	 * contexts/67062c11-9c3a-4906-870d-7df6a43408b0 Where
	 * 16032d09-3823-444e-a1ff-a67de4f350a8 is the HostingNode UUID and
	 * 67062c11-9c3a-4906-870d-7df6a43408b0/ is the Context UUID
	 * 
	 */
	@PUT
	@Path("{" + AccessPath.TYPE_PATH_PARAM + "}" + "/{" + AccessPath.UUID_PATH_PARAM + "}/"
			+ SharingPath.CONTEXTS_PATH_PART + "/{" + AccessPath.CONTEXT_UUID_PATH_PARAM + "}")
	public boolean add(@PathParam(AccessPath.TYPE_PATH_PARAM) String type,
			@PathParam(AccessPath.UUID_PATH_PARAM) String instanceId,
			@PathParam(AccessPath.CONTEXT_UUID_PATH_PARAM) String contextId)
			throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {

		logger.info("Requested to add {} with UUID {} to {} with UUID {}", type, instanceId, Context.NAME, contextId);
		// setRESTCalledMethod(HTTPMETHOD.PUT, type);
		CalledMethodProvider.instance.set("addToContext");

		@SuppressWarnings("rawtypes")
		ElementManagement elementManagement = ElementManagementUtility.getERManagement(type);
		elementManagement.setUUID(UUID.fromString(instanceId));
		return elementManagement.addToContext(UUID.fromString(contextId));
	}

	/*
	 * DELETE /sharing/{TYPE_NAME}/{UUID}/contexts/{CONTEXT_UUID} e.g DELETE
	 * /resource-registry/sharing/HostingNode/16032d09-3823-444e-a1ff-a67de4f350a8/
	 * contexts/67062c11-9c3a-4906-870d-7df6a43408b0 Where
	 * 16032d09-3823-444e-a1ff-a67de4f350a8 is the HostingNode UUID and
	 * 67062c11-9c3a-4906-870d-7df6a43408b0 is the Context UUID
	 * 
	 */
	@DELETE
	@Path("{" + AccessPath.TYPE_PATH_PARAM + "}" + "/{" + AccessPath.UUID_PATH_PARAM + "}/"
			+ SharingPath.CONTEXTS_PATH_PART + "/{" + AccessPath.CONTEXT_UUID_PATH_PARAM + "}")
	public Response remove(@PathParam(AccessPath.TYPE_PATH_PARAM) String type,
			@PathParam(AccessPath.UUID_PATH_PARAM) String instanceId,
			@PathParam(AccessPath.CONTEXT_UUID_PATH_PARAM) String contextId)
			throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
		logger.info("Requested to remove {} with UUID {} to {} with UUID {}", type, instanceId, Context.NAME,
				contextId);
		// setRESTCalledMethod(HTTPMETHOD.DELETE, type);
		CalledMethodProvider.instance.set("removeFromContext");

		@SuppressWarnings("rawtypes")
		ElementManagement elementManagement = ElementManagementUtility.getERManagement(type);
		elementManagement.setUUID(UUID.fromString(instanceId));
		elementManagement.removeFromContext(UUID.fromString(contextId));

		return Response.status(Status.NO_CONTENT).build();
	}

}
