/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.base;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.activation.UnsupportedDataTypeException;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.com.fasterxml.jackson.databind.node.TextNode;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.base.properties.PropertyElementManagement;
import org.gcube.informationsystem.resourceregistry.utils.HeaderOrient;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ElementManagement<El extends OElement> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Logger staticLogger = LoggerFactory.getLogger(ElementManagement.class);
    public final String AT = "@";
    public final String UNDERSCORE = "_";
    public static final String DELETED = "deleted";
    protected final Set<String> ignoreKeys;
    protected final Set<String> ignoreStartWithKeys;
    protected Class<El> elementClass;
    protected final AccessType accessType;
    protected ODatabaseDocument oDatabaseDocument;
    protected UUID uuid;
    protected JsonNode jsonNode;
    protected OClass oClass;
    protected String elementType;
    protected El element;
    protected boolean reload;
    protected SecurityContext workingContext;

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getCurrentSecurityContext();
        }
        return this.workingContext;
    }

    public void setWorkingContext(SecurityContext workingContext) {
        this.workingContext = workingContext;
    }

    protected ElementManagement(AccessType accessType) {
        this.accessType = accessType;
        this.ignoreKeys = new HashSet();
        this.ignoreStartWithKeys = new HashSet();
        this.ignoreStartWithKeys.add("@");
        this.ignoreStartWithKeys.add("_");
        this.reload = false;
    }

    public void setUUID(UUID uuid) throws ResourceRegistryException {
        this.uuid = uuid;
        if (this.jsonNode != null) {
            this.checkUUIDMatch();
        }
    }

    public void setJsonNode(JsonNode jsonNode) throws ResourceRegistryException {
        this.jsonNode = jsonNode;
        this.checkJsonNode();
    }

    public void setJson(String jsonRepresentation) throws ResourceRegistryException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.jsonNode = mapper.readTree(jsonRepresentation);
        }
        catch (IOException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        this.checkJsonNode();
    }

    public static <E extends OElement> E getElementFromOptional(Optional<E> optional) throws ResourceRegistryException {
        if (optional.isPresent()) {
            return (E)((OElement)optional.get());
        }
        throw new ResourceRegistryException("An element not belonging to any defined type should not exists. Please contact the administrator.");
    }

    public static OClass getOClass(OElement oElement) throws ResourceRegistryException {
        Optional optional = oElement.getSchemaType();
        if (optional.isPresent()) {
            return (OClass)optional.get();
        }
        throw new ResourceRegistryException("An element not belonging to any defined type should not exists. Please contact the administrator.");
    }

    public void setOClass(OClass oClass) {
        this.oClass = oClass;
    }

    protected OClass getOClass() throws SchemaException, ResourceRegistryException {
        if (this.oClass == null) {
            this.oClass = this.element != null ? ElementManagement.getOClass((OElement)this.element) : ElementManagementUtility.getTypeSchema((String)this.elementType, (AccessType)this.accessType);
        }
        return this.oClass;
    }

    public void setElementType(String elementType) throws ResourceRegistryException {
        if (this.elementType == null) {
            if (elementType == null || elementType.compareTo("") == 0) {
                elementType = this.accessType.getName();
            }
            this.elementType = elementType;
        } else if (elementType.compareTo(elementType) != 0) {
            throw new ResourceRegistryException("Provided type " + elementType + " does not match with the one already known " + this.accessType);
        }
        if (this.jsonNode != null) {
            this.checkERMatch();
        }
    }

    public String getElementType() {
        return this.elementType;
    }

    protected void checkJsonNode() throws ResourceRegistryException {
        if (this.uuid == null) {
            try {
                this.uuid = org.gcube.informationsystem.utils.Utility.getUUIDFromJsonNode((JsonNode)this.jsonNode);
            }
            catch (Exception exception) {}
        } else {
            this.checkUUIDMatch();
        }
        if (this.elementType == null) {
            this.elementType = ElementManagement.getClassProperty((JsonNode)this.jsonNode);
            this.getOClass();
        } else {
            this.checkERMatch();
        }
    }

    protected void checkERMatch() throws ResourceRegistryException {
        String type;
        if (this.jsonNode != null && (type = ElementManagement.getClassProperty((JsonNode)this.jsonNode)) != null && type.compareTo(this.elementType) != 0) {
            String error = String.format("Requested type does not match with json representation %s!=%s", this.elementType, type);
            this.logger.trace(error);
            throw new ResourceRegistryException(error);
        }
        this.getOClass();
    }

    protected void checkUUIDMatch() throws ResourceRegistryException {
        UUID resourceUUID;
        Header header = null;
        try {
            header = HeaderUtility.getHeader((JsonNode)this.jsonNode, (boolean)false);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        if (header != null && (resourceUUID = header.getUUID()).compareTo(this.uuid) != 0) {
            String error = String.format("UUID provided in header (%s) differs from the one (%s) used to identify the %s instance", resourceUUID.toString(), this.uuid.toString(), this.elementType);
            throw new ResourceRegistryException(error);
        }
    }

    public JsonNode serializeSelfOnly() throws ResourceRegistryException {
        try {
            return this.toJsonNode();
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public abstract String serialize() throws ResourceRegistryException;

    public abstract JsonNode serializeAsJson() throws ResourceRegistryException;

    protected abstract El reallyCreate() throws AlreadyPresentException, ResourceRegistryException;

    public El internalCreate() throws AlreadyPresentException, ResourceRegistryException {
        try {
            this.reallyCreate();
            Header entityHeader = HeaderUtility.getHeader((JsonNode)this.jsonNode, (boolean)true);
            if (entityHeader != null) {
                this.element.setProperty("header", (Object)entityHeader);
            } else {
                entityHeader = HeaderUtility.addHeader((OElement)this.element, null);
            }
            this.getWorkingContext().addElement(this.element, this.oDatabaseDocument);
            this.element.save();
            return (El)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Creating " + this.elementType + " with " + this.jsonNode, (Throwable)e);
        }
    }

    protected abstract El reallyUpdate() throws NotFoundException, ResourceRegistryException;

    public El internalUpdate() throws NotFoundException, ResourceRegistryException {
        try {
            this.reallyUpdate();
            HeaderUtility.updateModifiedByAndLastUpdate((OElement)this.element);
            this.element.save();
            return (El)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Updating " + this.elementType + " with " + this.jsonNode, (Throwable)e);
        }
    }

    public El internalCreateOrUdate() throws ResourceRegistryException {
        try {
            return (El)this.internalUpdate();
        }
        catch (NotFoundException e) {
            return (El)this.internalCreate();
        }
    }

    protected abstract boolean reallyDelete() throws NotFoundException, ResourceRegistryException;

    public boolean internalDelete() throws NotFoundException, ResourceRegistryException {
        return this.reallyDelete();
    }

    protected abstract boolean reallyAddToContext(SecurityContext var1) throws ContextException, ResourceRegistryException;

    public boolean internalAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        try {
            boolean ret = this.reallyAddToContext(targetSecurityContext);
            HeaderUtility.updateModifiedByAndLastUpdate((OElement)this.element);
            this.element.save();
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Adding " + this.elementType + " to " + targetSecurityContext.toString(), e.getCause());
        }
    }

    protected abstract boolean reallyRemoveFromContext(SecurityContext var1) throws ContextException, ResourceRegistryException;

    public boolean internalRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        try {
            boolean ret = this.reallyRemoveFromContext(targetSecurityContext);
            HeaderUtility.updateModifiedByAndLastUpdate((OElement)this.element);
            this.element.save();
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Removing " + this.elementType + " from " + targetSecurityContext.toString(), e.getCause());
        }
    }

    public void setElement(El element) throws ResourceRegistryException {
        if (element == null) {
            throw new ResourceRegistryException("Trying to set null " + this.elementClass.getSimpleName() + " in " + this);
        }
        this.element = element;
        this.uuid = HeaderUtility.getHeader(element).getUUID();
        OClass oClass = this.getOClass();
        this.elementType = oClass.getName();
    }

    protected abstract NotFoundException getSpecificElementNotFoundException(NotFoundException var1);

    protected abstract AvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String var1);

    protected abstract AlreadyPresentException getSpecificERAlreadyPresentException(String var1);

    public El getElement() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        if (this.element == null) {
            try {
                this.element = this.retrieveElement();
            }
            catch (NotFoundException e) {
                try {
                    this.retrieveElementFromAnyContext();
                    throw this.getSpecificERAvailableInAnotherContextException(this.elementType == null ? this.accessType.getName() : this.elementType + " with UUID " + this.uuid + " is available in another " + Context.class.getSimpleName());
                }
                catch (AvailableInAnotherContextException e1) {
                    throw e1;
                }
                catch (Exception e1) {
                    throw e;
                }
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else if (this.reload) {
            this.element.reload();
        }
        return (El)this.element;
    }

    public El retrieveElement() throws NotFoundException, ResourceRegistryException {
        try {
            if (this.uuid == null) {
                throw new NotFoundException("null UUID does not allow to retrieve the Element");
            }
            return (El)Utility.getElementByUUID((ODatabaseDocument)this.oDatabaseDocument, (String)(this.elementType == null ? this.accessType.getName() : this.elementType), (UUID)this.uuid, (Class)this.elementClass);
        }
        catch (NotFoundException e) {
            throw this.getSpecificElementNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public El retrieveElementFromAnyContext() throws NotFoundException, ResourceRegistryException {
        try {
            return (El)Utility.getElementByUUIDAsAdmin((String)(this.elementType == null ? this.accessType.getName() : this.elementType), (UUID)this.uuid, (Class)this.elementClass);
        }
        catch (NotFoundException e) {
            throw this.getSpecificElementNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public abstract String reallyGetAll(boolean var1) throws ResourceRegistryException;

    public String all(boolean polymorphic) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            String string = this.reallyGetAll(polymorphic);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public boolean exists() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            this.getElement();
            boolean bl = true;
            return bl;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to find {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to find {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String createOrUpdate() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            boolean update = false;
            try {
                this.getElement();
                update = true;
                this.element = this.internalUpdate();
            }
            catch (NotFoundException e) {
                String calledMethod = CalledMethodProvider.instance.get();
                calledMethod = calledMethod.replace("update", "create");
                CalledMethodProvider.instance.set(calledMethod);
                this.element = this.internalCreate();
            }
            this.oDatabaseDocument.commit();
            if (update) {
                this.setReload(true);
            }
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to update {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to update {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String create() throws AlreadyPresentException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.element = this.internalCreate();
            this.oDatabaseDocument.commit();
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to create {}", (Object)this.accessType.getName());
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to create {}", (Object)this.accessType.getName(), (Object)e);
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String read() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            this.getElement();
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to read {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to read {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String update() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.element = this.internalUpdate();
            this.oDatabaseDocument.commit();
            this.setReload(true);
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to update {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to update {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public boolean delete() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        this.logger.debug("Going to delete {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = ContextUtility.getAdminSecurityContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            boolean deleted = this.reallyDelete();
            if (!deleted) {
                throw new ResourceRegistryException("Error while deleting " + this.accessType.getName() + " with UUID " + this.uuid);
            }
            this.oDatabaseDocument.commit();
            this.logger.info("{} with UUID {} was successfully deleted.", (Object)this.accessType.getName(), (Object)this.uuid);
            boolean bl = deleted;
            return bl;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to delete {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to delete {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public boolean addToContext(UUID contextUUID) throws NotFoundException, ContextException, ResourceRegistryException {
        this.logger.info("Going to add {} with UUID {} to Context with UUID {}", new Object[]{this.accessType.getName(), this.uuid, contextUUID});
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = ContextUtility.getAdminSecurityContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            boolean added = this.internalAddToContext(targetSecurityContext);
            this.oDatabaseDocument.commit();
            this.logger.info("{} with UUID {} successfully added to Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
            boolean bl = added;
            return bl;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public boolean removeFromContext(UUID contextUUID) throws NotFoundException, ContextException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {} from Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = ContextUtility.getAdminSecurityContext().getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            boolean removed = this.internalRemoveFromContext(targetSecurityContext);
            this.oDatabaseDocument.commit();
            this.logger.info("{} with UUID {} successfully removed from Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
            boolean bl = removed;
            return bl;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public Set<String> getContextsSet() throws NotFoundException, ContextException, ResourceRegistryException {
        this.logger.debug("Going to get contexts for {} with UUID", (Object)this.elementType, (Object)this.uuid);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            Set contexts;
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            this.oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            Set set = contexts = SecurityContext.getContexts((OElement)this.getElement());
            return set;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to get contexts for {} with UUID {}", new Object[]{this.elementType, this.uuid, e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to get contexts for {} with UUID {}", new Object[]{this.elementType, this.uuid, e});
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String getContexts() throws NotFoundException, ContextException, ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = this.getContextsAsArrayNode(objectMapper);
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException((Throwable)e);
        }
    }

    public ArrayNode getContextsAsArrayNode(ObjectMapper objectMapper) throws NotFoundException, ContextException, ResourceRegistryException {
        try {
            Set contexts = this.getContextsSet();
            ArrayNode arrayNode = objectMapper.createArrayNode();
            for (String contextUUID : contexts) {
                arrayNode.add(contextUUID);
            }
            return arrayNode;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException((Throwable)e);
        }
    }

    public static String getClassProperty(JsonNode jsonNode) {
        if (jsonNode.has("@class")) {
            return jsonNode.get("@class").asText();
        }
        return null;
    }

    public static Object getObjectFromElement(JsonNode value) throws UnsupportedDataTypeException, ResourceRegistryException {
        JsonNodeType jsonNodeType = value.getNodeType();
        switch (1.$SwitchMap$org$gcube$com$fasterxml$jackson$databind$node$JsonNodeType[jsonNodeType.ordinal()]) {
            case 1: {
                return PropertyElementManagement.getPropertyDocument((JsonNode)value);
            }
            case 2: {
                ArrayList<Object> list = new ArrayList<Object>();
                Iterator arrayElement = value.elements();
                while (arrayElement.hasNext()) {
                    JsonNode arrayNode = (JsonNode)arrayElement.next();
                    Object objectNode = ElementManagement.getObjectFromElement((JsonNode)arrayNode);
                    if (objectNode == null) continue;
                    list.add(objectNode);
                }
                return list;
            }
            case 3: {
                break;
            }
            case 4: {
                return value.asBoolean();
            }
            case 5: {
                break;
            }
            case 6: {
                if (value.isDouble() || value.isFloat()) {
                    return value.asDouble();
                }
                if (value.isBigInteger() || value.isShort() || value.isInt()) {
                    return value.asInt();
                }
                if (!value.isLong()) break;
                return value.asLong();
            }
            case 7: {
                return value.asText();
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        return null;
    }

    public static Map<String, Object> getPropertyMap(JsonNode jsonNode, Set<String> ignoreKeys, Set<String> ignoreStartWith) throws JsonProcessingException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        if (ignoreStartWith == null) {
            ignoreStartWith = new HashSet<String>();
        }
        Iterator fields = jsonNode.fields();
        block2: while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWith) {
                if (!key.startsWith(prefix)) continue;
                continue block2;
            }
            JsonNode value = (JsonNode)entry.getValue();
            Object object = null;
            try {
                object = ElementManagement.getObjectFromElement((JsonNode)value);
                if (object == null) continue;
                map.put(key, object);
            }
            catch (ResourceRegistryException e) {
                staticLogger.warn("An invalidy property has been provided. It will be ignored.");
            }
        }
        return map;
    }

    public static OElement updateProperties(OClass oClass, OElement element, JsonNode jsonNode, Set<String> ignoreKeys, Set<String> ignoreStartWithKeys) throws ResourceRegistryException {
        Map properties;
        Set oldKeys = element.getPropertyNames();
        try {
            properties = ElementManagement.getPropertyMap((JsonNode)jsonNode, ignoreKeys, ignoreStartWithKeys);
        }
        catch (IOException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        oldKeys.removeAll(properties.keySet());
        for (String key : properties.keySet()) {
            try {
                Object object = properties.get(key);
                boolean set = false;
                if (object instanceof ODocument) {
                    ODocument oDocument = (ODocument)object;
                    element.setProperty(key, (Object)oDocument, new OType[]{OType.EMBEDDED});
                    set = true;
                }
                if (object instanceof Set) {
                    element.setProperty(key, object, new OType[]{OType.EMBEDDEDSET});
                    set = true;
                }
                if (object instanceof List) {
                    element.setProperty(key, object, new OType[]{OType.EMBEDDEDLIST});
                    set = true;
                }
                if (set) continue;
                element.setProperty(key, object);
            }
            catch (Exception e) {
                String error = String.format("Error while setting property %s : %s (%s)", key, properties.get(key).toString(), e.getMessage());
                staticLogger.error(error);
                throw new ResourceRegistryException(error, (Throwable)e);
            }
        }
        block5: for (String key : oldKeys) {
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWithKeys) {
                if (!key.startsWith(prefix)) continue;
                continue block5;
            }
            element.removeProperty(key);
        }
        element.save();
        return element;
    }

    protected JsonNode getPropertyForJson(String key, Object object) throws ResourceRegistryException {
        try {
            if (object instanceof JsonNode) {
                return (JsonNode)object;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            if (key.compareTo("header") == 0) {
                HeaderOrient headerOrient = HeaderUtility.getHeaderOrient((ODocument)((ODocument)object));
                JsonNode headerJson = Utility.toJsonNode((OElement)headerOrient, (boolean)false);
                if (((Boolean)ContextUtility.getIncludeInstanceContexts().get()).booleanValue()) {
                    ((ObjectNode)headerJson).set("contexts", (JsonNode)this.getContextsAsArrayNode(objectMapper));
                }
                return headerJson;
            }
            if (this.ignoreKeys.contains(key)) {
                return null;
            }
            for (String prefix : this.ignoreStartWithKeys) {
                if (!key.startsWith(prefix)) continue;
                return null;
            }
            if (object instanceof ODocument) {
                ODocument oDocument = (ODocument)object;
                return PropertyElementManagement.getJsonNode((ODocument)oDocument);
            }
            if (object instanceof Date) {
                OProperty oProperty = this.getOClass().getProperty(key);
                OType oType = oProperty.getType();
                DateFormat dateFormat = ODateHelper.getDateTimeFormatInstance();
                switch (1.$SwitchMap$com$orientechnologies$orient$core$metadata$schema$OType[oType.ordinal()]) {
                    case 1: {
                        dateFormat = ODateHelper.getDateFormatInstance();
                        break;
                    }
                    case 2: {
                        dateFormat = ODateHelper.getDateTimeFormatInstance();
                        break;
                    }
                }
                return new TextNode(dateFormat.format((Date)object));
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                ArrayNode arrayNode = objectMapper.createArrayNode();
                for (Object o : collection) {
                    JsonNode obj = this.getPropertyForJson("PLACEHOLDER", o);
                    if (obj == null) continue;
                    arrayNode.add(obj);
                }
                return arrayNode;
            }
            return new TextNode(object.toString());
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while serializing " + key + "=" + object.toString() + " in " + this.getElement().toString(), (Throwable)e);
        }
    }

    protected Collection<String> getSuperclasses() throws SchemaException, ResourceRegistryException {
        Collection allSuperClasses = this.getOClass().getAllSuperClasses();
        HashSet<String> superClasses = new HashSet<String>();
        for (OClass oSuperClass : allSuperClasses) {
            String name = oSuperClass.getName();
            if (name.compareTo("v".toUpperCase()) == 0 || name.compareTo("e".toUpperCase()) == 0 || name.compareTo("ORestricted") == 0) continue;
            superClasses.add(name);
        }
        return superClasses;
    }

    public JsonNode toJsonNode() throws ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode objectNode = objectMapper.createObjectNode();
            OElement element = this.getElement();
            Set keys = element.getPropertyNames();
            for (String key : keys) {
                Object object;
                JsonNode jsonNode = this.getPropertyForJson(key, object = element.getProperty(key));
                if (jsonNode == null) continue;
                objectNode.replace(key, jsonNode);
            }
            OClass oClass = this.getOClass();
            String type = oClass.getName();
            objectNode.put("@class", type);
            Collection superClasses = this.getSuperclasses();
            ArrayNode arrayNode = (ArrayNode)objectMapper.valueToTree((Object)superClasses);
            objectNode.replace("@superClasses", (JsonNode)arrayNode);
            return objectNode;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while serializing " + this.getElement().toString(), (Throwable)e);
        }
    }
}

