/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceManagement
extends EntityManagement<Resource> {
    public ResourceManagement() {
        super(AccessType.RESOURCE);
    }

    public ResourceManagement(SecurityContext workingContext, ODatabaseDocument oDatabaseDocument) {
        super(AccessType.RESOURCE, workingContext, oDatabaseDocument);
    }

    protected ResourceNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
        return new ResourceNotFoundException(e.getMessage(), e.getCause());
    }

    protected ResourceAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        return new ResourceAvailableInAnotherContextException(message);
    }

    protected ResourceAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new ResourceAlreadyPresentException(message);
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        JsonNode sourceResource = this.serializeSelfOnly();
        Iterable edges = ((OVertex)this.getElement()).getEdges(ODirection.OUT);
        for (OEdge edge : edges) {
            RelationManagement relationManagement = this.getRelationManagement(edge);
            relationManagement.setReload(this.reload);
            if (relationManagement.giveMeSourceEntityManagementAsIs() == null) {
                relationManagement.setSourceEntityManagement(this);
            }
            if (relationManagement.giveMeSourceEntityManagementAsIs() != this) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("SourceEntityManagement for ");
                errorMessage.append(relationManagement.getClass().getSimpleName());
                errorMessage.append(" is not the one expected. ");
                errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(errorMessage.toString());
            }
            if (!(relationManagement instanceof ConsistsOfManagement)) continue;
            try {
                JsonNode consistsOf = relationManagement.serializeAsJson(true, true);
                sourceResource = ResourceManagement.addConsistsOf((JsonNode)sourceResource, (JsonNode)consistsOf);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw e;
            }
            catch (Exception e) {
                this.logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return sourceResource;
    }

    public static JsonNode addConsistsOf(JsonNode sourceResource, JsonNode consistsOf) throws ResourceRegistryException {
        return ResourceManagement.addRelation((JsonNode)sourceResource, (JsonNode)consistsOf, (String)AccessType.CONSISTS_OF.lowerCaseFirstCharacter());
    }

    public static JsonNode addIsRelatedTo(JsonNode sourceResource, JsonNode isRelatedTo) throws ResourceRegistryException {
        return ResourceManagement.addRelation((JsonNode)sourceResource, (JsonNode)isRelatedTo, (String)AccessType.IS_RELATED_TO.lowerCaseFirstCharacter());
    }

    protected OVertex reallyCreate() throws ResourceAlreadyPresentException, ResourceRegistryException {
        JsonNode jsonNodeArray;
        this.createVertex();
        String property = AccessType.CONSISTS_OF.lowerCaseFirstCharacter();
        if (this.jsonNode.has(property)) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode consistOfJsonNode : jsonNodeArray) {
                ConsistsOfManagement com = new ConsistsOfManagement(this.getWorkingContext(), this.oDatabaseDocument);
                com.setJsonNode(consistOfJsonNode);
                com.setSourceEntityManagement(this);
                com.internalCreate();
                this.addToRelationManagement((RelationManagement)com);
            }
        }
        if (this.jsonNode.has(property = AccessType.IS_RELATED_TO.lowerCaseFirstCharacter())) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                IsRelatedToManagement irtm = new IsRelatedToManagement(this.getWorkingContext(), this.oDatabaseDocument);
                irtm.setJsonNode(relationJsonNode);
                irtm.setSourceEntityManagement(this);
                irtm.internalCreate();
                this.addToRelationManagement((RelationManagement)irtm);
            }
        }
        return (OVertex)this.element;
    }

    protected OVertex reallyUpdate() throws ResourceNotFoundException, ResourceRegistryException {
        JsonNode jsonNodeArray;
        this.getElement();
        String property = AccessType.CONSISTS_OF.lowerCaseFirstCharacter();
        if (this.jsonNode.has(property)) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                ConsistsOfManagement com = new ConsistsOfManagement(this.getWorkingContext(), this.oDatabaseDocument);
                com.setJsonNode(relationJsonNode);
                com.internalCreateOrUdate();
                this.addToRelationManagement((RelationManagement)com);
            }
        }
        if (this.jsonNode.has(property = AccessType.IS_RELATED_TO.lowerCaseFirstCharacter())) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                IsRelatedToManagement irtm = new IsRelatedToManagement(this.getWorkingContext(), this.oDatabaseDocument);
                irtm.setJsonNode(relationJsonNode);
                irtm.internalUpdate();
                this.addToRelationManagement((RelationManagement)irtm);
            }
        }
        return (OVertex)this.element;
    }

    protected boolean reallyDelete() throws ResourceNotFoundException, ResourceRegistryException {
        this.getElement();
        Iterable iterable = ((OVertex)this.element).getEdges(ODirection.OUT);
        for (OEdge edge : iterable) {
            OClass oClass = ResourceManagement.getOClass((OElement)edge);
            IsRelatedToManagement relationManagement = null;
            if (oClass.isSubClassOf("IsRelatedTo")) {
                relationManagement = new IsRelatedToManagement(this.getWorkingContext(), this.oDatabaseDocument);
            } else if (oClass.isSubClassOf("ConsistsOf")) {
                relationManagement = new ConsistsOfManagement(this.getWorkingContext(), this.oDatabaseDocument);
            } else {
                this.logger.warn("{} is not a {} nor a {}. {}", new Object[]{Utility.toJsonString((OElement)edge, (boolean)true), "IsRelatedTo", "ConsistsOf", "This is really strange and should not occur. Please contact the system administrator."});
            }
            if (relationManagement == null) continue;
            relationManagement.setElement((OElement)edge);
            relationManagement.internalDelete();
        }
        ((OVertex)this.element).delete();
        return true;
    }

    public String all(boolean polymorphic) throws ResourceRegistryException {
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            String string = this.reallyGetAll(polymorphic);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
        }
    }
}

