/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;

@Path(value="instances")
public class InstancesManager
extends BaseRest {
    @GET
    @Path(value="/{TYPE_NAME}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String readAll(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="true") Boolean polymorphic) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested all {}instances of {}", (Object)(polymorphic != false ? "polymorphic " : ""), (Object)type);
        this.checkHierarchicalMode();
        this.checkIncludeInstancesContexts();
        CalledMethodProvider.instance.set("listInstances");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        return erManagement.all(polymorphic.booleanValue());
    }

    @HEAD
    @Path(value="/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response exists(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to check if {} with id {} exists", (Object)type, (Object)uuid);
        this.checkHierarchicalMode();
        this.checkIncludeInstancesContexts();
        CalledMethodProvider.instance.set("existInstance");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        try {
            erManagement.setUUID(UUID.fromString(uuid));
            boolean found = erManagement.exists();
            if (found) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AvailableInAnotherContextException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    @GET
    @Path(value="/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read {} with id {}", (Object)type, (Object)uuid);
        this.checkHierarchicalMode();
        this.checkIncludeInstancesContexts();
        CalledMethodProvider.instance.set("readInstance");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setElementType(type);
        erManagement.setUUID(UUID.fromString(uuid));
        return erManagement.read();
    }

    @PUT
    @Path(value="/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String updateOrCreate(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid, String json) throws ResourceRegistryException {
        this.logger.info("Requested to update/create {} with id {}", (Object)type, (Object)uuid);
        this.logger.trace("Requested to update/create {} with id {} with json {}", new Object[]{type, uuid, json});
        CalledMethodProvider.instance.set("updateInstance");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(uuid));
        erManagement.setElementType(type);
        erManagement.setJson(json);
        return erManagement.createOrUpdate();
    }

    @DELETE
    @Path(value="/{TYPE_NAME}/{UUID}")
    public Response delete(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws ResourceRegistryException {
        this.logger.info("Requested to delete {} with id {}", (Object)type, (Object)uuid);
        CalledMethodProvider.instance.set("deleteInstance");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(uuid));
        erManagement.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

