package org.gcube.informationsystem.resourceregistry.rest;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.ResourceInitializer;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.TypePath;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.types.TypeManagement;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@Path(TypePath.TYPES_PATH_PART)
public class TypeManager {
	
	private static Logger logger = LoggerFactory.getLogger(TypeManager.class);
	
	public static final String TYPE_PATH_PARAMETER = "TYPE_NAME";
	
	public TypeManager() {
		ContextUtility.getHierarchicalMode().set(false);
		ContextUtility.getIncludeInstanceContexts().set(false);
	}
	
	/*
	 * PUT /types/{TYPE_NAME}
	 * e.g. PUT /types/ContactFacet
	 * 
	 * BODY: {...}
	 * 
	 */
	@PUT
	@Path("{" + TypeManager.TYPE_PATH_PARAMETER + "}")
	@Consumes({MediaType.TEXT_PLAIN, ResourceInitializer.APPLICATION_JSON_CHARSET_UTF_8})
	@Produces(ResourceInitializer.APPLICATION_JSON_CHARSET_UTF_8)
	public Response create(@PathParam(TypeManager.TYPE_PATH_PARAMETER) String typeName, String json)
			throws SchemaException, ResourceRegistryException {
		logger.info("Requested {} creation with schema {}", typeName, json);
		CalledMethodProvider.instance.set("createType");
		
		TypeManagement schemaManagement = new TypeManagement();
		schemaManagement.setTypeName(typeName);
		schemaManagement.setJson(json);
		String ret = schemaManagement.create();
		return Response.status(Status.CREATED).entity(ret).type(ResourceInitializer.APPLICATION_JSON_CHARSET_UTF_8)
				.build();
	}
	
	/*
	 * GET /types/{TYPE_NAME}
	 * e.g. GET /types/ContactFacet?polymorphic=false
	 * 
	 */
	@GET
	@Path("{" + TypeManager.TYPE_PATH_PARAMETER + "}")
	@Produces(ResourceInitializer.APPLICATION_JSON_CHARSET_UTF_8)
	public String read(@PathParam(TypeManager.TYPE_PATH_PARAMETER) String type,
			@QueryParam(TypePath.POLYMORPHIC_QUERY_PARAMETER) @DefaultValue("false") Boolean polymorphic)
			throws SchemaNotFoundException, ResourceRegistryException {
		logger.info("Requested Schema for type {}", type);
		CalledMethodProvider.instance.set("readType");
		
		TypeManagement schemaManagement = new TypeManagement();
		schemaManagement.setTypeName(type);
		List<Type> types = schemaManagement.read(polymorphic);
		try {
			return TypeMapper.serializeTypeDefinitions(types);
		}catch (Exception e) {
			throw new ResourceRegistryException(e);
		}
	}
	
}
