/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.utils;

import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonParseException;
import org.gcube.com.fasterxml.jackson.databind.JsonMappingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.utils.HeaderOrient;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.gcube.informationsystem.utils.ElementMapper;
import org.gcube.informationsystem.utils.UUIDManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HeaderUtility {
    private static final Logger logger = LoggerFactory.getLogger(HeaderUtility.class);

    public static String getUser() {
        String user = "UNKNOWN_USER";
        try {
            user = SecretManagerProvider.instance.get().getUser().getUsername();
        }
        catch (Exception e) {
            logger.error("Unable to retrieve user. {} will be used", (Object)user);
        }
        return user;
    }

    public static Header createHeader(UUID uuid) {
        HeaderOrient header = new HeaderOrient();
        if (uuid == null) {
            uuid = UUIDManager.generateValidRandomUUID();
        }
        header.setUUID(uuid);
        String creator = HeaderUtility.getUser();
        header.setCreatedBy(creator);
        header.setLastUpdateBy(creator);
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat ft = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        logger.trace("Setting Last Update and Creation Time to " + ft.format(date));
        header.setCreationTime(date);
        header.setLastUpdateTime(date);
        return header;
    }

    public static Header getHeader(JsonNode jsonNode, boolean creation) throws JsonParseException, JsonMappingException, IOException, ResourceRegistryException {
        if (jsonNode.has("header")) {
            JsonNode headerNode = jsonNode.get("header");
            if (headerNode.isNull()) {
                return null;
            }
            HeaderOrient header = null;
            if (creation) {
                UUID uuid = UUID.fromString(headerNode.get("uuid").asText());
                if (UUIDManager.isReservedUUID((UUID)uuid)) {
                    throw new ResourceRegistryException("The provided UUID " + uuid.toString() + "is reserved. The reserved UUID are : " + UUIDManager.getAllReservedUUIDAsStrings());
                }
                header = (HeaderOrient)HeaderUtility.createHeader((UUID)uuid);
            } else {
                header = new HeaderOrient();
                header.fromJSON(headerNode.toString());
            }
            return header;
        }
        return null;
    }

    public static HeaderOrient getHeaderOrient(ODocument oDocument) throws ResourceRegistryException {
        if (oDocument instanceof HeaderOrient) {
            return (HeaderOrient)oDocument;
        }
        try {
            HeaderOrient headerOrient = new HeaderOrient();
            String json = oDocument.toJSON();
            Header header = (Header)ElementMapper.unmarshal(Header.class, (String)json);
            headerOrient.setUUID(header.getUUID());
            headerOrient.setCreatedBy(header.getCreatedBy());
            headerOrient.setCreationTime(header.getCreationTime());
            headerOrient.setLastUpdateBy(header.getLastUpdateBy());
            headerOrient.setLastUpdateTime(header.getLastUpdateTime());
            return headerOrient;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Unable to recreate Header. This is really strange and should not occur. Please contact the system administrator.");
        }
    }

    public static Header addHeader(OElement element, UUID uuid) {
        Header header = HeaderUtility.createHeader((UUID)uuid);
        element.setProperty("header", (Object)header);
        return header;
    }

    public static Header getHeader(OElement element) throws ResourceRegistryException {
        return (Header)Utility.getPropertyDocument(Header.class, (OElement)element, (String)"header");
    }

    public static void updateModifiedByAndLastUpdate(OElement element) throws ResourceRegistryException {
        ODocument oDocument = (ODocument)element.getProperty("header");
        String lastUpdateBy = HeaderUtility.getUser();
        oDocument.field("lastUpdateBy", (Object)lastUpdateBy);
        Date lastUpdateTime = Calendar.getInstance().getTime();
        oDocument.field("lastUpdateTime", (Object)lastUpdateTime);
        element.setProperty("header", (Object)oDocument);
    }
}

