/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.EntityAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.Operation;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.gcube.informationsystem.types.reference.entities.EntityType;

public abstract class EntityManagement<E extends Entity, ET extends EntityType>
extends EntityElementManagement<E, ET>
implements ERManagement {
    protected SecurityContext sourceSecurityContext;
    protected SecurityContext targetSecurityContext;
    protected boolean honourPropagationConstraintsInContextSharing;
    protected Map<String, RelationManagement<?, ?>> relationManagements;
    protected boolean forceAddToContext;
    protected boolean skipped;

    public void setSourceSecurityContext(SecurityContext sourceSecurityContext) {
        this.sourceSecurityContext = sourceSecurityContext;
    }

    public SecurityContext getSourceSecurityContext() {
        return this.sourceSecurityContext;
    }

    public void setTargetSecurityContext(SecurityContext targetSecurityContext) {
        this.targetSecurityContext = targetSecurityContext;
    }

    public SecurityContext getTargetSecurityContext() {
        return this.sourceSecurityContext;
    }

    public boolean isHonourPropagationConstraintsInContextSharing() {
        return this.honourPropagationConstraintsInContextSharing;
    }

    public void setHonourPropagationConstraintsInContextSharing(boolean honourPropagationConstraintsInContextSharing) {
        this.honourPropagationConstraintsInContextSharing = honourPropagationConstraintsInContextSharing;
    }

    protected EntityManagement(AccessType accessType) {
        super(accessType);
        this.ignoreKeys.add("header");
        this.ignoreStartWithKeys.add("in_".toLowerCase());
        this.ignoreStartWithKeys.add("out_".toLowerCase());
        this.ignoreStartWithKeys.add("in_".toUpperCase());
        this.ignoreStartWithKeys.add("out_".toUpperCase());
        this.relationManagements = new HashMap();
        this.honourPropagationConstraintsInContextSharing = true;
        this.skipped = false;
    }

    public OVertex getElement() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.element = super.getElement();
        }
        catch (NotFoundException e) {
            try {
                this.retrieveElementFromAnyContext();
                throw this.getSpecificAvailableInAnotherContextException(this.typeName == null ? this.accessType.getName() : this.typeName + " with UUID " + this.uuid + " is available in another " + Context.class.getSimpleName());
            }
            catch (AvailableInAnotherContextException e1) {
                throw e1;
            }
            catch (Exception e1) {
                throw e;
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return (OVertex)this.element;
    }

    protected RelationManagement<?, ?> getRelationManagement(OEdge edge) throws ResourceRegistryException {
        String id = edge.getIdentity().toString();
        RelationManagement relationManagement = (RelationManagement)this.relationManagements.get(id);
        if (relationManagement == null) {
            relationManagement = ElementManagementUtility.getRelationManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OEdge)edge);
            this.relationManagements.put(id, relationManagement);
        }
        return relationManagement;
    }

    public void addToRelationManagements(RelationManagement<?, ?> relationManagement) throws ResourceRegistryException {
        OEdge elem = relationManagement.getElement();
        String id = elem.getIdentity().toString();
        if (this.relationManagements.get(id) != null && this.relationManagements.get(id) != relationManagement) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Two different instance of ");
            errorMessage.append(relationManagement.getClass().getSimpleName());
            errorMessage.append(" point to the same ");
            errorMessage.append(elem.getClass().getSimpleName());
            errorMessage.append(". ");
            errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(errorMessage.toString());
        }
        this.relationManagements.put(id, relationManagement);
    }

    protected static JsonNode addRelation(JsonNode sourceResource, JsonNode relation, String arrayKey) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode relationArray = objectMapper.createArrayNode();
        try {
            if (sourceResource.has(arrayKey)) {
                relationArray = (ArrayNode)sourceResource.get(arrayKey);
            }
            relationArray.add(relation);
            ((ObjectNode)sourceResource).replace(arrayKey, (JsonNode)relationArray);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return sourceResource;
    }

    protected OVertex createVertex() throws EntityAlreadyPresentException, ResourceRegistryException {
        this.logger.trace("Going to create {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.typeName, this.jsonNode});
        try {
            if (this.oClass.isAbstract()) {
                String error = String.format("Trying to create an instance of %s of type %s which is abstract. The operation will be aborted.", this.accessType.getName(), this.typeName);
                throw new SchemaViolationException(error);
            }
            OVertex vertexEntity = this.oDatabaseDocument.newVertex(this.typeName);
            try {
                OVertex v;
                if (this.uuid != null && (v = this.getElement()) != null) {
                    String error = String.format("A %s with UUID %s already exist", this.typeName, this.uuid.toString());
                    throw this.getSpecificAlreadyPresentException(error);
                }
            }
            catch (NotFoundException e) {
                try {
                    OElement el = ElementManagementUtility.getAnyElementByUUID((UUID)this.uuid);
                    String error = String.format("UUID %s is already used by another %s. This is not allowed.", this.uuid.toString(), el instanceof OVertex ? "Entity" : "Relation");
                    throw this.getSpecificAvailableInAnotherContextException(error);
                }
                catch (NotFoundException notFoundException) {
                }
            }
            catch (AvailableInAnotherContextException e) {
                throw e;
            }
            this.element = vertexEntity;
            if (this.accessType != AccessType.RESOURCE) {
                this.updateProperties(this.oClass, this.element, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
            }
            this.logger.debug("Created {} is {}", (Object)OVertex.class.getSimpleName(), (Object)Utility.toJsonString((OElement)((OVertex)this.element), (boolean)true));
            return (OVertex)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.typeName, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.typeName + " with " + this.jsonNode, e.getCause());
        }
    }

    protected void reallyAddToContext() throws ContextException, ResourceRegistryException {
        if (!this.forceAddToContext && !this.sourceSecurityContext.isElementInContext((OElement)this.getElement())) {
            this.skipped = true;
            return;
        }
        this.targetSecurityContext.addElement((OElement)this.getElement(), this.oDatabaseDocument);
        if (this.honourPropagationConstraintsInContextSharing) {
            Iterable edges = this.getElement().getEdges(ODirection.OUT);
            for (OEdge edge : edges) {
                RelationManagement relationManagement = this.getRelationManagement(edge);
                relationManagement.setDryRun(this.dryRun);
                relationManagement.setHonourPropagationConstraintsInContextSharing(this.honourPropagationConstraintsInContextSharing);
                relationManagement.setSourceSecurityContext(this.sourceSecurityContext);
                relationManagement.setTargetSecurityContext(this.targetSecurityContext);
                relationManagement.internalAddToContext();
                this.affectedInstances.putAll(relationManagement.getAffectedInstances());
            }
        }
    }

    public void internalAddToContext() throws ContextException, ResourceRegistryException {
        try {
            this.setOperation(Operation.ADD_TO_CONTEXT);
            this.reallyAddToContext();
            if (!this.skipped) {
                HeaderUtility.updateModifiedByAndLastUpdate((OElement)this.element);
                ((OVertex)this.element).save();
                this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
                this.sanityCheck();
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Adding " + this.typeName + " to " + this.targetSecurityContext.toString(), e.getCause());
        }
    }

    public void addToContext(UUID contextUUID) throws SchemaViolationException, NotFoundException, ContextException, ResourceRegistryException {
        String contextFullName = ContextCache.getInstance().getContextFullNameByUUID(contextUUID);
        this.logger.info("Going to add {} with UUID {} to Context with UUID {} (i.e. {})", new Object[]{this.accessType.getName(), this.uuid, contextUUID, contextFullName});
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.workingContext = ContextUtility.getAdminSecurityContext();
            this.oDatabaseDocument = this.workingContext.getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.setAsEntryPoint();
            this.sourceSecurityContext = ContextUtility.getCurrentSecurityContext();
            this.targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            this.internalAddToContext();
            if (!this.dryRun) {
                this.oDatabaseDocument.commit();
            } else {
                this.oDatabaseDocument.rollback();
            }
            this.logger.info("{} with UUID {} successfully added to Context with UUID {} (i.e. {})", new Object[]{this.typeName, this.uuid, contextUUID, contextFullName});
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {} (i.e. {}) - Reason is {}", new Object[]{this.typeName, this.uuid, contextUUID, contextFullName, e.getMessage()});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {} (i.e. {})", new Object[]{this.typeName, this.uuid, contextUUID, contextFullName, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public void internalRemoveFromContext() throws ContextException, ResourceRegistryException {
        try {
            this.setOperation(Operation.REMOVE_FROM_CONTEXT);
            this.reallyRemoveFromContext();
            HeaderUtility.updateModifiedByAndLastUpdate((OElement)this.element);
            ((OVertex)this.element).save();
            this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
            this.sanityCheck();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Removing " + this.typeName + " from " + this.targetSecurityContext.toString(), e.getCause());
        }
    }

    protected void reallyRemoveFromContext() throws ContextException, ResourceRegistryException {
        if (!this.targetSecurityContext.isElementInContext((OElement)this.getElement())) {
            return;
        }
        if (this.honourPropagationConstraintsInContextSharing) {
            Iterable edges = this.getElement().getEdges(ODirection.OUT);
            for (OEdge edge : edges) {
                RelationManagement relationManagement = this.getRelationManagement(edge);
                relationManagement.setDryRun(this.dryRun);
                relationManagement.setHonourPropagationConstraintsInContextSharing(this.honourPropagationConstraintsInContextSharing);
                relationManagement.setTargetSecurityContext(this.targetSecurityContext);
                relationManagement.internalRemoveFromContext();
                this.addToRelationManagements(relationManagement);
                this.affectedInstances.putAll(relationManagement.getAffectedInstances());
            }
        }
        this.targetSecurityContext.removeElement((OElement)this.getElement(), this.oDatabaseDocument);
    }

    public void removeFromContext(UUID contextUUID) throws SchemaViolationException, NotFoundException, ContextException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {} from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID});
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.workingContext = ContextUtility.getAdminSecurityContext();
            this.oDatabaseDocument = this.workingContext.getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.setAsEntryPoint();
            this.targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            this.internalRemoveFromContext();
            if (!this.dryRun) {
                this.oDatabaseDocument.commit();
            } else {
                this.oDatabaseDocument.rollback();
            }
            this.logger.info("{} with UUID {} successfully removed from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID});
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        ORecordIteratorClass iterable = this.oDatabaseDocument.browseClass(this.typeName, polymorphic);
        for (ODocument vertex : iterable) {
            EntityManagement entityManagement = ElementManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)((OVertex)vertex));
            try {
                JsonNode jsonNode = entityManagement.serializeAsJsonNode();
                arrayNode.add(jsonNode);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public boolean propertyMatchRequestedValue(OVertex v, String key, String requestedValue, Object instanceValue) throws SchemaException, ResourceRegistryException {
        return requestedValue.compareTo(instanceValue.toString()) == 0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public String reallyQuery(String relationType, String referenceType, UUID referenceUUID, ODirection direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        objectMapper = new ObjectMapper();
        arrayNode = objectMapper.createArrayNode();
        references /* !! */  = null;
        if (referenceUUID == null) ** GOTO lbl25
        element = null;
        try {
            element = ElementManagementUtility.getAnyElementByUUID((ODatabaseDocument)this.oDatabaseDocument, (UUID)referenceUUID);
        }
        catch (ResourceRegistryException e) {
            error = String.format("No instace with UUID %s exists", new Object[]{referenceUUID.toString()});
            throw new InvalidQueryException(error);
        }
        if (element instanceof OVertex) {
            entityManagement = ElementManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)((OVertex)element));
            elementType = entityManagement.getTypeName();
            if (!(elementType.compareTo(referenceType) == 0 || polymorphic && this.getOClass().isSubClassOf(referenceType))) {
                error = String.format("Referenced instace with UUID %s is not a %s", new Object[]{referenceUUID, referenceType});
                throw new InvalidQueryException(error);
            }
            vertexes = new ArrayList<OVertex>();
            vertexes.add((OVertex)element);
            references /* !! */  = vertexes;
        } else {
            error = String.format("Referenced instace with UUID %s is not a %s", new Object[]{referenceUUID, referenceType});
            throw new InvalidQueryException(error);
lbl25:
            // 1 sources

            references /* !! */  = this.oDatabaseDocument.browseClass(referenceType, polymorphic);
        }
        analysed = new HashSet<ORID>();
        for (T r : references /* !! */ ) {
            v = (OVertex)r;
            skip = false;
            for (String key : constraint.keySet()) {
                value = constraint.get(key);
                o = v.getProperty(key);
                if (value == null) {
                    if (o == null) continue;
                    skip = true;
                    break;
                }
                if (o == null) {
                    skip = true;
                    break;
                }
                skip = this.propertyMatchRequestedValue(v, key, value, o) == false;
                if (!skip) continue;
                break;
            }
            if (skip) continue;
            directions = new ArrayList<ODirection>();
            if (direction == ODirection.BOTH) {
                directions.add(ODirection.IN);
                directions.add(ODirection.OUT);
            } else {
                directions.add(direction);
            }
            for (ODirection d : directions) {
                edges = v.getEdges(d.opposite(), new String[]{relationType});
                for (OEdge edge : edges) {
                    vertex = edge.getVertex(d);
                    vertexORID = vertex.getIdentity();
                    if (analysed.contains(vertexORID)) continue;
                    analysed.add(vertexORID);
                    if (v.getIdentity().compareTo((Object)vertexORID) == 0 || (oClass = ElementManagementUtility.getOClass((OElement)vertex)).getName().compareTo(this.typeName) != 0 && (!polymorphic || !oClass.isSubClassOf(this.typeName))) continue;
                    entityManagement = ElementManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)vertex);
                    try {
                        if (referenceUUID != null && entityManagement.getUUID().compareTo(referenceUUID) == 0) continue;
                        node = entityManagement.serializeAsJsonNode();
                        arrayNode.add(node);
                    }
                    catch (ResourceRegistryException e) {
                        this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
                    }
                }
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String reallyQueryTraversal(String relationType, String referenceType, UUID referenceUUID, ODirection direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        if (referenceUUID != null) {
            constraint.put("header.uuid", referenceUUID.toString());
        }
        StringBuilder selectStringBuilder = new StringBuilder("SELECT FROM (TRAVERSE ");
        selectStringBuilder.append(direction.name().toLowerCase());
        selectStringBuilder.append("E('");
        selectStringBuilder.append(relationType);
        selectStringBuilder.append("'), ");
        selectStringBuilder.append(direction.opposite().name().toLowerCase());
        selectStringBuilder.append("V('");
        selectStringBuilder.append(this.typeName);
        selectStringBuilder.append("') FROM (SELECT FROM ");
        selectStringBuilder.append(referenceType);
        boolean first = true;
        for (String key : constraint.keySet()) {
            if (first) {
                selectStringBuilder.append(" WHERE ");
                first = false;
            } else {
                selectStringBuilder.append(" AND ");
            }
            selectStringBuilder.append(key);
            selectStringBuilder.append("=");
            String value = constraint.get(key).trim();
            selectStringBuilder.append("'");
            selectStringBuilder.append(value);
            selectStringBuilder.append("'");
        }
        selectStringBuilder.append(" ))");
        if (!polymorphic) {
            selectStringBuilder.append(" WHERE @class='");
            selectStringBuilder.append(this.typeName);
            selectStringBuilder.append("'");
        }
        String select = selectStringBuilder.toString();
        this.logger.trace(select);
        OResultSet resultSet = this.oDatabaseDocument.command(select, new HashMap());
        while (resultSet.hasNext()) {
            OResult oResult = resultSet.next();
            OElement element = ElementManagementUtility.getElementFromOptional((Optional)oResult.getElement());
            if (polymorphic) {
                OClass oClass = null;
                try {
                    if (element instanceof OEdge) continue;
                    oClass = ElementManagementUtility.getOClass((OElement)element);
                }
                catch (Exception e) {
                    String error = String.format("Unable to detect type of %s. %s", element.toString(), "This is really strange and should not occur. Please contact the system administrator.");
                    this.logger.error(error, (Throwable)e);
                    throw new ResourceRegistryException(error);
                }
                if (oClass.isSubClassOf(this.typeName)) continue;
            }
            OVertex vertex = (OVertex)element;
            EntityManagement entityManagement = ElementManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)vertex);
            try {
                if (constraint.containsKey("header.uuid")) {
                    String uuid = constraint.get("header.uuid");
                    if (entityManagement.getUUID().compareTo(UUID.fromString(uuid)) == 0) continue;
                }
                JsonNode jsonNode = entityManagement.serializeAsJsonNode();
                arrayNode.add(jsonNode);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String query(String relationType, String referenceType, UUID referenceUUID, ODirection direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.workingContext = ContextUtility.getAdminSecurityContext();
            this.oDatabaseDocument = this.workingContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            this.setAsEntryPoint();
            this.setOperation(Operation.QUERY);
            TypesCache typesCache = TypesCache.getInstance();
            AccessType relationAccessType = typesCache.getCachedType(relationType).getAccessType();
            if (relationAccessType != AccessType.IS_RELATED_TO && relationAccessType != AccessType.CONSISTS_OF) {
                String error = String.format("%s must be a relation type", relationType);
                throw new ResourceRegistryException(error);
            }
            AccessType referenceAccessType = typesCache.getCachedType(referenceType).getAccessType();
            if (referenceAccessType != AccessType.RESOURCE && referenceAccessType != AccessType.FACET) {
                String error = String.format("%s must be a en entity type", referenceType);
                throw new ResourceRegistryException(error);
            }
            if (constraint == null) {
                constraint = new HashMap<String, String>();
            }
            switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[this.accessType.ordinal()]) {
                case 1: {
                    if (relationAccessType != AccessType.CONSISTS_OF) break;
                    if (direction != ODirection.OUT) {
                        String error = String.format("%s can only goes %s from %s.", relationType, ODirection.OUT.name(), this.typeName);
                        throw new InvalidQueryException(error);
                    }
                    if (referenceAccessType == AccessType.FACET) break;
                    String error = String.format("%s can only has as target a %s. Provided instead %s : %s", relationType, "Facet", referenceAccessType, referenceType);
                    throw new InvalidQueryException(error);
                }
                case 2: {
                    if (relationAccessType == AccessType.CONSISTS_OF && direction == ODirection.IN && referenceAccessType == AccessType.RESOURCE) break;
                    String error = String.format("%s can only has %s %s from a %s.", this.typeName, ODirection.IN.name(), "ConsistsOf", "Resource");
                    throw new InvalidQueryException(error);
                }
            }
            String string = this.reallyQuery(relationType, referenceType, referenceUUID, direction, polymorphic, constraint);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public void setForceAddToContext(Boolean forceAddToContext) {
        this.forceAddToContext = forceAddToContext;
    }
}

