/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.types.TypeManagement;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.utils.discovery.SchemaAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaActionImpl
implements SchemaAction {
    private static Logger logger = LoggerFactory.getLogger(SchemaActionImpl.class);

    public <R extends RelationElement<? extends EntityElement, ? extends EntityElement>> void manageRelationClass(Class<R> r) throws Exception {
        try {
            TypeManagement typeManagement = new TypeManagement();
            typeManagement.setTypeAndTypeName(r);
            typeManagement.create();
        }
        catch (SchemaAlreadyPresentException sape) {
            logger.warn("{} already exists. It will be ignored", (Object)TypeMapper.getType(r));
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} {}: {}", new Object[]{"RelationElement", r.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }

    public <E extends EntityElement> void manageEntityClass(Class<E> e) throws Exception {
        try {
            TypeManagement typeManagement = new TypeManagement();
            typeManagement.setTypeAndTypeName(e);
            typeManagement.create();
        }
        catch (SchemaAlreadyPresentException sape) {
            logger.warn("{} already exists. It will be ignored", (Object)TypeMapper.getType(e));
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} {}: {}", new Object[]{"EntityElement", e.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }

    public <P extends PropertyElement> void managePropertyClass(Class<P> p) throws Exception {
        try {
            TypeManagement typeManagement = new TypeManagement();
            typeManagement.setTypeAndTypeName(p);
            if (p.equals(Property.class) || p.equals(Header.class)) {
                typeManagement.setSkipTypeDefinitionCreation(true);
            }
            typeManagement.create();
        }
        catch (SchemaAlreadyPresentException sape) {
            logger.warn("{} already exists. It will be ignored", (Object)TypeMapper.getType(p));
        }
        catch (Exception ex) {
            logger.error("Error creating schema for {} {}: {}", new Object[]{"PropertyElement", p.getSimpleName(), ex.getMessage()});
            throw ex;
        }
    }
}

