/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.base;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.Optional;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ElementManagementUtility {
    private static Logger logger = LoggerFactory.getLogger(ElementManagementUtility.class);

    public static ElementManagement<?, ?> getERManagement(String type) throws ResourceRegistryException {
        AccessType accessType = TypesCache.getInstance().getCachedType(type).getAccessType();
        ResourceManagement erManagement = null;
        switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[accessType.ordinal()]) {
            case 1: {
                erManagement = new ResourceManagement();
                break;
            }
            case 2: {
                erManagement = new FacetManagement();
                break;
            }
            case 3: {
                erManagement = new IsRelatedToManagement();
                break;
            }
            case 4: {
                erManagement = new ConsistsOfManagement();
                break;
            }
            default: {
                throw new ResourceRegistryException(String.format("%s is not querable", type.toString()));
            }
        }
        erManagement.setElementType(type);
        return erManagement;
    }

    public static ElementManagement<?, ?> getERManagement(SecurityContext workingContext, ODatabaseDocument orientGraph, OElement element) throws ResourceRegistryException {
        if (element instanceof OVertex) {
            return ElementManagementUtility.getEntityManagement((SecurityContext)workingContext, (ODatabaseDocument)orientGraph, (OVertex)((OVertex)element));
        }
        if (element instanceof OEdge) {
            return ElementManagementUtility.getRelationManagement((SecurityContext)workingContext, (ODatabaseDocument)orientGraph, (OEdge)((OEdge)element));
        }
        throw new ResourceRegistryException(String.format("%s is not a %s nor a %s", element.getClass().getSimpleName(), "Entity", "Relation"));
    }

    public static OElement getAnyElementByUUID(UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            return Utility.getElementByUUIDAsAdmin(null, (UUID)uuid, OVertex.class);
        }
        catch (NotFoundException e) {
            return Utility.getElementByUUIDAsAdmin(null, (UUID)uuid, OEdge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static OElement getAnyElementByUUID(ODatabaseDocument oDatabaseDocument, UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            return Utility.getElementByUUID((ODatabaseDocument)oDatabaseDocument, null, (UUID)uuid, OVertex.class);
        }
        catch (NotFoundException e) {
            return Utility.getElementByUUID((ODatabaseDocument)oDatabaseDocument, null, (UUID)uuid, OEdge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static ElementManagement<?, ?> getERManagementFromUUID(SecurityContext workingContext, ODatabaseDocument orientGraph, UUID uuid) throws ResourceRegistryException {
        try {
            OElement element = ElementManagementUtility.getAnyElementByUUID((ODatabaseDocument)orientGraph, (UUID)uuid);
            return ElementManagementUtility.getERManagement((SecurityContext)workingContext, (ODatabaseDocument)orientGraph, (OElement)element);
        }
        catch (Exception e) {
            throw new ResourceRegistryException(String.format("%s does not belong to an %s nor to a %s", uuid.toString(), "Entity", "Relation"));
        }
    }

    public static EntityManagement<?, ?> getEntityManagement(SecurityContext workingContext, ODatabaseDocument oDatabaseDocument, OVertex vertex) throws ResourceRegistryException {
        if (oDatabaseDocument == null) {
            throw new ResourceRegistryException(ODatabaseDocument.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        if (vertex == null) {
            throw new ResourceRegistryException(OVertex.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        OClass oClass = null;
        try {
            oClass = ElementManagementUtility.getOClass((OElement)vertex);
        }
        catch (Exception e) {
            String error = String.format("Unable to detect type of %s. %s", vertex.toString(), "This is really strange and should not occur. Please contact the system administrator.");
            logger.error(error, (Throwable)e);
            throw new ResourceRegistryException(error);
        }
        ResourceManagement entityManagement = null;
        if (oClass.isSubClassOf("Resource")) {
            entityManagement = new ResourceManagement();
        } else if (oClass.isSubClassOf("Facet")) {
            entityManagement = new FacetManagement();
        } else {
            String error = String.format("{%s is not a %s nor a %s. %s", vertex, "Resource", "Facet", "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        entityManagement.setODatabaseDocument(oDatabaseDocument);
        entityManagement.setWorkingContext(workingContext);
        entityManagement.setElement((OElement)vertex);
        return entityManagement;
    }

    public static RelationManagement<?, ?> getRelationManagement(SecurityContext workingContext, ODatabaseDocument oDatabaseDocument, OEdge edge) throws ResourceRegistryException {
        if (oDatabaseDocument == null) {
            throw new ResourceRegistryException(ODatabaseDocument.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        if (edge == null) {
            throw new ResourceRegistryException(OEdge.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        OClass oClass = ElementManagementUtility.getOClass((OElement)edge);
        ConsistsOfManagement relationManagement = null;
        if (oClass.isSubClassOf("ConsistsOf")) {
            relationManagement = new ConsistsOfManagement();
        } else if (oClass.isSubClassOf("IsRelatedTo")) {
            relationManagement = new IsRelatedToManagement();
        } else {
            String error = String.format("{%s is not a %s nor a %s. %s", edge, "ConsistsOf", "IsRelatedTo", "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        relationManagement.setODatabaseDocument(oDatabaseDocument);
        relationManagement.setWorkingContext(workingContext);
        relationManagement.setElement((OElement)edge);
        return relationManagement;
    }

    public static <E extends OElement> E getElementFromOptional(Optional<E> optional) throws ResourceRegistryException {
        if (optional.isPresent()) {
            return (E)((OElement)optional.get());
        }
        throw new ResourceRegistryException("An element not belonging to any defined type should not exists. Please contact the administrator.");
    }

    public static OClass getOClass(OElement oElement) throws ResourceRegistryException {
        Optional optional = oElement.getSchemaType();
        if (optional.isPresent()) {
            return (OClass)optional.get();
        }
        throw new ResourceRegistryException("An element not belonging to any defined type should not exists. Please contact the administrator.");
    }
}

