/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ExceptionMapper;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;

@Provider
public class ResourceRegistryExceptionMapper
implements javax.ws.rs.ext.ExceptionMapper<ResourceRegistryException> {
    public Response toResponse(ResourceRegistryException exception) {
        Response.Status status = Response.Status.BAD_REQUEST;
        if (NotFoundException.class.isAssignableFrom(((Object)((Object)exception)).getClass())) {
            status = Response.Status.NOT_FOUND;
        } else if (AlreadyPresentException.class.isAssignableFrom(((Object)((Object)exception)).getClass())) {
            status = Response.Status.CONFLICT;
        } else if (AvailableInAnotherContextException.class.isAssignableFrom(((Object)((Object)exception)).getClass())) {
            status = Response.Status.FORBIDDEN;
        } else if (((Object)((Object)exception)).getClass() == ResourceRegistryException.class) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        try {
            String entity = ExceptionMapper.marshal((ResourceRegistryException)exception);
            MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
            return Response.status((Response.Status)status).entity((Object)entity).type(mediaType).build();
        }
        catch (Exception e) {
            String entity = exception.getMessage();
            MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
            return Response.status((Response.Status)status).entity((Object)entity).type(mediaType).build();
        }
    }
}

