/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.types.TypeManagement;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedType<T extends Type> {
    private static Logger logger = LoggerFactory.getLogger(CachedType.class);
    private static final Set<String> superClassesToBeExcluded = AccessType.names();
    protected final String typeName;
    protected OClass oClass;
    protected AccessType accessType;
    protected T type;
    protected List<String> superTypes;
    protected List<String> subTypes;
    protected Set<LinkedEntity> constraints;

    public CachedType(String typeName) {
        this.typeName = typeName;
    }

    /*
     * Exception decompiling
     */
    private OClass retrieveOClass() throws SchemaException, SchemaNotFoundException, ResourceRegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void setOClass(OClass oClass) throws SchemaNotFoundException, SchemaException, ResourceRegistryException {
        if (this.oClass == null) {
            this.oClass = oClass;
        }
    }

    private AccessType getAccessTypeFromOClass(OClass oClass) throws ResourceRegistryException {
        AccessType[] accessTypes = AccessType.values();
        for (int i = accessTypes.length - 1; i >= 0; --i) {
            AccessType accessType = accessTypes[i];
            if (!oClass.isSubClassOf(accessType.getName())) continue;
            return accessType;
        }
        throw new ResourceRegistryException(this.typeName + " is not a base type");
    }

    private List<String> getAllSuperclasses(Collection<String> superClassesToBeExcluded) throws SchemaException, ResourceRegistryException {
        TypesCache typesCache = TypesCache.getInstance();
        ArrayList<String> allSuperClasses = new ArrayList<String>();
        ArrayList superClasses = this.internalGetOClass().getSuperClasses();
        while (superClasses.size() > 0) {
            ArrayList toBeAnalysed = new ArrayList(superClasses);
            superClasses = new ArrayList();
            for (OClass oSuperClass : toBeAnalysed) {
                String name = oSuperClass.getName();
                CachedType cachedType = typesCache.getCachedType(name);
                cachedType.setOClass(oSuperClass);
                if (name.compareTo("V") == 0 || name.compareTo("E") == 0 || name.compareTo("ORestricted") == 0 || superClassesToBeExcluded.contains(name)) continue;
                allSuperClasses.add(allSuperClasses.size(), name);
                superClasses.addAll(oSuperClass.getSuperClasses());
            }
        }
        return allSuperClasses;
    }

    protected List<String> getAllSubclasses() throws SchemaException, ResourceRegistryException {
        TypesCache typesCache = TypesCache.getInstance();
        ArrayList<String> allSubClasses = new ArrayList<String>();
        ArrayList subclasses = this.internalGetOClass().getSubclasses();
        while (subclasses.size() > 0) {
            ArrayList toBeAnalysed = new ArrayList(subclasses);
            subclasses = new ArrayList();
            for (OClass oSubClass : toBeAnalysed) {
                String name = oSubClass.getName();
                CachedType cachedType = typesCache.getCachedType(name);
                cachedType.setOClass(oSubClass);
                allSubClasses.add(allSubClasses.size(), name);
                subclasses.addAll(oSubClass.getSubclasses());
            }
        }
        return allSubClasses;
    }

    private OClass internalGetOClass() throws SchemaNotFoundException, SchemaException, ResourceRegistryException {
        if (this.oClass == null) {
            this.oClass = this.retrieveOClass();
        }
        return this.oClass;
    }

    private T internalGetType() throws SchemaNotFoundException, SchemaException, ResourceRegistryException {
        if (this.type == null) {
            ElementManagement erManagement = TypeManagement.getTypeManagement((OClass)this.internalGetOClass());
            String typeString = erManagement.read();
            try {
                this.type = TypeMapper.deserializeTypeDefinition((String)typeString);
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return (T)this.type;
    }

    private AccessType internalGetAccessType() throws SchemaNotFoundException, SchemaException, ResourceRegistryException {
        if (this.accessType == null) {
            this.accessType = this.type != null ? this.type.getAccessType() : this.getAccessTypeFromOClass(this.internalGetOClass());
        }
        return this.accessType;
    }

    private List<String> internalGetSuperTypes() throws SchemaException, ResourceRegistryException {
        if (this.superTypes == null) {
            this.superTypes = this.getAllSuperclasses((Collection)superClassesToBeExcluded);
        }
        return this.superTypes;
    }

    private List<String> internalGetSubTypes() throws SchemaException, ResourceRegistryException {
        if (this.subTypes == null) {
            this.subTypes = this.getAllSubclasses();
        }
        return this.subTypes;
    }

    public synchronized OClass getOClass() throws SchemaNotFoundException, SchemaException, ResourceRegistryException {
        return this.internalGetOClass();
    }

    public synchronized T getType() throws SchemaNotFoundException, SchemaException, ResourceRegistryException {
        return (T)this.internalGetType();
    }

    public synchronized AccessType getAccessType() throws SchemaNotFoundException, SchemaException, ResourceRegistryException {
        return this.internalGetAccessType();
    }

    public synchronized List<String> getSuperTypes() throws SchemaException, ResourceRegistryException {
        return this.internalGetSuperTypes();
    }

    public synchronized List<String> getSubTypes() throws SchemaException, ResourceRegistryException {
        return this.internalGetSubTypes();
    }

    public int hashCode() {
        return Objects.hash(this.typeName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachedType other = (CachedType)obj;
        return Objects.equals(this.typeName, other.typeName);
    }

    static {
        superClassesToBeExcluded.remove(AccessType.RESOURCE.getName());
        superClassesToBeExcluded.remove(AccessType.FACET.getName());
        superClassesToBeExcluded.remove(AccessType.CONSISTS_OF.getName());
        superClassesToBeExcluded.remove(AccessType.IS_RELATED_TO.getName());
    }
}

