package org.gcube.informationsystem.resourceregistry.utils;

import java.util.Date;
import java.util.Map;
import java.util.UUID;

import org.gcube.informationsystem.model.reference.properties.Header;

import com.orientechnologies.orient.core.record.impl.ODocument;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class HeaderOrient extends ODocument implements Header {
	
	public HeaderOrient() {
		super(Header.NAME);
	}
	
	protected HeaderOrient(String iClassName) {
		super(iClassName);
	}
	
	@Override
	public UUID getUUID() {
		return UUID.fromString((String) this.field(Header.UUID_PROPERTY));
	}
	
	@Override
	public void setUUID(UUID uuid) {
		this.field(Header.UUID_PROPERTY, uuid.toString());
	}
	
	@Override
	public String getCreatedBy() {
		return this.field(Header.CREATED_BY_PROPERTY);
	}
	
	public void setCreatedBy(String createdBy) {
		this.field(Header.CREATED_BY_PROPERTY, createdBy);
	}
	
	@Override
	public Date getCreationTime() {
		return this.field(Header.CREATION_TIME_PROPERTY);
	}
	
	public void setCreationTime(Date creationTime) {
		this.field(Header.CREATION_TIME_PROPERTY, creationTime);
	}
	
	@Override
	public String getLastUpdateBy() {
		return this.field(Header.LAST_UPDATE_BY_PROPERTY);
	}
	
	public void setLastUpdateBy(String lastUpdateBy) {
		this.field(Header.LAST_UPDATE_BY_PROPERTY, lastUpdateBy);
	}
	
	@Override
	public Date getLastUpdateTime() {
		return this.field(Header.LAST_UPDATE_TIME_PROPERTY);
	}
	
	public void setLastUpdateTime(Date lastUpdateTime) {
		this.field(Header.LAST_UPDATE_TIME_PROPERTY, lastUpdateTime);
	}

	@Override
	public Map<String, Object> getAdditionalProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setAdditionalProperties(Map<String, Object> additionalProperties) {
		// TODO Auto-generated method stub
	}

	@Override
	public Object getAdditionalProperty(String key) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setAdditionalProperty(String key, Object value) {
		// TODO Auto-generated method stub
	}
	
}
