package org.gcube.informationsystem.resourceregistry.utils;

import java.security.Key;
import java.util.Map;

import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.informationsystem.model.reference.properties.Vault;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;

import com.orientechnologies.orient.core.record.impl.ODocument;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class VaultOrient extends ODocument implements org.gcube.informationsystem.model.reference.properties.Vault {
	
	protected String decryptedValue;
	protected String dbEncryptedValue;
	protected String contextEncryptedValue;
	
	public VaultOrient() {
		super(Vault.NAME);
	}
	
	protected VaultOrient(String iClassName) {
		super(iClassName);
	}

	@Override
	public String getValue() {
		return this.field(Vault.VALUE);
	}

	@Override
	public void setValue(String value) {
		this.field(Vault.VALUE, value);
	}
	
	@Override
	public String toJSON(String iFormat) {
		return super.toJSON(iFormat);
	}

	
	public String getDecryptedValue() {
		return decryptedValue;
	}

	public String getDbEncryptedValue() {
		return dbEncryptedValue;
	}

	public String getContextEncryptedValue() {
		return contextEncryptedValue;
	}
	
	public void setDecryptedValue(String decryptedValue, boolean setEncryptedForContext) throws Exception {
		this.decryptedValue = decryptedValue;
		
		// Encrypting with DB Key
		Key databaseKey = DatabaseEnvironment.getDatabaseKey();
		this.dbEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue, databaseKey);
		
		// Encrypting with Context Key (default key)
		this.contextEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue);
		
		
		if(setEncryptedForContext) {
			setValue(contextEncryptedValue);
		}else {
			setValue(dbEncryptedValue);
		}
		
	}

	@Override
	public Map<String, Object> getAdditionalProperties() {
		return null;
	}

	@Override
	public void setAdditionalProperties(Map<String, Object> additionalProperties) {
		
	}

	@Override
	public Object getAdditionalProperty(String key) {
		return null;
	}

	@Override
	public void setAdditionalProperty(String key, Object value) {

	}
	
}
