/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.security;

import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.TypeSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeSecurityContext
extends SecurityContext {
    private static Logger logger = LoggerFactory.getLogger(SecurityContext.class);
    private static final String SCHEMA_SECURITY_CONTEXT = "eeeeeeee-eeee-eeee-eeee-eeeeeeeeeeee";
    private static final UUID SCHEMA_SECURITY_CONTEXT_UUID = UUID.fromString(SCHEMA_SECURITY_CONTEXT);
    private static TypeSecurityContext instance;

    public static TypeSecurityContext getInstance() throws ResourceRegistryException {
        if (instance == null) {
            instance = new TypeSecurityContext();
            ContextUtility contextUtility = ContextUtility.getInstance();
            contextUtility.addSecurityContext(SCHEMA_SECURITY_CONTEXT, (SecurityContext)instance);
        }
        return instance;
    }

    private TypeSecurityContext() throws ResourceRegistryException {
        super(SCHEMA_SECURITY_CONTEXT_UUID, false);
    }

    protected boolean isHierarchicalMode() {
        return false;
    }

    protected ORole addExtraRules(ORole role, SecurityContext.PermissionMode permissionMode) {
        logger.trace("Adding extra rules for {}", (Object)role.getName());
        switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$contexts$security$SecurityContext$PermissionMode[permissionMode.ordinal()]) {
            case 1: {
                role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
                role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_ALL);
                role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
                break;
            }
            case 2: {
                role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_READ);
                role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_READ);
                role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_READ);
                break;
            }
        }
        return role;
    }
}

