/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.requests;

import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.gcube.informationsystem.resourceregistry.api.request.RequestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRequestInfo
implements RequestInfo {
    protected static Logger logger = LoggerFactory.getLogger(ServerRequestInfo.class);
    protected UriInfo uriInfo = null;
    protected boolean includeMeta = false;
    protected boolean allMeta = false;
    protected boolean hierarchicalMode = false;
    protected boolean includeContexts = false;

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public boolean isAllowed(String queryParameterKey) {
        switch (queryParameterKey) {
            case "includeMeta": {
                return true;
            }
            case "allMeta": {
                return true;
            }
            case "includeContexts": {
                return true;
            }
            case "hierarchical": {
                return true;
            }
        }
        return true;
    }

    public boolean setIfAllowed(String queryParameterKey, boolean bool) {
        boolean toBeSet = bool && this.isAllowed(queryParameterKey);
        switch (queryParameterKey) {
            case "includeMeta": {
                this.includeMeta = toBeSet;
                return this.includeMeta;
            }
            case "allMeta": {
                this.allMeta = toBeSet;
                return this.allMeta;
            }
            case "includeContexts": {
                this.includeContexts = toBeSet;
                return this.includeContexts;
            }
            case "hierarchical": {
                this.hierarchicalMode = toBeSet;
                return this.hierarchicalMode;
            }
        }
        return false;
    }

    public void checkQueryParameter(String queryParameterKey) {
        try {
            List queryParameterList = (List)this.uriInfo.getQueryParameters().get((Object)queryParameterKey);
            if (queryParameterList != null && queryParameterList.size() > 0) {
                String booleanString = (String)queryParameterList.get(0);
                boolean bool = Boolean.valueOf(booleanString);
                this.setIfAllowed(queryParameterKey, bool);
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to properly set the Hierarchical Mode is set", (Object)t.getMessage());
        }
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public void checkAllQueryParameters() {
        this.checkIncludeQueryParameters();
        this.checkQueryParameter("hierarchical");
    }

    public void checkIncludeQueryParameters() {
        this.checkIncludeAllMetaQueryParameters();
        this.checkQueryParameter("includeContexts");
    }

    public void checkIncludeAllMetaQueryParameters() {
        this.checkQueryParameter("includeMeta");
        this.checkQueryParameter("allMeta");
    }

    public boolean includeMeta() {
        return this.includeMeta;
    }

    public void setIncludeMeta(boolean includeMeta) {
        this.includeMeta = includeMeta;
    }

    public boolean allMeta() {
        return this.allMeta;
    }

    public void setAllMeta(boolean allMeta) {
        this.allMeta = allMeta;
    }

    public boolean isHierarchicalMode() {
        return this.hierarchicalMode;
    }

    public void setHierarchicalMode(boolean hierarchicalMode) {
        this.hierarchicalMode = hierarchicalMode;
    }

    public boolean includeContexts() {
        return this.includeContexts;
    }

    public void setIncludeContexts(boolean includeContexts) {
        this.includeContexts = includeContexts;
    }
}

