/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.api.rest.SharingPath;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagement;
import org.gcube.informationsystem.resourceregistry.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.utils.UUIDUtility;
import org.gcube.informationsystem.utils.TypeUtility;

@Path(value="sharing")
public class SharingManager
extends BaseRest {
    protected String serializeAffectedInstaces(ObjectMapper objectMapper, Map<UUID, JsonNode> affectedInstances) throws ResourceRegistryException {
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (JsonNode jsonNode : affectedInstances.values()) {
            arrayNode.add(jsonNode);
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String addRemoveNoPropagationConstraint(@PathParam(value="CONTEXT_UUID") String contextId, @QueryParam(value="operation") SharingPath.SharingOperation operation, @QueryParam(value="dryRun") @DefaultValue(value="false") Boolean dryRun, @QueryParam(value="forceAddToContext") @DefaultValue(value="false") Boolean forceAddToContext, String body) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkIncludeQueryParameters();
        try {
            StringBuffer calledMethod = new StringBuffer();
            if (dryRun == null) {
                dryRun = false;
            }
            if (dryRun.booleanValue()) {
                calledMethod.append("dryRun");
            }
            if (operation == SharingPath.SharingOperation.ADD) {
                this.logger.info("Requested {} {} to {} with UUID {}", new Object[]{dryRun != false ? "a dry run for adding" : "to add", body, "Context", contextId});
                calledMethod.append("AddToContext");
            } else {
                this.logger.info("Requested {} {} from {} with UUID {}", new Object[]{dryRun != false ? "a dry run for removing" : "to remove", body, "Context", contextId});
                calledMethod.append("RemoveFromContext");
            }
            calledMethod.append("NoPropagationConstraint");
            this.setAccountingMethod(calledMethod.toString());
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = (ArrayNode)objectMapper.readTree(body);
            HashMap<UUID, JsonNode> expectedInstances = new HashMap<UUID, JsonNode>();
            for (JsonNode node : arrayNode) {
                String type = TypeUtility.getTypeName((JsonNode)node);
                UUID uuid = UUIDUtility.getUUID((JsonNode)node);
                expectedInstances.put(uuid, node);
            }
            UUID contextUUID = UUID.fromString(contextId);
            Map affectedInstances = null;
            if (operation == SharingPath.SharingOperation.ADD) {
                // empty if block
            }
            return this.serializeAffectedInstaces(objectMapper, affectedInstances);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @POST
    @Path(value="/contexts/{CONTEXT_UUID}/{TYPE_NAME}/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String addRemove(@PathParam(value="CONTEXT_UUID") String contextId, @PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String instanceId, @QueryParam(value="operation") SharingPath.SharingOperation operation, @QueryParam(value="dryRun") @DefaultValue(value="false") Boolean dryRun, @QueryParam(value="forceAddToContext") @DefaultValue(value="false") Boolean forceAddToContext) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkIncludeQueryParameters();
        StringBuffer calledMethod = new StringBuffer();
        if (dryRun == null) {
            dryRun = false;
        }
        if (dryRun.booleanValue()) {
            calledMethod.append("dryRun");
        }
        if (operation == SharingPath.SharingOperation.ADD) {
            this.logger.info("Requested {} {} with UUID {} to {} with UUID {}", new Object[]{dryRun != false ? "a dry run for adding" : "to add", type, instanceId, "Context", contextId});
            calledMethod.append("AddToContext");
        } else {
            this.logger.info("Requested {} {} with UUID {} from {} with UUID {}", new Object[]{dryRun != false ? "a dry run for removing" : "to remove", type, instanceId, "Context", contextId});
            calledMethod.append("RemoveFromContext");
        }
        this.setAccountingMethod(calledMethod.toString());
        ElementManagement elementManagement = ElementManagementUtility.getERManagement((String)type);
        elementManagement.setUUID(UUID.fromString(instanceId));
        elementManagement.setDryRun(dryRun.booleanValue());
        UUID contextUUID = UUID.fromString(contextId);
        if (operation == SharingPath.SharingOperation.ADD) {
            ((ERManagement)elementManagement).setForceAddToContext(forceAddToContext);
            ((ERManagement)elementManagement).addToContext(contextUUID);
        } else {
            ((ERManagement)elementManagement).removeFromContext(contextUUID);
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return this.serializeAffectedInstaces(objectMapper, elementManagement.getAffectedInstances());
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }
}

