package org.gcube.informationsystem.resourceregistry.utils;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.model.reference.properties.Encrypted;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.types.CachedType;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.types.reference.properties.PropertyType;
import org.gcube.informationsystem.utils.TypeUtility;

import com.orientechnologies.orient.core.record.impl.ODocument;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class EncryptedOrient extends ODocument implements Encrypted {
	
	public static final String NAME = "Encrypted";
	public static final String VALUE = "value";
	
	protected String decryptedValue;
	protected String dbEncryptedValue;
	protected String contextEncryptedValue;
	
	public EncryptedOrient() {
		super(EncryptedOrient.NAME);
	}
	
	protected EncryptedOrient(String iClassName) {
		super(iClassName);
	}
	
	@Override
	public String getTypeName() {
		return TypeUtility.getTypeName(this.getClass());
	}
	
	@Override
	public List<String> getSupertypes() {
		TypesCache typesCache = TypesCache.getInstance();
		@SuppressWarnings("unchecked")
		CachedType<PropertyType<PropertyElement>> cachedType = (CachedType<PropertyType<PropertyElement>>) typesCache.getCachedType(getTypeName());
		try {
			return cachedType.getSuperTypes();
		} catch (Exception e) {
			List<String> list = new ArrayList<>();
			list.add(TypeUtility.getTypeName(Property.class));
			return list;
		}
	}
	
	@Override
	public String getExpectedtype() {
		return null;
	}

	public String getEncryptedValue() {
		return this.field(EncryptedOrient.VALUE);
	}

	public void setEncryptedValue(String encryptedValue) {
		this.field(EncryptedOrient.VALUE, encryptedValue);
	}
	
	public String getDecryptedValue() {
		return decryptedValue;
	}

	public String getDbEncryptedValue() {
		return dbEncryptedValue;
	}

	public String getContextEncryptedValue() {
		return contextEncryptedValue;
	}
	
	public void setDecryptedValue(String decryptedValue, boolean setEncryptedForContext) throws Exception {
		this.decryptedValue = decryptedValue;
		
		// Encrypting with DB Key
		Key databaseKey = DatabaseEnvironment.getDatabaseKey();
		this.dbEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue, databaseKey);
		
		// Encrypting with Context Key (default key)
		this.contextEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue);
		
		
		if(setEncryptedForContext) {
			setEncryptedValue(contextEncryptedValue);
		}else {
			setEncryptedValue(dbEncryptedValue);
		}
		
	}

	@Override
	public Map<String, Object> getAdditionalProperties() {
		return null;
	}

	@Override
	public void setAdditionalProperties(Map<String, Object> additionalProperties) {
		
	}

	@Override
	public Object getAdditionalProperty(String key) {
		return null;
	}

	@Override
	public void setAdditionalProperty(String key, Object value) {
			
	}
	
	@Override
	public String getValue() {
		return getEncryptedValue();
	}

	@Override
	public void setValue(String value) {
		setEncryptedValue(value);
	}
	
	@Override
	public String toJSON(String iFormat) {
		String ret =  super.toJSON(iFormat);
		ret = OrientDBUtility.replaceType(ret);
		return ret;
	}
	
}
