/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaCreationException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.types.OrientDBTypeMapping;
import org.gcube.informationsystem.resourceregistry.types.TypeManagement;
import org.gcube.informationsystem.resourceregistry.types.entities.FacetTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.entities.ResourceTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.properties.PropertyTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.relations.ConsistsOfTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.relations.IsRelatedToTypeDefinitionManagement;
import org.gcube.informationsystem.types.PropertyTypeName;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.impl.properties.PropertyDefinitionImpl;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TypeManagement {
    private static Logger logger = LoggerFactory.getLogger(TypeManagement.class);
    protected String typeName;
    protected String json;
    protected Type type;
    protected boolean skipVersionCheckOnUpdate;
    protected boolean skipTypeDefinitionCreation = false;
    private static Set<String> baseElementTypes = new HashSet();
    public static Set<String> typeList;

    public boolean isSkipVersionCheckOnUpdate() {
        return this.skipVersionCheckOnUpdate;
    }

    public void setSkipVersionCheckOnUpdate(boolean skipVersionCheckOnUpdate) {
        this.skipVersionCheckOnUpdate = skipVersionCheckOnUpdate;
    }

    public boolean isSkipTypeDefinitionCreation() {
        return this.skipTypeDefinitionCreation;
    }

    public void setSkipTypeDefinitionCreation(boolean skipTypeDefinitionCreation) {
        this.skipTypeDefinitionCreation = skipTypeDefinitionCreation;
    }

    public void setJson(String json) throws ResourceRegistryException {
        this.json = json;
        try {
            this.type = TypeMapper.deserializeTypeDefinition((String)json);
        }
        catch (Exception e) {
            logger.error("Unable to create type definition from provided json {}", (Object)json);
            throw new SchemaCreationException("Unable to create type definition from provided json" + json, (Throwable)e);
        }
    }

    protected OClass getOClass(OSchema oSchema, String typeName) throws SchemaException {
        return oSchema.getClass(typeName);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTypeAndTypeName(Class<? extends Element> clz) throws Exception {
        this.type = TypeMapper.createTypeDefinition(clz);
        this.typeName = this.type.getName();
        this.json = TypeMapper.serializeTypeDefinition((Type)this.type);
    }

    public Type getType() {
        return this.type;
    }

    private static ElementManagement<?, ?> getTypeManagement(AccessType accessType, String name) {
        PropertyTypeDefinitionManagement erManagement = null;
        switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[accessType.ordinal()]) {
            case 1: {
                erManagement = new PropertyTypeDefinitionManagement();
                erManagement.setName(name);
                break;
            }
            case 2: {
                erManagement = new ResourceTypeDefinitionManagement();
                ((ResourceTypeDefinitionManagement)erManagement).setName(name);
                break;
            }
            case 3: {
                erManagement = new FacetTypeDefinitionManagement();
                ((FacetTypeDefinitionManagement)erManagement).setName(name);
                break;
            }
            case 4: {
                erManagement = new IsRelatedToTypeDefinitionManagement();
                ((IsRelatedToTypeDefinitionManagement)erManagement).setName(name);
                break;
            }
            case 5: {
                erManagement = new ConsistsOfTypeDefinitionManagement();
                ((ConsistsOfTypeDefinitionManagement)erManagement).setName(name);
                break;
            }
        }
        return erManagement;
    }

    public static ElementManagement<?, ?> getTypeManagement(OClass oClass) {
        PropertyTypeDefinitionManagement erManagement = null;
        if (oClass.isSubClassOf("Property")) {
            erManagement = new PropertyTypeDefinitionManagement();
            erManagement.setName(oClass.getName());
        } else if (oClass.isSubClassOf("Resource")) {
            erManagement = new ResourceTypeDefinitionManagement();
            ((ResourceTypeDefinitionManagement)erManagement).setName(oClass.getName());
        } else if (oClass.isSubClassOf("Facet")) {
            erManagement = new FacetTypeDefinitionManagement();
            ((FacetTypeDefinitionManagement)erManagement).setName(oClass.getName());
        } else if (oClass.isSubClassOf("IsRelatedTo")) {
            erManagement = new IsRelatedToTypeDefinitionManagement();
            ((IsRelatedToTypeDefinitionManagement)erManagement).setName(oClass.getName());
        } else if (oClass.isSubClassOf("ConsistsOf")) {
            erManagement = new ConsistsOfTypeDefinitionManagement();
            ((ConsistsOfTypeDefinitionManagement)erManagement).setName(oClass.getName());
        }
        return erManagement;
    }

    private String getTypeAsString(ElementManagement<?, ?> erManagement) throws SchemaException {
        try {
            if (erManagement != null) {
                return erManagement.read();
            }
            throw new SchemaException("You can only request schema of IS Model types and their specilization");
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
    }

    private String getTypeAsString(OClass oClass) throws SchemaException {
        try {
            ElementManagement erManagement = TypeManagement.getTypeManagement((OClass)oClass);
            return this.getTypeAsString(erManagement);
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
    }

    private Type getType(ElementManagement<?, ?> erManagement) throws SchemaException {
        try {
            String typeString = this.getTypeAsString(erManagement);
            return TypeMapper.deserializeTypeDefinition((String)typeString);
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
    }

    private Type getType(OClass oClass) throws SchemaException {
        try {
            String typeString = this.getTypeAsString(oClass);
            return TypeMapper.deserializeTypeDefinition((String)typeString);
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
    }

    protected List<OClass> getSuperclassesAndCheckCompliancy(ODatabaseDocument oDatabaseDocument, Type type, String baseType) throws SchemaException, SchemaNotFoundException {
        Set superClasses = type.getExtendedTypes();
        if (baseType != null && (superClasses == null || superClasses.size() == 0)) {
            throw new RuntimeException(String.format("No Superclass found in schema %s. The Type Definition must extend %s", type, baseType));
        }
        OMetadata oMetadata = oDatabaseDocument.getMetadata();
        OSchema oSchema = oMetadata.getSchema();
        ArrayList<OClass> oSuperclasses = new ArrayList<OClass>();
        for (String superClass : superClasses) {
            OClass oSuperClass = this.getOClass(oSchema, superClass);
            if (oSuperClass == null) {
                throw new SchemaNotFoundException("Superclass " + superClass + " does not exists");
            }
            if (baseType != null && type.getName().compareTo(baseType) != 0 && !oSuperClass.isSubClassOf(baseType)) {
                throw new RuntimeException(superClass + " is not a subsclass of " + baseType + ". Each Superclass MUST be a subclass of " + baseType);
            }
            oSuperclasses.add(oSuperClass);
        }
        return oSuperclasses;
    }

    protected void registerTypeSchema() throws SchemaAlreadyPresentException, SchemaException {
        try (ODatabaseDocument oDatabaseDocument = null;){
            if (this.typeName.compareTo(this.type.getName()) != 0) {
                String error = String.format("Provided type name path argument %s does not match with the type name in the definition %S. Please be coherent.", this.typeName, this.type.getName());
                throw new SchemaCreationException(error);
            }
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            OMetadata oMetadata = oDatabaseDocument.getMetadata();
            OSchema oSchema = oMetadata.getSchema();
            OClass oClass = null;
            AccessType accessType = this.type.getAccessType();
            Class typeClass = accessType.getTypeClass();
            String typeName = this.type.getName();
            if (EntityElement.class.isAssignableFrom(typeClass)) {
                oClass = oDatabaseDocument.createVertexClass(typeName);
            } else if (RelationElement.class.isAssignableFrom(typeClass)) {
                oClass = oDatabaseDocument.createEdgeClass(typeName);
            } else if (PropertyElement.class.isAssignableFrom(typeClass)) {
                oClass = oSchema.createClass(typeName);
            } else {
                String error = String.format("Allowed superclass are %s, %s, %s, or any subclasses of them.", "Entity", "Relation", "Property");
                throw new SchemaCreationException(error);
            }
            try {
                Set propertyDefinitions;
                String description = this.type.getDescription();
                if (description != null && description.compareTo("") != 0) {
                    try {
                        oClass.setDescription(description);
                    }
                    catch (Exception e) {
                        logger.warn("Unable to set description. This is an orient bug. See https://github.com/orientechnologies/orientdb/issues/7065");
                    }
                }
                try {
                    oClass.setAbstract(this.type.isAbstract());
                }
                catch (Exception e) {
                    logger.error("Unable to set the Vertex Type {} as abstract. This is an OrientDB <= 2.2.12 bug. The Type will be created as it is not abstract.", (Object)this.type.getName());
                }
                if (!baseElementTypes.contains(this.type.getName())) {
                    List oSuperclasses = this.getSuperclassesAndCheckCompliancy(oDatabaseDocument, this.type, accessType.getName());
                    oClass.setSuperClasses(oSuperclasses);
                }
                if (!(this.type instanceof ResourceType) && (propertyDefinitions = this.type.getProperties()) != null) {
                    for (PropertyDefinition propertyDefinition : propertyDefinitions) {
                        PropertyTypeName propertyTypeName = ((PropertyDefinitionImpl)propertyDefinition).getPropertyTypeName();
                        if (!typeList.contains(this.type.getName())) {
                            switch (1.$SwitchMap$org$gcube$informationsystem$types$PropertyTypeName$BaseType[propertyTypeName.getBaseType().ordinal()]) {
                                case 1: {
                                    throw new UnsupportedDataTypeException(OType.EMBEDDEDLIST + " support is currently disabled due to OrientDB bug see https://github.com/orientechnologies/orientdb/issues/7354");
                                }
                                case 2: {
                                    throw new UnsupportedDataTypeException(OType.EMBEDDEDSET + " support is currently disabled due to OrientDB bug see https://github.com/orientechnologies/orientdb/issues/7354");
                                }
                            }
                        }
                        OType oType = OrientDBTypeMapping.getOTypeByBaseType((PropertyTypeName.BaseType)propertyTypeName.getBaseType());
                        OProperty op = oClass.createProperty(propertyDefinition.getName(), oType);
                        op.setDescription(propertyDefinition.getDescription());
                        op.setMandatory(false);
                        op.setNotNull(false);
                        op.setReadonly(propertyDefinition.isReadonly());
                        op.setRegexp(propertyDefinition.getRegexp());
                        if (!propertyTypeName.isGenericType()) continue;
                        if (propertyTypeName.getGenericClassName() != null) {
                            OClass linkedClass = this.getOClass(oSchema, propertyTypeName.getGenericClassName());
                            if (linkedClass == null) {
                                logger.trace("Class {} not found.", (Object)propertyTypeName.getGenericClassName());
                                throw new Exception("Class " + propertyTypeName.getGenericClassName() + " not found.");
                            }
                            if (linkedClass.isEdgeType() || linkedClass.isVertexType()) {
                                throw new Exception("A PropertyType cannot be an Entity type or a Relation type");
                            }
                            op.setLinkedClass(linkedClass);
                            continue;
                        }
                        OType linkedOType = OrientDBTypeMapping.getOTypeByBaseType((PropertyTypeName.BaseType)propertyTypeName.getGenericBaseType());
                        op.setLinkedType(OType.getById((byte)Integer.valueOf(linkedOType.ordinal()).byteValue()));
                    }
                }
                oDatabaseDocument.commit();
                logger.info("{} {} registered successfully", (Object)accessType.getName(), (Object)this.type.getName());
            }
            catch (Exception e) {
                oSchema.dropClass(this.type.getName());
                throw e;
            }
        }
    }

    private boolean superClassesMatch(Type actualTypeDefinition, Type newTypeDefinition) {
        HashSet actualSuperClasses = new HashSet(actualTypeDefinition.getExtendedTypes());
        HashSet newSuperClasses = new HashSet(newTypeDefinition.getExtendedTypes());
        if (actualSuperClasses.size() != newSuperClasses.size()) {
            return false;
        }
        actualSuperClasses.removeAll(newSuperClasses);
        if (actualSuperClasses.size() > 0) {
            return false;
        }
        actualSuperClasses = new HashSet(actualTypeDefinition.getExtendedTypes());
        newSuperClasses.removeAll(actualSuperClasses);
        return newSuperClasses.size() <= 0;
    }

    protected void updateTypeSchema(Type actualTypeDefinition, Type newTypeDefinition, AccessType baseElementAccessType) throws SchemaNotFoundException, SchemaException {
        try (ODatabaseDocument oDatabaseDocument = null;){
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.WRITER);
            OMetadata oMetadata = oDatabaseDocument.getMetadata();
            OSchema oSchema = oMetadata.getSchema();
            OClass oClass = oSchema.getClass(this.typeName);
            if (oClass == null) {
                throw new SchemaNotFoundException(this.typeName + " does not Exists");
            }
            if (!this.superClassesMatch(actualTypeDefinition, newTypeDefinition)) {
                StringBuffer error = new StringBuffer();
                error.append("The new type definition has a different set of supertypes. Actual version supertypes are: ");
                error.append(actualTypeDefinition.getExtendedTypes());
                error.append(". New version supertypes are: ");
                error.append(newTypeDefinition.getExtendedTypes());
                error.append(". This kind update is not supported for a type.");
                throw new SchemaException(error.toString());
            }
            try {
                String description = newTypeDefinition.getDescription();
                if (description != null && description.compareTo("") != 0) {
                    try {
                        oClass.setDescription(description);
                    }
                    catch (Exception e) {
                        logger.warn("Unable to set description. This is an orient bug. See https://github.com/orientechnologies/orientdb/issues/7065");
                    }
                }
                try {
                    oClass.setAbstract(newTypeDefinition.isAbstract());
                }
                catch (Exception e) {
                    logger.error("Unable to set the Vertex Type {} as abstract. This is an OrientDB <= 2.2.12 bug. The Type will be created as it is not abstract.", (Object)newTypeDefinition.getName());
                }
                if (!(newTypeDefinition instanceof ResourceType)) {
                    HashSet actualPropertyDefinitions = new HashSet(actualTypeDefinition.getProperties());
                    HashMap<String, PropertyDefinition> actualPropertyDefinitionMap = new HashMap<String, PropertyDefinition>(actualPropertyDefinitions.size());
                    for (PropertyDefinition actualPropertyDefinition : actualPropertyDefinitions) {
                        actualPropertyDefinitionMap.put(actualPropertyDefinition.getName(), actualPropertyDefinition);
                    }
                    Set newPropertyDefinitions = newTypeDefinition.getProperties();
                    HashMap<String, PropertyDefinition> newPropertyDefinitionMap = new HashMap<String, PropertyDefinition>(actualPropertyDefinitions.size());
                    for (PropertyDefinition newPropertyDefinition : newPropertyDefinitions) {
                        newPropertyDefinitionMap.put(newPropertyDefinition.getName(), newPropertyDefinition);
                    }
                    if (newPropertyDefinitions != null) {
                        for (PropertyDefinition newPropertyDefinition : newPropertyDefinitions) {
                            PropertyDefinition actualPropertyDefinition;
                            String propertyName = newPropertyDefinition.getName();
                            if (propertyName.compareTo("id") == 0 || propertyName.compareTo("metadata") == 0 || propertyName.compareTo("propagationConstraint") == 0 || newPropertyDefinition.equals(actualPropertyDefinition = (PropertyDefinition)actualPropertyDefinitionMap.get(propertyName))) continue;
                            PropertyTypeName newPropertyTypeName = ((PropertyDefinitionImpl)newPropertyDefinition).getPropertyTypeName();
                            OType oType = OrientDBTypeMapping.getOTypeByBaseType((PropertyTypeName.BaseType)newPropertyTypeName.getBaseType());
                            if (!typeList.contains(newTypeDefinition.getName())) {
                                switch (1.$SwitchMap$com$orientechnologies$orient$core$metadata$schema$OType[oType.ordinal()]) {
                                    case 1: {
                                        throw new UnsupportedDataTypeException(OType.EMBEDDEDLIST + " support is currently disabled due to OrientDB bug see https://github.com/orientechnologies/orientdb/issues/7354");
                                    }
                                    case 2: {
                                        throw new UnsupportedDataTypeException(OType.EMBEDDEDSET + " support is currently disabled due to OrientDB bug see https://github.com/orientechnologies/orientdb/issues/7354");
                                    }
                                }
                            }
                            OProperty op = actualPropertyDefinition != null ? oClass.getProperty(propertyName) : oClass.createProperty(propertyName, oType);
                            op.setDescription(newPropertyDefinition.getDescription());
                            op.setMandatory(false);
                            op.setNotNull(false);
                            op.setReadonly(newPropertyDefinition.isReadonly());
                            op.setRegexp(newPropertyDefinition.getRegexp());
                            if (!newPropertyTypeName.isGenericType()) continue;
                            if (newPropertyTypeName.getGenericClassName() != null) {
                                OClass linkedClass = this.getOClass(oSchema, newPropertyTypeName.getGenericClassName());
                                if (linkedClass == null) {
                                    logger.trace("Class {} not found.", (Object)newPropertyTypeName.getGenericClassName());
                                    throw new Exception("Class " + newPropertyTypeName.getGenericClassName() + " not found.");
                                }
                                if (linkedClass.isEdgeType() || linkedClass.isVertexType()) {
                                    throw new Exception("A PropertyType cannot be an Entity type or a Relation type");
                                }
                                op.setLinkedClass(linkedClass);
                                continue;
                            }
                            OType linkedOType = OrientDBTypeMapping.getOTypeByBaseType((PropertyTypeName.BaseType)newPropertyTypeName.getGenericBaseType());
                            op.setLinkedType(OType.getById((byte)Integer.valueOf(linkedOType.ordinal()).byteValue()));
                        }
                    }
                    for (String propertyName : newPropertyDefinitionMap.keySet()) {
                        actualPropertyDefinitionMap.remove(propertyName);
                    }
                    for (String propertyNameToRemove : actualPropertyDefinitionMap.keySet()) {
                        oClass.dropProperty(propertyNameToRemove);
                    }
                }
                oDatabaseDocument.commit();
                logger.info("{} {} updated successfully", (Object)baseElementAccessType.getName(), (Object)newTypeDefinition.getName());
            }
            catch (Exception e) {
                oSchema.dropClass(newTypeDefinition.getName());
                throw e;
            }
        }
    }

    protected List<Type> getSchema(boolean includeSubtypes) throws SchemaNotFoundException, SchemaException {
        try (ODatabaseDocument oDatabaseDocument = null;){
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            OMetadata oMetadata = oDatabaseDocument.getMetadata();
            OSchema oSchema = oMetadata.getSchema();
            OClass baseOClass = oSchema.getClass(this.typeName);
            if (baseOClass == null) {
                throw new SchemaNotFoundException(this.typeName + " does not Exists");
            }
            ArrayList<Type> typeDefinitions = new ArrayList<Type>();
            typeDefinitions.add(this.getType(baseOClass));
            if (includeSubtypes) {
                Collection subClasses = baseOClass.getAllSubclasses();
                for (OClass oClass : subClasses) {
                    typeDefinitions.add(this.getType(oClass));
                }
            }
            ArrayList<Type> arrayList = typeDefinitions;
            return arrayList;
        }
    }

    public String create() throws SchemaAlreadyPresentException, SchemaException {
        try {
            AccessType accessType = this.type.getAccessType();
            logger.info("Trying to register {} {} : {}", new Object[]{accessType.getName(), this.type.getName(), this.json});
            this.registerTypeSchema();
            PropertyTypeDefinitionManagement erManagement = null;
            switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[accessType.ordinal()]) {
                case 1: {
                    erManagement = new PropertyTypeDefinitionManagement();
                    break;
                }
                case 2: {
                    erManagement = new ResourceTypeDefinitionManagement();
                    break;
                }
                case 3: {
                    erManagement = new FacetTypeDefinitionManagement();
                    break;
                }
                case 4: {
                    erManagement = new IsRelatedToTypeDefinitionManagement();
                    break;
                }
                case 5: {
                    erManagement = new ConsistsOfTypeDefinitionManagement();
                    break;
                }
                default: {
                    return this.json;
                }
            }
            String ret = this.json;
            if (!this.skipTypeDefinitionCreation) {
                erManagement.setJson(this.json);
                ret = erManagement.create();
            }
            return ret;
        }
        catch (SchemaAlreadyPresentException e) {
            throw e;
        }
        catch (SchemaException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SchemaCreationException((Throwable)ex);
        }
    }

    public List<Type> read(boolean includeSubtypes) throws SchemaNotFoundException, SchemaException {
        return this.getSchema(includeSubtypes);
    }

    private boolean typeCanBeUpdated() throws SchemaException {
        for (AccessType accessType : AccessType.values()) {
            if (accessType.getName().compareTo(this.typeName) != 0) continue;
            return false;
        }
        return true;
    }

    public String update() throws SchemaNotFoundException, SchemaException {
        try {
            AccessType accessType = this.type.getAccessType();
            logger.info("Trying to update {} type definition", new Object[]{accessType.getName(), this.type.getName(), this.json});
            logger.debug("Trying to update {} {} : {}", new Object[]{accessType.getName(), this.type.getName(), this.json});
            if (this.typeName.compareTo(this.type.getName()) != 0) {
                String error = String.format("Provided type name path argument %s does not match with the type name in the definition %S. Please be coherent.", this.typeName, this.type.getName());
                throw new SchemaCreationException(error);
            }
            if (!this.typeCanBeUpdated()) {
                throw new SchemaException(this.typeName + " is a base type. Cannot update the definition of base types.");
            }
            ElementManagement erManagement = TypeManagement.getTypeManagement((AccessType)accessType, (String)this.type.getName());
            Type actualTypeDefinition = this.getType(erManagement);
            if (!this.skipVersionCheckOnUpdate && this.type.getVersion().compareTo(actualTypeDefinition.getVersion()) <= 0) {
                throw new SchemaAlreadyPresentException("The type " + this.type.getName() + " exists and the existing version (.i.e " + actualTypeDefinition.getVersion().toString() + ") is greater of equal to the one provided for update (i.e. " + this.type.getVersion() + ")");
            }
            this.updateTypeSchema(actualTypeDefinition, this.type, accessType);
            String ret = this.json;
            if (erManagement != null) {
                erManagement.setJson(this.json);
                ret = erManagement.update();
            }
            return ret;
        }
        catch (SchemaException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new SchemaCreationException((Throwable)ex);
        }
    }

    protected boolean delete(AccessType accessType) throws SchemaException, SchemaNotFoundException {
        try (ODatabaseDocument oDatabaseDocument = null;){
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseDocument = adminSecurityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            OMetadata oMetadata = oDatabaseDocument.getMetadata();
            OSchema oSchema = oMetadata.getSchema();
            oSchema.dropClass(this.typeName);
            ElementManagement erManagement = TypeManagement.getTypeManagement((AccessType)accessType, (String)this.typeName);
            erManagement.delete();
            oDatabaseDocument.commit();
            boolean bl = true;
            return bl;
        }
    }

    static {
        baseElementTypes.add("PropertyElement");
        baseElementTypes.add("EntityElement");
        baseElementTypes.add("RelationElement");
        typeList = new HashSet();
        typeList.add("PropertyType");
        typeList.add("LinkedEntity");
        typeList.add("EntityType");
        typeList.add("ResourceType");
        typeList.add("FacetType");
        typeList.add("RelationType");
        typeList.add("IsRelatedToType");
        typeList.add("ConsistsOfType");
    }
}

