/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.NullNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.ServerContextCache;
import org.gcube.informationsystem.resourceregistry.contexts.relations.IsParentOfManagement;
import org.gcube.informationsystem.resourceregistry.contexts.security.ContextSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.queries.operators.QueryConditionalOperator;
import org.gcube.informationsystem.resourceregistry.queries.operators.QueryLogicalOperator;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.utils.UUIDManager;
import org.gcube.informationsystem.utils.UUIDUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextManagement
extends EntityElementManagement<Context, EntityType> {
    private static Logger logger = LoggerFactory.getLogger(ContextManagement.class);
    protected String name;

    private void init() {
        this.ignoreStartWithKeys.add("parent");
        this.ignoreStartWithKeys.add("children");
        this.typeName = "Context";
        this.forceIncludeMeta = true;
        this.forceIncludeAllMeta = true;
    }

    public ContextManagement() {
        super(AccessType.CONTEXT);
        this.init();
    }

    public ContextManagement(ODatabaseDocument oDatabaseDocument) throws ResourceRegistryException {
        this();
        this.oDatabaseDocument = oDatabaseDocument;
        this.getWorkingContext();
    }

    public Map<UUID, JsonNode> getAffectedInstances() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)((OVertex)this.element).getProperty("name");
            }
        }
        return this.name;
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextSecurityContext.getInstance();
        }
        return this.workingContext;
    }

    protected ContextNotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new ContextNotFoundException(e.getMessage(), e.getCause());
    }

    protected ContextAlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new ContextAlreadyPresentException(message);
    }

    protected void checkContext(ContextManagement parentContext) throws ContextNotFoundException, ContextAlreadyPresentException, ResourceRegistryException {
        StringBuffer select = new StringBuffer();
        StringBuffer errorMessage = new StringBuffer();
        if (parentContext != null) {
            String parentId = ((OVertex)parentContext.getElement()).getIdentity().toString();
            select.append("SELECT FROM (TRAVERSE out(");
            select.append("IsParentOf");
            select.append(") FROM ");
            select.append(parentId);
            select.append(" MAXDEPTH 1) WHERE ");
            select.append("name");
            select.append(QueryConditionalOperator.EQ.getConditionalOperator());
            select.append("\"");
            select.append(this.getName());
            select.append("\"");
            select.append(QueryLogicalOperator.AND.getLogicalOperator());
            select.append("id");
            select.append(QueryConditionalOperator.NE.getConditionalOperator());
            select.append("\"");
            select.append(parentContext.uuid);
            select.append("\"");
            errorMessage.append("A ");
            errorMessage.append("Context");
            errorMessage.append(" with ");
            errorMessage.append(this.getName());
            errorMessage.append(" has been already created as child of ");
            errorMessage.append(((OVertex)parentContext.getElement()).toString());
        } else {
            select.append("SELECT FROM ");
            select.append("Context");
            select.append(" WHERE ");
            select.append("name");
            select.append(QueryConditionalOperator.EQ.getConditionalOperator());
            select.append("\"");
            select.append(this.getName());
            select.append("\"");
            select.append(QueryLogicalOperator.AND.getLogicalOperator());
            select.append("in(\"");
            select.append("IsParentOf");
            select.append("\").size() = 0");
            errorMessage.append("A root ");
            errorMessage.append("Context");
            errorMessage.append(" with ");
            errorMessage.append(this.getName());
            errorMessage.append(" already exist");
        }
        logger.trace("Checking if {} -> {}", (Object)errorMessage, (Object)select);
        OResultSet resultSet = this.oDatabaseDocument.command(select.toString(), new HashMap());
        if (resultSet != null && resultSet.hasNext()) {
            throw new ContextAlreadyPresentException(errorMessage.toString());
        }
    }

    protected JsonNode createCompleteJsonNode() throws ResourceRegistryException {
        JsonNode context = this.serializeSelfAsJsonNode();
        int count = 0;
        Iterable parents = ((OVertex)this.getElement()).getEdges(ODirection.IN);
        for (OEdge edge : parents) {
            if (++count > 1) {
                throw new ContextException("A Context can not have more than one parent");
            }
            try {
                IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
                isParentOfManagement.setElement((OElement)edge);
                isParentOfManagement.includeSource(true);
                isParentOfManagement.includeTarget(false);
                JsonNode isParentOf = isParentOfManagement.createCompleteJsonNode();
                if (isParentOf == null) continue;
                ((ObjectNode)context).replace("parent", isParentOf);
            }
            catch (Exception e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ContextException("");
            }
        }
        Iterable childrenEdges = ((OVertex)this.getElement()).getEdges(ODirection.OUT);
        for (OEdge edge : childrenEdges) {
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
            isParentOfManagement.setElement((OElement)edge);
            try {
                JsonNode isParentOf = isParentOfManagement.serializeAsJsonNode();
                context = ContextManagement.addRelation((JsonNode)context, (JsonNode)isParentOf, (String)"children");
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw e;
            }
            catch (Exception e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return context;
    }

    protected OVertex reallyCreate() throws AlreadyPresentException, ResourceRegistryException {
        SecurityContext securityContext = null;
        SecurityContext parentSecurityContext = null;
        try {
            JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
            if (isParentOfJsonNode != null && !(isParentOfJsonNode instanceof NullNode)) {
                JsonNode parentJsonNode = isParentOfJsonNode.get("source");
                ContextManagement parentContextManagement = new ContextManagement(this.oDatabaseDocument);
                parentContextManagement.setJsonNode(parentJsonNode);
                UUID parentUUID = parentContextManagement.uuid;
                parentSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(parentUUID);
                this.checkContext(parentContextManagement);
                if (this.uuid == null) {
                    this.uuid = UUIDManager.getInstance().generateValidUUID();
                }
                this.createVertex();
                IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
                isParentOfManagement.setJsonNode(isParentOfJsonNode);
                isParentOfManagement.setSourceEntityManagement((EntityElementManagement)parentContextManagement);
                isParentOfManagement.setTargetEntityManagement((EntityElementManagement)this);
                isParentOfManagement.internalCreate();
            } else {
                this.checkContext(null);
                this.createVertex();
            }
            securityContext = new SecurityContext(this.uuid);
            securityContext.setParentSecurityContext(parentSecurityContext);
            securityContext.create(this.oDatabaseDocument);
            ContextUtility.getInstance().addSecurityContext(securityContext);
            return (OVertex)this.getElement();
        }
        catch (Exception e) {
            this.oDatabaseDocument.rollback();
            if (securityContext != null) {
                securityContext.delete(this.oDatabaseDocument);
                if (parentSecurityContext != null && securityContext != null) {
                    parentSecurityContext.getChildren().remove(securityContext);
                }
                ServerContextCache.getInstance().cleanCache();
            }
            throw e;
        }
    }

    protected OVertex reallyUpdate() throws NotFoundException, ResourceRegistryException {
        boolean parentChanged = false;
        boolean nameChanged = false;
        OVertex parent = null;
        boolean found = false;
        Iterable iterable = ((OVertex)this.getElement()).getVertices(ODirection.IN, new String[]{"IsParentOf"});
        for (OVertex p : iterable) {
            if (found) {
                String message = String.format("{} has more than one parent. {}", "Context", "This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(message.toString());
            }
            parent = p;
            found = true;
        }
        ContextManagement actualParentContextManagement = null;
        if (parent != null) {
            actualParentContextManagement = new ContextManagement(this.oDatabaseDocument);
            actualParentContextManagement.setElement((OElement)parent);
        }
        ContextManagement newParentContextManagement = actualParentContextManagement;
        JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
        JsonNode parentContextJsonNode = null;
        if (isParentOfJsonNode != null && !(isParentOfJsonNode instanceof NullNode)) {
            parentContextJsonNode = isParentOfJsonNode.get("source");
        }
        if (parentContextJsonNode != null && !(parentContextJsonNode instanceof NullNode)) {
            UUID parentUUID = UUIDUtility.getUUID((JsonNode)parentContextJsonNode);
            if (actualParentContextManagement != null) {
                if (parentUUID.compareTo(actualParentContextManagement.uuid) != 0) {
                    parentChanged = true;
                }
            } else {
                parentChanged = true;
            }
            if (parentChanged) {
                newParentContextManagement = new ContextManagement(this.oDatabaseDocument);
                newParentContextManagement.setJsonNode(parentContextJsonNode);
            }
        } else if (actualParentContextManagement != null) {
            parentChanged = true;
            newParentContextManagement = null;
        }
        String oldName = (String)((OVertex)this.getElement()).getProperty("name");
        String newName = this.jsonNode.get("name").asText();
        if (oldName.compareTo(newName) != 0) {
            nameChanged = true;
            this.name = newName;
        }
        if (parentChanged || nameChanged) {
            this.checkContext(newParentContextManagement);
        }
        if (parentChanged) {
            this.move(newParentContextManagement, false);
        }
        this.element = (OVertex)this.updateProperties(this.oClass, this.getElement(), this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
        ServerContextCache.getInstance().cleanCache();
        return (OVertex)this.element;
    }

    private void move(ContextManagement newParentContextManagement, boolean check) throws ContextNotFoundException, ContextAlreadyPresentException, ResourceRegistryException {
        if (check) {
            this.checkContext(newParentContextManagement);
        }
        SecurityContext newParentSecurityContext = null;
        Iterable edges = ((OVertex)this.getElement()).getEdges(ODirection.IN, new String[]{"IsParentOf"});
        if (edges != null && edges.iterator().hasNext()) {
            Iterator edgeIterator = edges.iterator();
            OEdge edge = (OEdge)edgeIterator.next();
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement();
            isParentOfManagement.setElement((OElement)edge);
            isParentOfManagement.internalDelete();
            if (edgeIterator.hasNext()) {
                throw new ContextException("Seems that the Context has more than one Parent. This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        if (newParentContextManagement != null) {
            JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
            isParentOfManagement.setJsonNode(isParentOfJsonNode);
            isParentOfManagement.setSourceEntityManagement((EntityElementManagement)newParentContextManagement);
            isParentOfManagement.setTargetEntityManagement((EntityElementManagement)this);
            isParentOfManagement.internalCreate();
            newParentSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(newParentContextManagement.uuid);
        }
        SecurityContext thisSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(this.uuid);
        thisSecurityContext.changeParentSecurityContext(newParentSecurityContext, this.oDatabaseDocument);
    }

    protected void reallyDelete() throws NotFoundException, ResourceRegistryException {
        Iterable iterable = ((OVertex)this.getElement()).getEdges(ODirection.OUT);
        Iterator iterator = iterable.iterator();
        if (iterator.hasNext()) {
            throw new ContextException("Cannot remove a Context having children");
        }
        ((OVertex)this.element).delete();
        ContextUtility contextUtility = ContextUtility.getInstance();
        SecurityContext securityContext = contextUtility.getSecurityContextByUUID(this.uuid);
        securityContext.delete(this.oDatabaseDocument);
        ServerContextCache.getInstance().cleanCache();
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        ORecordIteratorClass iterable = this.oDatabaseDocument.browseClass(this.typeName, polymorphic);
        for (ODocument vertex : iterable) {
            ContextManagement contextManagement = new ContextManagement();
            contextManagement.setForceIncludeMeta(this.forceIncludeMeta);
            contextManagement.setForceIncludeAllMeta(this.forceIncludeAllMeta);
            contextManagement.setElement((OElement)((OVertex)vertex));
            try {
                JsonNode jsonObject = contextManagement.serializeAsJsonNode();
                arrayNode.add(jsonObject);
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String allFromServer(boolean polymorphic) throws ResourceRegistryException {
        return super.all(polymorphic);
    }

    public String all(boolean polymorphic) throws ResourceRegistryException {
        try {
            ServerContextCache contextCache = ServerContextCache.getInstance();
            List contexts = contextCache.getContexts();
            return ElementMapper.marshal((List)contexts);
        }
        catch (JsonProcessingException | ResourceRegistryException e) {
            return this.allFromServer(polymorphic);
        }
    }

    public String readFromServer() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        return super.read().toString();
    }

    public String readAsString() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            ServerContextCache contextCache = ServerContextCache.getInstance();
            return ElementMapper.marshal((Element)contextCache.getContextByUUID(this.uuid));
        }
        catch (JsonProcessingException | ResourceRegistryException e) {
            return this.readFromServer();
        }
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
    }
}

