/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.Method;

@Path(value="instances")
public class InstancesManager
extends BaseRest {
    public static final String UUID_PATH_PARAMETER = "UUID";
    public static final String INSTANCE = "Instance";
    public static final String GET_INSTANCE_CONTEXTS_METHOD = "getInstanceContexts";

    @GET
    @Path(value="/{TYPE_NAME}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String readAll(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="true") Boolean polymorphic) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested all {}instances of {}", (Object)(polymorphic != false ? "polymorphic " : ""), (Object)type);
        this.setAccountingMethod(Method.LIST, INSTANCE);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllQueryParameters();
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        return erManagement.all(polymorphic.booleanValue());
    }

    @HEAD
    @Path(value="/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response exists(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to check if {} with id {} exists", (Object)type, (Object)uuid);
        this.setAccountingMethod(Method.EXIST, INSTANCE);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkQueryParameter("hierarchical");
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        try {
            erManagement.setUUID(UUID.fromString(uuid));
            boolean found = erManagement.exists();
            if (found) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AvailableInAnotherContextException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    @GET
    @Path(value="/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read {} with id {}", (Object)type, (Object)uuid);
        this.setAccountingMethod(Method.READ, INSTANCE);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllQueryParameters();
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setElementType(type);
        erManagement.setUUID(UUID.fromString(uuid));
        return erManagement.read().toString();
    }

    @PUT
    @Path(value="/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String updateOrCreate(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid, String json) throws ResourceRegistryException {
        this.logger.info("Requested to update/create {} with id {}", (Object)type, (Object)uuid);
        this.logger.trace("Requested to update/create {} with id {} with json {}", new Object[]{type, uuid, json});
        this.setAccountingMethod(Method.UPDATE, INSTANCE);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkIncludeQueryParameters();
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(uuid));
        erManagement.setElementType(type);
        erManagement.setJson(json);
        return erManagement.createOrUpdate();
    }

    @DELETE
    @Path(value="/{TYPE_NAME}/{UUID}")
    public Response delete(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws ResourceRegistryException {
        this.logger.info("Requested to delete {} with id {}", (Object)type, (Object)uuid);
        this.setAccountingMethod(Method.DELETE, INSTANCE);
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(uuid));
        erManagement.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="{TYPE_NAME}/{UUID}/contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getInstanceContexts(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String instanceId, @PathParam(value="CONTEXT_UUID") String contextId) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        this.logger.info("Requested to get contexts of {} with UUID {}", (Object)type, (Object)instanceId);
        this.setAccountingMethod(GET_INSTANCE_CONTEXTS_METHOD);
        ElementManagement erManagement = ElementManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(instanceId));
        return erManagement.getContexts();
    }
}

