/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.queries.templates.QueryTemplateManagement;
import org.gcube.informationsystem.resourceregistry.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.Method;

@Path(value="query-templates")
public class QueryTemplateManager
extends BaseRest {
    public static final String QUERY_TEMPLATE_NAME_PATH_PARAMETER = "QUERY_TEMPLATE_NAME";

    @GET
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String all() throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read all {}s", (Object)"QueryTemplate");
        this.setAccountingMethod(Method.LIST, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkQueryParameter("includeMeta");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        return queryTemplateManagement.all(false);
    }

    @PUT
    @Path(value="{QUERY_TEMPLATE_NAME}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String updateCreate(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName, String json) throws InvalidQueryException, ResourceRegistryException {
        this.logger.info("Requested {} creation with name {} and content {}", new Object[]{"QueryTemplate", queryTemplateName, json});
        this.setAccountingMethod(Method.UPDATE, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkQueryParameter("includeMeta");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.setJson(json);
        return queryTemplateManagement.createOrUpdate();
    }

    @GET
    @Path(value="{QUERY_TEMPLATE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.READ, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkQueryParameter("includeMeta");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        return queryTemplateManagement.read();
    }

    @POST
    @Path(value="{QUERY_TEMPLATE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String run(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName, String params) throws NotFoundException, InvalidQueryException, ResourceRegistryException {
        this.logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.RUN, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllQueryParameters();
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.setParams(params);
        return queryTemplateManagement.run();
    }

    @DELETE
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Path(value="{QUERY_TEMPLATE_NAME}")
    public Response delete(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to delete {} with name {} ", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.DELETE, "QueryTemplate");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

