/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ServerContextCache;
import org.gcube.informationsystem.resourceregistry.contexts.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.resourceregistry.utils.UUIDUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextUtility {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtility.class);
    private Map<UUID, SecurityContext> contexts = new HashMap();
    private static ContextUtility contextUtility;

    public static ContextUtility getInstance() {
        if (contextUtility == null) {
            contextUtility = new ContextUtility();
        }
        return contextUtility;
    }

    private ContextUtility() {
    }

    public static String getCurrentContextFullName() {
        return SecretManagerProvider.instance.get().getContext();
    }

    public static SecurityContext getCurrentSecurityContext() throws ResourceRegistryException {
        String fullName = ContextUtility.getCurrentContextFullName();
        if (fullName == null) {
            throw new ContextException("Null Token and Scope. Please set your token first.");
        }
        return ContextUtility.getInstance().getSecurityContextByFullName(fullName);
    }

    public static AdminSecurityContext getAdminSecurityContext() throws ResourceRegistryException {
        AdminSecurityContext adminSecurityContext = AdminSecurityContext.getInstance();
        return adminSecurityContext;
    }

    public synchronized void addSecurityContext(SecurityContext securityContext) {
        this.contexts.put(securityContext.getUUID(), securityContext);
    }

    public synchronized void addSecurityContext(String fullname, SecurityContext securityContext) {
        this.contexts.put(securityContext.getUUID(), securityContext);
    }

    public synchronized SecurityContext getSecurityContextByFullName(String fullName) throws ContextException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            SecurityContext securityContext = null;
            logger.trace("Trying to get {} for {}", (Object)SecurityContext.class.getSimpleName(), (Object)fullName);
            UUID uuid = ServerContextCache.getInstance().getUUIDByFullName(fullName);
            if (uuid != null) {
                securityContext = (SecurityContext)this.contexts.get(uuid);
            }
            if (securityContext == null) {
                logger.trace("{} for {} is not in cache. Going to get it", (Object)SecurityContext.class.getSimpleName(), (Object)fullName);
                oDatabaseDocument = ContextUtility.getAdminSecurityContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
                OVertex contextVertex = this.getContextVertexByFullName(oDatabaseDocument, fullName);
                uuid = UUIDUtility.getUUID((OElement)contextVertex);
                securityContext = this.getSecurityContextByUUID(uuid, contextVertex);
                this.addSecurityContext(fullName, securityContext);
            }
            SecurityContext securityContext2 = securityContext;
            return securityContext2;
        }
        catch (ContextException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException("Unable to retrieve Context UUID from current Context", (Throwable)e);
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public SecurityContext getSecurityContextByUUID(UUID uuid) throws ResourceRegistryException {
        return this.getSecurityContextByUUID(uuid, null);
    }

    public static ODatabaseDocument getCurrentODatabaseDocumentFromThreadLocal() {
        ODatabaseDocumentInternal current = null;
        try {
            current = ODatabaseRecordThreadLocal.instance().get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OVertex getContextVertexByUUID(UUID uuid) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            OVertex oVertex;
            oDatabaseDocument = ContextUtility.getAdminSecurityContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            OVertex oVertex2 = oVertex = (OVertex)OrientDBUtility.getElementByUUID((ODatabaseDocument)oDatabaseDocument, (String)"Context", (UUID)uuid, OVertex.class);
            return oVertex2;
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    private SecurityContext getSecurityContextByUUID(UUID uuid, OVertex contextVertex) throws ResourceRegistryException {
        SecurityContext securityContext = (SecurityContext)this.contexts.get(uuid);
        if (securityContext == null) {
            securityContext = new SecurityContext(uuid);
            try {
                OVertex parentVertex;
                if (contextVertex == null) {
                    contextVertex = this.getContextVertexByUUID(uuid);
                }
                if ((parentVertex = (OVertex)contextVertex.getVertices(ODirection.IN, new String[]{"IsParentOf"}).iterator().next()) != null) {
                    UUID parentUUID = UUIDUtility.getUUID((OElement)parentVertex);
                    securityContext.setParentSecurityContext(this.getSecurityContextByUUID(parentUUID, parentVertex));
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.contexts.put(uuid, securityContext);
        }
        return securityContext;
    }

    private OVertex getContextVertexByFullName(ODatabaseDocument oDatabaseDocument, String fullName) throws ResourceRegistryException {
        logger.trace("Going to get {} {} with full name '{}'", new Object[]{"Context", OVertex.class.getSimpleName(), fullName});
        ScopeBean scopeBean = new ScopeBean(fullName);
        String name = scopeBean.name();
        String select = "SELECT FROM " + Context.class.getSimpleName() + " WHERE " + "name" + " = :name";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        OResultSet resultSet = oDatabaseDocument.query(select, map);
        if (resultSet == null || !resultSet.hasNext()) {
            throw new ContextNotFoundException("Error retrieving context with name " + fullName);
        }
        OResult oResult = resultSet.next();
        OVertex context = (OVertex)ElementManagementUtility.getElementFromOptional((Optional)oResult.getVertex());
        logger.trace("Context Representing Vertex : {}", (Object)OrientDBUtility.getAsStringForLogging((ORecord)context));
        if (resultSet.hasNext()) {
            throw new ContextNotFoundException("Found more than one context with name " + name + "but required the one with path" + fullName + ". Please Reimplement the query");
        }
        return context;
    }
}

