/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.administration.AdminEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.instances.InstanceEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.utils.TypeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ERManagementUtility {
    private static Logger staticLogger = LoggerFactory.getLogger(ERManagementUtility.class);

    public static ElementManagement<?, ?> getERManagement(String type) throws ResourceRegistryException {
        AccessType accessType = TypesCache.getInstance().getCachedType(type).getAccessType();
        ResourceManagement erManagement = null;
        switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[accessType.ordinal()]) {
            case 1: {
                erManagement = new ResourceManagement();
                break;
            }
            case 2: {
                erManagement = new FacetManagement();
                break;
            }
            case 3: {
                erManagement = new IsRelatedToManagement();
                break;
            }
            case 4: {
                erManagement = new ConsistsOfManagement();
                break;
            }
            default: {
                throw new ResourceRegistryException(String.format("%s is not querable", type.toString()));
            }
        }
        erManagement.setElementType(type);
        return erManagement;
    }

    public static ElementManagement<?, ?> getERManagementFromUUID(Environment workingContext, ODatabaseDocument orientGraph, UUID uuid) throws ResourceRegistryException {
        try {
            OElement element = ElementManagementUtility.getAnyElementByUUID((ODatabaseDocument)orientGraph, (UUID)uuid);
            return ERManagementUtility.getERManagement((Environment)workingContext, (ODatabaseDocument)orientGraph, (OElement)element);
        }
        catch (Exception e) {
            throw new ResourceRegistryException(String.format("%s does not belong to an %s nor to a %s", uuid.toString(), "Entity", "Relation"));
        }
    }

    public static ElementManagement<?, ?> getERManagement(Environment workingContext, ODatabaseDocument orientGraph, OElement element) throws ResourceRegistryException {
        if (element instanceof OVertex) {
            return ElementManagementUtility.getEntityManagement((Environment)workingContext, (ODatabaseDocument)orientGraph, (OVertex)((OVertex)element));
        }
        if (element instanceof OEdge) {
            return ElementManagementUtility.getRelationManagement((Environment)workingContext, (ODatabaseDocument)orientGraph, (OEdge)((OEdge)element));
        }
        throw new ResourceRegistryException(String.format("%s is not a %s nor a %s", element.getClass().getSimpleName(), "Entity", "Relation"));
    }

    public static Map<UUID, JsonNode> addToContextNoPropagationConstraint(Map<UUID, JsonNode> expectedInstances, UUID contextUUID, boolean dryRun) throws NotFoundException, ContextException, ResourceRegistryException {
        Set<UUID> instances = expectedInstances.keySet();
        staticLogger.info("Going to add {} to Context with UUID {} not following Propagation Constraints", instances, (Object)contextUUID);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            AdminEnvironment adminEnvironment = AdminEnvironment.getInstance();
            oDatabaseDocument = adminEnvironment.getDatabaseDocument(Environment.PermissionMode.WRITER);
            oDatabaseDocument.begin();
            InstanceEnvironment targetInstanceEnvironment = ContextUtility.getInstance().getEnvironmentByUUID(contextUUID);
            HashMap<UUID, ElementManagement> instancesManagement = new HashMap<UUID, ElementManagement>();
            Set<UUID> uuids = expectedInstances.keySet();
            for (UUID uuid : uuids) {
                String type = TypeUtility.getTypeName((JsonNode)expectedInstances.get(uuid));
                ElementManagement elementManagement = ERManagementUtility.getERManagement((String)type);
                elementManagement.setWorkingEnvironment((Environment)adminEnvironment);
                elementManagement.setODatabaseDocument(oDatabaseDocument);
                elementManagement.setUUID(uuid);
                elementManagement.setElementType(type);
                elementManagement.setDryRun(dryRun);
                ((ERManagement)elementManagement).setHonourPropagationConstraintsInContextSharing(false);
                ((ERManagement)elementManagement).setTargetInstanceEnvironment(targetInstanceEnvironment);
                ((ERManagement)elementManagement).internalAddToContext();
                instancesManagement.put(uuid, elementManagement);
            }
            oDatabaseDocument.activateOnCurrentThread();
            oDatabaseDocument.commit();
            staticLogger.info("{} successfully added to Context with UUID {} not following Propagation Constraints", instances, (Object)contextUUID);
            Map<UUID, JsonNode> map = expectedInstances;
            return map;
        }
        catch (ResourceRegistryException e) {
            staticLogger.error("Unable to add {} to Context with UUID {} not following Propagation Constraints - Reason is {}", new Object[]{instances, contextUUID, e.getMessage()});
            if (oDatabaseDocument != null) {
                oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            staticLogger.error("Unable to add {} to Context with UUID {} not following Propagation Constraints.", new Object[]{instances, contextUUID, e.getMessage()});
            if (oDatabaseDocument != null) {
                oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public static Map<UUID, JsonNode> removeFromContextNoPropagationConstraint(Map<UUID, JsonNode> expectedInstances, UUID contextUUID, boolean dryRun) throws NotFoundException, ContextException, ResourceRegistryException {
        Set<UUID> instances = expectedInstances.keySet();
        staticLogger.info("Going to remove {} from Context with UUID {} not following Propagation Constraints", instances, (Object)contextUUID);
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            AdminEnvironment adminEnvironment = AdminEnvironment.getInstance();
            oDatabaseDocument = adminEnvironment.getDatabaseDocument(Environment.PermissionMode.WRITER);
            oDatabaseDocument.begin();
            InstanceEnvironment targetInstanceEnvironment = ContextUtility.getInstance().getEnvironmentByUUID(contextUUID);
            HashMap<UUID, ElementManagement> instancesManagement = new HashMap<UUID, ElementManagement>();
            for (UUID uuid : expectedInstances.keySet()) {
                String type = TypeUtility.getTypeName((JsonNode)expectedInstances.get(uuid));
                ElementManagement elementManagement = ERManagementUtility.getERManagement((String)type);
                elementManagement.setWorkingEnvironment((Environment)adminEnvironment);
                elementManagement.setODatabaseDocument(oDatabaseDocument);
                elementManagement.setUUID(uuid);
                ((ERManagement)elementManagement).setHonourPropagationConstraintsInContextSharing(false);
                elementManagement.setDryRun(dryRun);
                ((ERManagement)elementManagement).setTargetInstanceEnvironment(targetInstanceEnvironment);
                ((ERManagement)elementManagement).internalRemoveFromContext();
                instancesManagement.put(uuid, elementManagement);
            }
            for (UUID uuid : expectedInstances.keySet()) {
                ElementManagement elementManagement = (ElementManagement)instancesManagement.get(uuid);
                elementManagement.sanityCheck();
            }
            oDatabaseDocument.commit();
            staticLogger.info("{} successfully removed from Context with UUID {} not following Propagation Constraints", instances, (Object)contextUUID);
            Map<UUID, JsonNode> map = expectedInstances;
            return map;
        }
        catch (ResourceRegistryException e) {
            staticLogger.error("Unable to remove {} from Context with UUID {} not following Propagation Constraints - Reason is {}", new Object[]{instances, contextUUID, e.getMessage()});
            if (oDatabaseDocument != null) {
                oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            staticLogger.error("Unable to remove {} from Context with UUID {} not following Propagation Constraints.", new Object[]{instances, contextUUID, e.getMessage()});
            if (oDatabaseDocument != null) {
                oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }
}

