/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base.entities;

import java.util.List;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.JsonQueryERElement;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryEntity;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryConsistsOf;

public class JsonQueryFacet
extends JsonQueryEntity {
    public static final String _SOURCE = "_source";

    public JsonQueryFacet(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
        super(jsonQuery, AccessType.FACET);
        this.fieldNamesToRemove.add(_SOURCE);
    }

    public StringBuffer createTraversalQuery(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
        StringBuffer newBuffer = new StringBuffer();
        int size = this.jsonNode.size();
        boolean traverseBackLocal = this.traverseBack;
        if (this.jsonNode.has(_SOURCE)) {
            if (!this.entryPoint) {
                throw new InvalidQueryException("_source property cannot be used in a facet if it is not the entry object");
            }
            JsonNode consistsOfNode = this.jsonNode.get(_SOURCE);
            JsonQueryConsistsOf jsonQueryConsistsOf = new JsonQueryConsistsOf(consistsOfNode);
            jsonQueryConsistsOf.setTraverseBack(traverseBackLocal);
            jsonQueryConsistsOf.setDirection(Direction.OUT);
            stringBuffer = jsonQueryConsistsOf.createTraversalQuery(stringBuffer);
            traverseBackLocal = true;
            --size;
        }
        newBuffer.append("SELECT FROM ");
        if (traverseBackLocal) {
            newBuffer.append("( ");
            newBuffer.append("TRAVERSE inV(\"");
        }
        newBuffer.append(this.type);
        if (traverseBackLocal) {
            newBuffer.append("\") FROM ( ");
            newBuffer.append(stringBuffer);
            newBuffer.append(")");
            newBuffer.append(")");
        }
        if (size > 1 || this.entryPoint) {
            newBuffer.append(" WHERE ");
        }
        if (size > 1) {
            newBuffer.append(this.addConstraints(this.jsonNode, null, null));
            if (this.entryPoint) {
                newBuffer.append(" AND ");
            }
        }
        if (this.entryPoint) {
            newBuffer.append("@class");
            newBuffer.append(" INSTANCEOF \"");
            newBuffer.append(this.type);
            newBuffer.append("\"");
        }
        return newBuffer;
    }

    protected StringBuffer getSpecificMatchQuery(List<JsonQueryERElement> childrenBreadcrumb) throws SchemaException, ResourceRegistryException {
        StringBuffer newBuffer = new StringBuffer();
        boolean traverseBack = this.traverseBack;
        if (this.jsonNode.has(_SOURCE)) {
            if (!this.entryPoint) {
                throw new InvalidQueryException("_source property cannot be used in a facet if it is not the entry object");
            }
            traverseBack = true;
            JsonNode consistsOfNode = this.jsonNode.get(_SOURCE);
            JsonQueryConsistsOf jsonQueryConsistsOf = new JsonQueryConsistsOf(consistsOfNode);
            jsonQueryConsistsOf.setTraverseBack(traverseBack);
            jsonQueryConsistsOf.setDirection(Direction.IN);
            jsonQueryConsistsOf.setBreadcrumb(childrenBreadcrumb);
            newBuffer = jsonQueryConsistsOf.createMatchQuery(newBuffer);
            newBuffer.append("\n\t");
            newBuffer.append(".inV('");
            newBuffer.append(this.type);
            newBuffer.append("')");
            newBuffer.append(" { where: ($matched.");
            newBuffer.append(this.alias);
            newBuffer.append(" == $currentMatch)}");
            traverseBack = false;
            --this.size;
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.entryPoint) {
            buffer.append("\n\t");
            buffer.append(".inV('");
            buffer.append(this.type);
            buffer.append("')");
            this.alias = this.getAlias(true);
            StringBuffer sb = null;
            if (this.size > 0) {
                sb = this.addConstraints(this.jsonNode, null, null);
            }
            buffer.append(" {");
            buffer.append(" as: ");
            buffer.append(this.alias);
            buffer.append(",");
            buffer.append(" where: ");
            if (sb != null && sb.length() > 0) {
                buffer.append("(");
            }
            buffer.append("($currentMatch['@class'] INSTANCEOF '");
            buffer.append(this.type);
            buffer.append("')");
            if (sb != null && sb.length() > 0) {
                buffer.append(" AND (");
                buffer.append(sb);
                buffer.append(")");
                buffer.append(")");
            }
            buffer.append("}");
        }
        buffer.append(newBuffer);
        return buffer;
    }
}

