/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base.relations;

import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.JsonQueryERElement;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryResource;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryRelation;

public class JsonQueryIsRelatedTo
extends JsonQueryRelation {
    protected String requestedResourceType;

    public JsonQueryIsRelatedTo(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
        super(jsonQuery, AccessType.IS_RELATED_TO);
        this.direction = null;
    }

    public String getRequestedResourceType() {
        return this.requestedResourceType;
    }

    public void setRequestedResourceType(String requestedResourceType) {
        this.requestedResourceType = requestedResourceType;
    }

    protected StringBuffer traverseBackToCallerResource(StringBuffer stringBuffer) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TRAVERSE ");
        buffer.append(this.direction.opposite().name().toLowerCase());
        buffer.append("V(\"");
        buffer.append(this.requestedResourceType);
        buffer.append("\") FROM ( ");
        buffer.append(stringBuffer);
        buffer.append(")");
        return buffer;
    }

    public StringBuffer createSelect(StringBuffer stringBuffer, boolean wrapInnerQuery) throws SchemaException, ResourceRegistryException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FROM ");
        if (wrapInnerQuery) {
            buffer.append("( ");
            buffer.append(stringBuffer);
            buffer.append(")");
        } else {
            buffer.append(this.type);
        }
        if (this.entryPoint || this.size > 1) {
            buffer.append(" WHERE ");
        }
        if (this.size > 1) {
            buffer.append(this.addConstraints(this.jsonNode, null, null));
            if (this.entryPoint) {
                buffer.append(" AND ");
            }
        }
        if (this.entryPoint) {
            buffer.append("@class");
            buffer.append(" INSTANCEOF \"");
            buffer.append(this.type);
            buffer.append("\"");
        }
        return buffer;
    }

    public void setDirectionByJson() throws InvalidQueryException {
        this.setDirectionByJson(false);
    }

    public void setDirectionByJson(boolean matchQuery) throws InvalidQueryException {
        if (this.entryPoint) {
            String error = "The function JsonQueryIsRelatedTo#setDirectionByJson() cannot be called for an entry point";
            this.logger.error(error);
            throw new InternalServerErrorException(error);
        }
        boolean found = false;
        if (this.jsonNode.has("source")) {
            this.logger.trace("{} for type {} has {} property", new Object[]{"IsRelatedTo", this.type, "source"});
            this.direction = Direction.OUT;
            found = true;
        }
        if (this.jsonNode.has("target")) {
            if (found) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("IsRelatedTo");
                buffer.append(" for type ");
                buffer.append(this.type);
                buffer.append(" has both ");
                buffer.append("source");
                buffer.append(" and ");
                buffer.append("target");
                buffer.append(" property. Only entry points can have both because one is implicit from the resource containg the ");
                buffer.append("IsRelatedTo");
                buffer.append(" relation.");
                this.logger.error("This part of the json query is not valid {}\n{}", (Object)this.jsonNode.toString(), (Object)buffer.toString());
                throw new InvalidQueryException(buffer.toString());
            }
            this.direction = Direction.IN;
        }
        if (matchQuery) {
            this.direction = this.direction.opposite();
        }
    }

    public StringBuffer createTraversalQuery(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
        StringBuffer buffer;
        JsonQueryResource jsonQueryResource;
        if (!this.entryPoint && this.direction == null) {
            throw new InternalServerErrorException("Caller Resource must invoke setDirectionByJson() first. This is a server bug. Please contact the administator. ");
        }
        boolean wrapInnerQuery = false;
        if (this.traverseBack) {
            StringBuffer buffer2 = new StringBuffer();
            buffer2.append("TRAVERSE ");
            buffer2.append(this.direction.opposite().name().toLowerCase());
            buffer2.append("E(\"");
            buffer2.append(this.type);
            buffer2.append("\") FROM ( ");
            buffer2.append(stringBuffer);
            buffer2.append(")");
            stringBuffer = buffer2;
            wrapInnerQuery = true;
        }
        Direction wrapDirection = this.direction;
        if (this.jsonNode.has("source")) {
            --this.size;
            JsonNode sourceJsonNode = this.jsonNode.get("source");
            jsonQueryResource = new JsonQueryResource(sourceJsonNode);
            wrapDirection = Direction.OUT;
            jsonQueryResource.setDirection(Direction.OUT);
            jsonQueryResource.setTraverseBack(this.traverseBack || wrapInnerQuery);
            stringBuffer = jsonQueryResource.createTraversalQuery(stringBuffer);
            wrapInnerQuery = true;
        }
        if (this.jsonNode.has("target")) {
            if (this.jsonNode.has("source")) {
                buffer = new StringBuffer();
                buffer.append("TRAVERSE ");
                buffer.append(wrapDirection.name().toLowerCase());
                buffer.append("E(\"");
                buffer.append(this.type);
                buffer.append("\") FROM ( ");
                buffer.append(stringBuffer);
                buffer.append(")");
                stringBuffer = buffer;
            }
            --this.size;
            JsonNode targetJsonNode = this.jsonNode.get("target");
            jsonQueryResource = new JsonQueryResource(targetJsonNode);
            wrapDirection = Direction.IN;
            jsonQueryResource.setDirection(Direction.IN);
            jsonQueryResource.setTraverseBack(this.traverseBack || wrapInnerQuery);
            stringBuffer = jsonQueryResource.createTraversalQuery(stringBuffer);
            wrapInnerQuery = true;
        }
        if (wrapInnerQuery) {
            buffer = new StringBuffer();
            buffer.append("TRAVERSE ");
            buffer.append(wrapDirection.name().toLowerCase());
            buffer.append("E(\"");
            buffer.append(this.type);
            buffer.append("\") FROM ( ");
            buffer.append(stringBuffer);
            buffer.append(")");
            stringBuffer = buffer;
        }
        if (this.entryPoint || this.size > 1) {
            stringBuffer = this.createSelect(stringBuffer, wrapInnerQuery);
        }
        if (!this.entryPoint) {
            stringBuffer = this.traverseBackToCallerResource(stringBuffer);
        }
        return stringBuffer;
    }

    protected StringBuffer getSpecificMatchQuery(List<JsonQueryERElement> childrenBreadcrumb) throws SchemaException, ResourceRegistryException {
        Direction direction;
        JsonQueryResource jsonQueryResource;
        if (!this.entryPoint && this.direction == null) {
            throw new InternalServerErrorException("Caller Resource must invoke setDirectionByJson() first. This is a server bug. Please contact the administator. ");
        }
        int childrenPosition = 0;
        boolean traverseBack = this.traverseBack;
        StringBuffer newBuffer = new StringBuffer();
        if (this.jsonNode.has("target")) {
            --this.size;
            JsonNode targetJsonNode = this.jsonNode.get("target");
            jsonQueryResource = new JsonQueryResource(targetJsonNode);
            direction = Direction.IN;
            jsonQueryResource.setDirection(direction);
            jsonQueryResource.setBreadcrumb(childrenBreadcrumb);
            jsonQueryResource.setPosition(childrenPosition++);
            jsonQueryResource.setTraverseBack(true);
            newBuffer = jsonQueryResource.createMatchQuery(newBuffer);
            newBuffer.append("\n\t");
            newBuffer.append(".");
            newBuffer.append(direction.name().toLowerCase());
            newBuffer.append("E('");
            newBuffer.append(this.type);
            newBuffer.append("') ");
            newBuffer.append(" { where: ($matched.");
            newBuffer.append(this.getAlias(true));
            newBuffer.append(" == $currentMatch)}");
            traverseBack = false;
        }
        if (this.jsonNode.has("source")) {
            --this.size;
            JsonNode sourceJsonNode = this.jsonNode.get("source");
            jsonQueryResource = new JsonQueryResource(sourceJsonNode);
            direction = Direction.OUT;
            jsonQueryResource.setDirection(direction);
            jsonQueryResource.setBreadcrumb(childrenBreadcrumb);
            jsonQueryResource.setPosition(childrenPosition++);
            jsonQueryResource.setTraverseBack(true);
            newBuffer = jsonQueryResource.createMatchQuery(newBuffer);
            newBuffer.append("\n\t");
            newBuffer.append(".");
            newBuffer.append(direction.name().toLowerCase());
            newBuffer.append("E('");
            newBuffer.append(this.type);
            newBuffer.append("') ");
            newBuffer.append(" { where: ($matched.");
            newBuffer.append(this.getAlias(true));
            newBuffer.append(" == $currentMatch)}");
            traverseBack = false;
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.entryPoint) {
            buffer.append("\n\t");
            buffer.append(".");
            buffer.append(this.direction.name().toLowerCase());
            buffer.append("E('");
            buffer.append(this.type);
            buffer.append("')");
            this.alias = this.getAlias(true);
            StringBuffer sb = null;
            if (this.size > 0) {
                sb = this.addConstraints(this.jsonNode, null, null);
            }
            buffer.append(" {");
            buffer.append(" as: ");
            buffer.append(this.alias);
            buffer.append(",");
            buffer.append(" where: ");
            if (sb != null && sb.length() > 0) {
                buffer.append("(");
            }
            buffer.append("($currentMatch['@class'] INSTANCEOF '");
            buffer.append(this.type);
            buffer.append("')");
            if (sb != null && sb.length() > 0) {
                buffer.append(" AND (");
                buffer.append(sb);
                buffer.append(")");
                buffer.append(")");
            }
            buffer.append("}");
        }
        buffer.append(newBuffer);
        if (traverseBack) {
            buffer.append("\n\t");
            buffer.append(".");
            buffer.append(this.direction.opposite().name().toLowerCase());
            buffer.append("E('");
            buffer.append(this.type);
            buffer.append("') ");
            buffer.append(" { where: ($matched.");
            buffer.append(this.getAlias(true));
            buffer.append(" == $currentMatch)}");
        }
        return buffer;
    }
}

