/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.request.BaseRequestInfo;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.Method;
import org.gcube.informationsystem.resourceregistry.rest.extrahttpmethods.PATCH;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;

@Path(value="contexts")
public class ContextManager
extends BaseRest {
    public static final String CONTEXT_UUID_PATH_PARAMETER = "CONTEXT_UUID";

    @GET
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String all() throws ContextNotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read all {}s", (Object)"Context");
        this.setAccountingMethod(Method.LIST, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo(BaseRequestInfo.DEFAULT_OFFSET.intValue(), BaseRequestInfo.UNBOUNDED_LIMIT.intValue());
        serverRequestInfo.setIncludeMeta(true);
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkLimitOffset();
        ContextManagement contextManagement = new ContextManagement();
        return contextManagement.all(false);
    }

    @GET
    @Path(value="{CONTEXT_UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="CONTEXT_UUID") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        if (uuid.compareTo("CURRENT_CONTEXT") == 0) {
            uuid = ContextUtility.getCurrentRequestEnvironment().getUUID().toString();
        }
        this.logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        this.setAccountingMethod(Method.READ, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setIncludeMeta(true);
        serverRequestInfo.setAllMeta(true);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.readAsString();
    }

    @PUT
    @Path(value="{CONTEXT_UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String updateCreate(@PathParam(value="CONTEXT_UUID") String uuid, String json) throws ResourceRegistryException {
        this.logger.info("Requested to update/create {} with json {} ", (Object)"Context", (Object)json);
        this.setAccountingMethod(Method.UPDATE, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setIncludeMeta(true);
        serverRequestInfo.setAllMeta(true);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        contextManagement.setJson(json);
        return contextManagement.createOrUpdate();
    }

    @PATCH
    @Path(value="{CONTEXT_UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    public String changeState(@PathParam(value="CONTEXT_UUID") String uuid, String json) throws ResourceRegistryException {
        this.logger.info("Requested to activate {} with UUID {}", (Object)"Context", (Object)uuid);
        this.setAccountingMethod(Method.UPDATE, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setIncludeMeta(true);
        serverRequestInfo.setAllMeta(true);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setJson(json);
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.changeState();
    }

    @DELETE
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Path(value="{CONTEXT_UUID}")
    public Response delete(@PathParam(value="CONTEXT_UUID") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        this.logger.info("Requested to delete {} with id {} ", (Object)"Context", (Object)uuid);
        CalledMethodProvider.instance.set("deleteContext");
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        contextManagement.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

