/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.queries.operators.ComparisonOperator;
import org.gcube.informationsystem.resourceregistry.queries.operators.LogicalOperator;
import org.gcube.informationsystem.resourceregistry.queries.operators.MatemathicsOperator;
import org.gcube.informationsystem.resourceregistry.queries.operators.ProjectionOperator;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.utils.TypeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class JsonQueryERElement {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected final String type;
    protected final JsonNode jsonNode;
    protected final AccessType accessType;
    protected final Set<String> fieldNamesToRemove;
    protected Direction direction;
    protected boolean entryPoint;
    protected boolean projection;
    protected List<JsonQueryERElement> breadcrumb;
    protected int position;
    protected String alias;
    protected List<String> fieldsToEmit;
    protected int size;
    protected boolean traverseBack;

    public static void validateType(String type, AccessType requiredAccessType) throws SchemaException, ResourceRegistryException {
        AccessType accessType = TypesCache.getInstance().getCachedType(type).getAccessType();
        if (!accessType.equals((Object)requiredAccessType)) {
            throw new InvalidQueryException(type + "is not an expected " + requiredAccessType.getName() + " type");
        }
    }

    public JsonQueryERElement(JsonNode jsonQuery, AccessType accessType) throws SchemaException, ResourceRegistryException {
        this.type = TypeUtility.getTypeName((JsonNode)jsonQuery);
        this.jsonNode = jsonQuery;
        this.size = this.jsonNode.size();
        this.accessType = accessType;
        this.entryPoint = false;
        this.traverseBack = true;
        this.projection = false;
        this.breadcrumb = new ArrayList();
        this.position = 0;
        this.alias = null;
        this.fieldsToEmit = new ArrayList();
        this.fieldNamesToRemove = new HashSet();
        this.fieldNamesToRemove.add("type");
        this.fieldNamesToRemove.add("supertypes");
        this.fieldNamesToRemove.add("expectedtype");
        JsonQueryERElement.validateType((String)this.type, (AccessType)this.accessType);
    }

    public String getType() {
        return this.type;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public boolean isEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(boolean entryPoint) {
        this.entryPoint = entryPoint;
        this.traverseBack = !entryPoint;
    }

    public boolean isProjection() {
        return this.projection;
    }

    public void setProjection(boolean projection) {
        if (!projection) {
            throw new InternalServerErrorException("Projection can only be set to true from code. This is a server side bug. Please contact the administrator.");
        }
        this.projection = projection;
        if (!this.entryPoint) {
            ((JsonQueryERElement)this.breadcrumb.get(this.breadcrumb.size() - 2)).setProjection(projection);
        }
    }

    public List<JsonQueryERElement> getBreadcrumb() {
        return this.breadcrumb;
    }

    public void setBreadcrumb(List<JsonQueryERElement> breadcrumb) {
        this.breadcrumb = breadcrumb;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAlias(boolean generateifNull) {
        if (this.alias == null && generateifNull) {
            this.alias = this.generateAlias().toString();
        }
        return this.alias;
    }

    protected StringBuffer generateAlias() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type.toLowerCase());
        for (JsonQueryERElement elem : this.breadcrumb) {
            sb.append(elem.getPosition());
        }
        sb.append(this.position);
        return sb;
    }

    protected void addFieldToEmit(String fieldToEmit) {
        this.fieldsToEmit.add(fieldToEmit);
        this.logger.trace("The field to emit ({}) has been added to {} with alias {}", new Object[]{fieldToEmit, this.type, this.alias});
        if (!this.entryPoint) {
            this.logger.trace("The field to emit ({}) will be added to the parent too", (Object)fieldToEmit);
            ((JsonQueryERElement)this.breadcrumb.get(this.breadcrumb.size() - 2)).addFieldToEmit(fieldToEmit);
        }
    }

    public boolean isTraverseBack() {
        return this.traverseBack;
    }

    public void setTraverseBack(boolean traverseBack) {
        this.traverseBack = traverseBack;
    }

    public StringBuffer createQuery(StringBuffer stringBuffer) throws SchemaNotFoundException, InvalidQueryException, SchemaException, ResourceRegistryException {
        return this.createMatchQuery(stringBuffer);
    }

    public abstract StringBuffer createTraversalQuery(StringBuffer var1) throws SchemaNotFoundException, InvalidQueryException, SchemaException, ResourceRegistryException;

    protected StringBuffer addConstraints(JsonNode jsonNode, LogicalOperator queryLogicalOperator, String fieldNamePrefix) throws InvalidQueryException {
        boolean first;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        if (queryLogicalOperator == null) {
            queryLogicalOperator = LogicalOperator.AND;
        }
        JsonNode copiedJsonNode = jsonNode.deepCopy();
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)copiedJsonNode;
            objectNode.remove((Collection)this.fieldNamesToRemove);
            iterator = objectNode.fieldNames();
            first = true;
            while (iterator.hasNext()) {
                String fieldName = (String)iterator.next();
                JsonNode node = objectNode.get(fieldName);
                StringBuffer evBuffer = this.evaluateNode(node, fieldName, fieldNamePrefix);
                if (evBuffer == null || evBuffer.length() <= 0) continue;
                if (first) {
                    first = false;
                } else {
                    stringBuffer.append(queryLogicalOperator.getDbOperator());
                }
                stringBuffer.append(evBuffer);
            }
        }
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)copiedJsonNode;
            iterator = arrayNode.iterator();
            first = true;
            while (iterator.hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                StringBuffer evBuffer = this.evaluateNode(node, null, fieldNamePrefix);
                if (!first) {
                    stringBuffer.append(queryLogicalOperator.getDbOperator());
                }
                if (evBuffer == null || evBuffer.length() <= 0) continue;
                if (first) {
                    first = false;
                }
                stringBuffer.append(evBuffer);
            }
        }
        return stringBuffer;
    }

    protected StringBuffer evaluateNode(JsonNode jsonNode, String fieldName, String fieldNamePrefix) throws InvalidQueryException {
        String key;
        if (ProjectionOperator.getOperators().contains(fieldName)) {
            --this.size;
            this.setProjection(true);
            Iterator iterator = jsonNode.fieldNames();
            while (iterator.hasNext()) {
                String fieldNameToEmit = (String)iterator.next();
                String nameOfFieldToEmit = jsonNode.get(fieldNameToEmit).asText();
                StringBuffer b = new StringBuffer();
                b.append(this.getAlias(true));
                b.append(".");
                if (fieldNamePrefix != null) {
                    b.append(fieldNamePrefix);
                    b.append(".");
                }
                b.append(fieldNameToEmit);
                b.append(" AS `");
                b.append(nameOfFieldToEmit);
                b.append("`");
                this.addFieldToEmit(b.toString());
            }
            return null;
        }
        if (MatemathicsOperator.getOperators().contains(fieldName)) {
            --this.size;
            this.setProjection(true);
            MatemathicsOperator mo = MatemathicsOperator.getOperator((String)fieldName);
            String fieldToEmit = mo.generateFieldToEmit(jsonNode, this.getAlias(true));
            this.addFieldToEmit(fieldToEmit);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (LogicalOperator.getOperators().contains(fieldName)) {
            LogicalOperator queryLogicalOperator = LogicalOperator.getOperator((String)fieldName);
            stringBuffer.append("(");
            stringBuffer.append(this.addConstraints(jsonNode, queryLogicalOperator, fieldNamePrefix));
            stringBuffer.append(")");
            return stringBuffer;
        }
        if (ComparisonOperator.getOperators().contains(fieldName)) {
            ComparisonOperator comparisonOperator = ComparisonOperator.getOperator((String)fieldName);
            String key2 = this.getKey(null, fieldNamePrefix);
            String value = this.getValue(jsonNode);
            stringBuffer.append(comparisonOperator.addCondition(new String[]{key2, value}));
            return stringBuffer;
        }
        if (jsonNode.isObject()) {
            StringBuffer newPrefix = new StringBuffer();
            if (fieldNamePrefix != null && fieldNamePrefix.compareTo("") != 0) {
                newPrefix.append(fieldNamePrefix);
                if (fieldName != null && fieldName.compareTo("") != 0) {
                    newPrefix.append(".");
                }
            }
            if (fieldName != null && fieldName.compareTo("") != 0) {
                newPrefix.append(fieldName);
            }
            stringBuffer.append(this.addConstraints(jsonNode, null, newPrefix.length() > 0 ? newPrefix.toString() : null));
            return stringBuffer;
        }
        if (jsonNode.isTextual() || jsonNode.isNumber()) {
            key = this.getKey(fieldName, fieldNamePrefix);
            String value = this.getValue(jsonNode);
            stringBuffer.append(ComparisonOperator.EQ.addCondition(new String[]{key, value}));
        }
        if (jsonNode.isNull()) {
            key = this.getKey(fieldName, null);
            stringBuffer.append(ComparisonOperator.IS.addCondition(new String[]{key, null}));
        }
        return stringBuffer;
    }

    protected String getKey(String fieldName, String fieldNamePrefix) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fieldNamePrefix != null) {
            stringBuffer.append(fieldNamePrefix.trim());
            if (fieldName != null && fieldName.trim().length() != 0) {
                stringBuffer.append(".");
            }
        }
        if (fieldName != null) {
            stringBuffer.append(fieldName.trim());
        }
        return stringBuffer.toString();
    }

    protected String getValue(JsonNode jsonNode) {
        StringBuffer stringBuffer = new StringBuffer();
        String value = jsonNode.asText();
        if (jsonNode.isNumber()) {
            stringBuffer.append(value);
        } else {
            stringBuffer.append("\"");
            stringBuffer.append(value);
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    protected List<JsonQueryERElement> getChildrenBreadcrumb() {
        ArrayList<JsonQueryERElement> childrenBreadcrumb = new ArrayList<JsonQueryERElement>(this.breadcrumb);
        childrenBreadcrumb.add(this);
        return childrenBreadcrumb;
    }

    protected StringBuffer wrapMatchQuery(StringBuffer buffer) throws InvalidQueryException {
        if (this.entryPoint) {
            this.alias = this.getAlias(true);
            StringBuffer sb = null;
            if (this.size > 1) {
                sb = this.addConstraints(this.jsonNode, null, null);
            }
            StringBuffer entryBuffer = new StringBuffer();
            entryBuffer.append("MATCH\n");
            entryBuffer.append("\t{class: ");
            entryBuffer.append(this.type);
            entryBuffer.append(", as: ");
            entryBuffer.append(this.alias);
            entryBuffer.append(", where: ");
            if (sb != null && sb.length() > 0) {
                entryBuffer.append("(");
            }
            entryBuffer.append("($currentMatch['@class'] INSTANCEOF '");
            entryBuffer.append(this.type);
            entryBuffer.append("')");
            if (sb != null && sb.length() > 0) {
                entryBuffer.append(" AND (");
                entryBuffer.append(sb);
                entryBuffer.append(")");
                entryBuffer.append(")");
            }
            entryBuffer.append("}\n");
            entryBuffer.append(buffer);
            entryBuffer.append("\nRETURN\n");
            if (!this.projection) {
                entryBuffer.append("\tDISTINCT(");
                entryBuffer.append(this.alias);
                entryBuffer.append(") as ret");
                StringBuffer wrap = new StringBuffer();
                wrap.append("SELECT EXPAND(ret) FROM (\n");
                wrap.append(entryBuffer);
                wrap.append("\n)");
                entryBuffer = wrap;
            } else {
                int size = this.fieldsToEmit.size();
                for (int i = 0; i < size; ++i) {
                    entryBuffer.append("\t");
                    entryBuffer.append((String)this.fieldsToEmit.get(i));
                    if (i >= size - 1) continue;
                    entryBuffer.append(",\n");
                }
            }
            return entryBuffer;
        }
        return buffer;
    }

    protected abstract StringBuffer getSpecificMatchQuery(List<JsonQueryERElement> var1) throws SchemaException, ResourceRegistryException;

    public StringBuffer createMatchQuery(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
        List childrenBreadcrumb = this.getChildrenBreadcrumb();
        if (this.entryPoint) {
            this.getAlias(true);
        }
        StringBuffer buffer = this.getSpecificMatchQuery(childrenBreadcrumb);
        buffer = this.wrapMatchQuery(buffer);
        stringBuffer.append(buffer);
        return stringBuffer;
    }
}

