/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import com.orientechnologies.orient.core.record.ODirection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.request.BaseRequestInfo;
import org.gcube.informationsystem.resourceregistry.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.queries.QueryImpl;
import org.gcube.informationsystem.resourceregistry.queries.json.JsonQuery;
import org.gcube.informationsystem.resourceregistry.queries.templates.QueryTemplateManagement;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.Method;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.types.TypeManagement;
import org.gcube.informationsystem.types.TypeMapper;

@Path(value="access")
public class Access
extends BaseRest {
    public static final String RESOURCE_TYPE_PATH_PARAMETER = "RESOURCE_TYPE_NAME";
    public static final String RELATION_TYPE_PATH_PARAMETER = "RELATION_TYPE_NAME";
    public static final String REFERENCE_TYPE_PATH_PARAMETER = "REFERENCE_TYPE_NAME";
    public static final String RAW_QUERY_METHOD = "raw";
    public static final String GRAPH_QUERY_METHOD = "graph";
    public static final String JSON_QUERY_METHOD = "json";
    public static final String PREPARED_QUERY_METHOD = "prepared";

    @GET
    @Path(value="contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAllContexts() throws ResourceRegistryException {
        this.logger.info("Requested to read all {}s", (Object)"Context");
        this.setAccountingMethod(Method.LIST, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo(BaseRequestInfo.DEFAULT_OFFSET.intValue(), BaseRequestInfo.UNBOUNDED_LIMIT.intValue());
        serverRequestInfo.setIncludeMeta(false);
        serverRequestInfo.setAllMeta(false);
        serverRequestInfo.checkLimitOffset();
        ContextManagement contextManagement = new ContextManagement();
        return contextManagement.all(false);
    }

    @GET
    @Path(value="contexts/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getContext(@PathParam(value="UUID") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        if (uuid.compareTo("CURRENT_CONTEXT") == 0) {
            uuid = ContextUtility.getCurrentRequestEnvironment().getUUID().toString();
        }
        this.logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        this.setAccountingMethod(Method.READ, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.readAsString();
    }

    @GET
    @Path(value="types/{TYPE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getType(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        this.logger.info("Requested Schema for type {}", (Object)type);
        this.setAccountingMethod(Method.READ, "Type");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        TypeManagement typeManagement = new TypeManagement();
        typeManagement.setTypeName(type);
        List types = typeManagement.read(polymorphic.booleanValue());
        try {
            return TypeMapper.serializeTypeDefinitions((List)types);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @GET
    @Path(value="query-templates")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String allQueryTemplates() throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read all {}s", (Object)"QueryTemplate");
        this.setAccountingMethod(Method.LIST, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        serverRequestInfo.checkLimitOffset();
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        return queryTemplateManagement.all(false);
    }

    @GET
    @Path(value="query-templates/{QUERY_TEMPLATE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String readQueryTemplate(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.READ, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        return queryTemplateManagement.read();
    }

    @POST
    @Path(value="query-templates/{QUERY_TEMPLATE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String runQueryTemplate(@PathParam(value="QUERY_TEMPLATE_NAME") String queryTemplateName, String params) throws NotFoundException, InvalidQueryException, ResourceRegistryException {
        this.logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.RUN, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.setParams(params);
        return queryTemplateManagement.run();
    }

    @GET
    @Path(value="instances/{TYPE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAllInstances(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="true") Boolean polymorphic) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested all {}instances of {}", (Object)(polymorphic != false ? "polymorphic " : ""), (Object)type);
        this.setAccountingMethod(Method.LIST, "Instance");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        serverRequestInfo.checkLimitOffset();
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        return erManagement.all(polymorphic.booleanValue());
    }

    @HEAD
    @Path(value="instances/{TYPE_NAME}/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response instanceExists(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to check if {} with id {} exists", (Object)type, (Object)uuid);
        this.setAccountingMethod(Method.EXIST, "Instance");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkBooleanQueryParameter("hierarchical");
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        try {
            erManagement.setUUID(UUID.fromString(uuid));
            boolean found = erManagement.exists();
            if (found) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AvailableInAnotherContextException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    @GET
    @Path(value="instances/{TYPE_NAME}/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getInstance(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read {} with id {}", (Object)type, (Object)uuid);
        this.setAccountingMethod(Method.READ, "Instance");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setElementType(type);
        erManagement.setUUID(UUID.fromString(uuid));
        return erManagement.read().toString();
    }

    @GET
    @Path(value="instances/{TYPE_NAME}/{UUID}/contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getInstanceContexts(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String instanceId) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to get contexts of {} with UUID {}", (Object)type, (Object)instanceId);
        this.setAccountingMethod("getInstanceContexts");
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(instanceId));
        return erManagement.getContexts();
    }

    @GET
    @Path(value="query")
    @Produces(value={"application/json;charset=UTF-8"})
    public String graphQuery(@QueryParam(value="q") String query, @QueryParam(value="raw") @DefaultValue(value="false") Boolean raw) throws InvalidQueryException {
        this.logger.info("Requested query (Raw {}):\n{}", (Object)raw, (Object)query);
        if (raw.booleanValue()) {
            this.setAccountingMethod(Method.QUERY, RAW_QUERY_METHOD);
        } else {
            this.setAccountingMethod(Method.QUERY, GRAPH_QUERY_METHOD);
        }
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        if (raw.booleanValue()) {
            serverRequestInfo.checkBooleanQueryParameter("hierarchical");
        } else {
            serverRequestInfo.checkAllBooleanQueryParameters();
        }
        QueryImpl queryManager = new QueryImpl();
        return queryManager.query(query, raw.booleanValue());
    }

    @POST
    @Path(value="query")
    public String jsonQuery(String jsonQuery) throws InvalidQueryException, ResourceRegistryException {
        this.logger.info("Requested json query \n{}", (Object)jsonQuery);
        this.setAccountingMethod(Method.QUERY, JSON_QUERY_METHOD);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        serverRequestInfo.checkLimitOffset();
        JsonQuery jsonQueryManager = new JsonQuery();
        jsonQueryManager.setJsonQuery(jsonQuery);
        return jsonQueryManager.query();
    }

    @GET
    @Path(value="query/{RESOURCE_TYPE_NAME}/{RELATION_TYPE_NAME}/{REFERENCE_TYPE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAllResourcesHavingFacet(@PathParam(value="RESOURCE_TYPE_NAME") String resourcetype, @PathParam(value="RELATION_TYPE_NAME") String relationType, @PathParam(value="REFERENCE_TYPE_NAME") String referenceType, @QueryParam(value="_reference") String reference, @QueryParam(value="_polymorphic") @DefaultValue(value="false") Boolean polymorphic, @QueryParam(value="_direction") @DefaultValue(value="out") String direction, @Context UriInfo uriInfo) throws ResourceRegistryException {
        this.logger.info("Requested {} instances having a(n) {} ({}={}} with {} ({}={}). Request URI is {})", new Object[]{resourcetype, relationType, "_direction", direction, referenceType, "_polymorphic", polymorphic, uriInfo.getRequestUri()});
        this.setAccountingMethod(Method.QUERY, PREPARED_QUERY_METHOD);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        serverRequestInfo.checkLimitOffset();
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)resourcetype);
        if (erManagement instanceof ResourceManagement) {
            String error;
            UUID refereceUUID = null;
            ODirection directionEnum = ODirection.OUT;
            HashMap<String, String> constraint = new HashMap<String, String>();
            MultivaluedMap multivaluedMap = uriInfo.getQueryParameters();
            Iterator iterator = multivaluedMap.keySet().iterator();
            block18: while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "_polymorphic": {
                        continue block18;
                    }
                    case "_direction": {
                        continue block18;
                    }
                    case "_reference": {
                        continue block18;
                    }
                    case "gcube-token": {
                        continue block18;
                    }
                    case "gcube-scope": {
                        continue block18;
                    }
                }
                constraint.put(key, (String)multivaluedMap.getFirst((Object)key));
            }
            if (reference != null) {
                try {
                    refereceUUID = UUID.fromString(reference);
                }
                catch (Exception e) {
                    error = String.format("%s is not a valid %s", reference, UUID.class.getSimpleName());
                    throw new InvalidQueryException(error);
                }
            }
            try {
                directionEnum = ODirection.valueOf((String)direction.toUpperCase());
            }
            catch (Exception e) {
                error = String.format("%s is not a valid. Allowed values are %s", direction, ODirection.values());
                throw new InvalidQueryException(error);
            }
            return ((ResourceManagement)erManagement).query(relationType, referenceType, refereceUUID, directionEnum, polymorphic.booleanValue(), constraint);
        }
        String error = String.format("%s is not a %s type", resourcetype, "Resource");
        throw new InvalidQueryException(error);
    }
}

