/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.UUID;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.Method;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;

@Path(value="instances")
@Tag(name="Instances", description="Operations for managing entities and relation instances in the Resource Registry.")
public class InstancesManager
extends BaseRest {
    public static final String INSTANCE_UUID_PATH_PARAMETER = "instance-uuid";
    public static final String INSTANCE = "Instance";
    public static final String GET_INSTANCE_CONTEXTS_METHOD = "getInstanceContexts";

    @GET
    @Path(value="/{type-name}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="List Instances by specified Type ", description="Retrieves all instances of a specified type from the Resource Registry.\n\n\n**Request Examples:**\n- Basic query: GET /instances/EService;\n- With pagination: GET /instances/EService?limit=20&offset=40;\n- With subtypes and metadata: GET /instances/EService?polymorphic=true&includeMeta=true;\n- Full metadata context: GET /instances/EService?includeMeta=true&allMeta=true;\n- With context information: GET /instances/EService?includeContexts=true;\n- Hierarchical (admin only): GET /instances/EService?hierarchical=true;\n- Hierarchical with contexts (admin only): GET /instances/EService?hierarchical=true&includeContexts=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to all metadata and hierarchical querying capabilities;\n\t- Can access instances across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to all metadata and hierarchical querying capabilities;\n\t- Can access instances across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Context-Manager:**\n\t- Full access to all metadata and hierarchical querying capabilities;\n\t- Must be Context-Manager of the current context derived from the authorization token;\n\t- Can access hierarchical querying capabilities;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Basic access with metadata filtering and no hierarchical querying;\n\t- Cannot use hierarchical querying (hierarchical parameter ignored);\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n\n\n**Response Format:**\n- Returns a JSON array containing the requested instances;\n- Each instance includes its properties, relations, and metadata (if requested);\n- Empty array is returned if no instances of the specified type exist in the accessible contexts.\n\n**Example Metadata (filtered for non-admin users):**\n```json\n\"metadata\": {\n    \"type\": \"Metadata\",\n    \"creationTime\": \"2025-03-18 17:13:40.952 +0100\",\n    \"createdBy\": \"HIDDEN_FOR_PRIVACY\",\n    \"lastUpdateBy\": \"HIDDEN_FOR_PRIVACY\",\n    \"lastUpdateTime\": \"2025-03-19 16:21:16.805 +0100\"\n}\n```\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Instances successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid query parameters (e.g., invalid limit/offset values)"), @APIResponse(responseCode="404", description="The specified type does not exist"), @APIResponse(responseCode="403", description="Insufficient permissions to access instances in the current context")})
    public String readAll(@PathParam(value="type-name") @Schema(description="The name of the Information System type whose instances should be retrieved (e.g., \"EService\", \"ContactFacet\")", example="EService") String type, @QueryParam(value="polymorphic") @DefaultValue(value="true") Boolean polymorphic) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested all {}instances of {}", (Object)(polymorphic != false ? "polymorphic " : ""), (Object)type);
        this.setAccountingMethod(Method.LIST, INSTANCE);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        serverRequestInfo.checkLimitOffset();
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        return erManagement.all(polymorphic.booleanValue());
    }

    @HEAD
    @Path(value="/{type-name}/{instance-uuid}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Check Instance existence by Type and UUID ", description="Checks if an instance with the specified type and UUID exists in the Resource Registry.\n\n\n**Request Examples:**\n- Basic check: HEAD /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f;\n- Hierarchical check (admin only): HEAD /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?hierarchical=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can check existence of any instance type in any context;\n\t- Can use hierarchical querying to check across context hierarchies;\n\t- Has full administrative access to existence checking.\n\n- **Infrastructure-Manager:**\n\t- Can check existence of any instance type in any context;\n\t- Can use hierarchical querying to check across context hierarchies;\n\t- Has full administrative access to existence checking.\n\n- **Context-Manager:**\n\t- Can check existence of instances in the current context;\n\t- Can use hierarchical querying within their managed context hierarchy;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- Cannot check instances in contexts where they don't have Context-Manager role.\n\n- **Other Users:**\n\t- Can check existence of instances in the current context only;\n\t- Cannot use hierarchical querying (parameter is ignored);\n\t- Only within contexts where they have authorized access through their token.\n")
    @APIResponses(value={@APIResponse(responseCode="204", description="Instance exists and is accessible in the current context"), @APIResponse(responseCode="404", description="Instance does not exist"), @APIResponse(responseCode="403", description="Instance exists but is available in another context (not accessible in current context)")})
    public Response exists(@PathParam(value="type-name") @Schema(description="The name of the Information System type (e.g., \"EService\", \"ContactFacet\")", example="EService") String type, @PathParam(value="instance-uuid") String instanceId) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to check if {} with id {} exists", (Object)type, (Object)instanceId);
        this.setAccountingMethod(Method.EXIST, INSTANCE);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkBooleanQueryParameter("hierarchical");
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        try {
            erManagement.setUUID(UUID.fromString(instanceId));
            boolean found = erManagement.exists();
            if (found) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AvailableInAnotherContextException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    @GET
    @Path(value="/{type-name}/{instance-uuid}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Read Instance by Type and UUID ", description="Retrieves a single instance with the specified type and UUID.\n\n\n**Request Examples:**\n- Basic query: GET /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f;\n- With metadata: GET /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?includeMeta=true;\n- Full metadata context: GET /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?includeMeta=true&allMeta=true;\n- With context information: GET /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?includeContexts=true;\n- Hierarchical (admin only): GET /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?hierarchical=true;\n- Hierarchical with contexts (admin only): GET /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?hierarchical=true&includeContexts=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to retrieve any instance in any context;\n\t- Can use hierarchical querying to search across context hierarchies;\n\t- Receive complete, unfiltered metadata for the instance and all nested elements;\n\t- Metadata includes all administrative fields without obfuscation.\n\n- **Infrastructure-Manager:**\n\t- Full access to retrieve any instance in any context;\n\t- Can use hierarchical querying to search across context hierarchies;\n\t- Receive complete, unfiltered metadata for the instance and all nested elements;\n\t- Metadata includes all administrative fields without obfuscation.\n\n- **Context-Manager:**\n\t- Can retrieve instances in the current context and child contexts;\n\t- Can use hierarchical querying within their managed context hierarchy;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- Receive complete, unfiltered metadata for the instance and all nested elements;\n\t- Metadata includes all administrative fields without obfuscation.\n\n- **Other Users:**\n\t- Can retrieve instances in the current context only;\n\t- Cannot use hierarchical querying (hierarchical parameter ignored);\n\t- Receive metadata with sensitive information filtered when includeMeta=true:\n\t\t- Date fields (creation, modification) are visible;\n\t\t- User identifiers (createdBy, lastUpdateBy) are obfuscated or hidden;\n\t\t- Other administrative details may be filtered.\n\n\n**Response Format:**\n- Returns a JSON object containing the requested instance;\n- Includes its properties, relations, and metadata (if requested);\n- Nested elements are included based on polymorphic and metadata settings.\n\n**Example Metadata (filtered for non-admin users):**\n```json\n\"metadata\": {\n    \"type\": \"Metadata\",\n    \"creationTime\": \"2025-03-18 17:13:40.952 +0100\",\n    \"createdBy\": \"HIDDEN_FOR_PRIVACY\",\n    \"lastUpdateBy\": \"HIDDEN_FOR_PRIVACY\",\n    \"lastUpdateTime\": \"2025-03-19 16:21:16.805 +0100\"\n}\n```\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Instance successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Instance does not exist"), @APIResponse(responseCode="403", description="Instance exists but is available in another context (not accessible in current context)")})
    public String read(@PathParam(value="type-name") @Schema(description="The name of the Information System type (e.g., \"EService\", \"ContactFacet\")", example="EService") String type, @PathParam(value="instance-uuid") String instanceId) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read {} with id {}", (Object)type, (Object)instanceId);
        this.setAccountingMethod(Method.READ, INSTANCE);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setElementType(type);
        erManagement.setUUID(UUID.fromString(instanceId));
        return erManagement.read().toString();
    }

    @PUT
    @Path(value="/{type-name}/{instance-uuid}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Create or Update Instance", description="Creates a new instance or updates an existing instance with the specified type and UUID in the Resource Registry.\n\n\n**Request Examples:**\n- Basic create/update: PUT /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f;\n- With metadata in response: PUT /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?includeMeta=true;\n- Full metadata context: PUT /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?includeMeta=true&allMeta=true;\n- With context information: PUT /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?includeContexts=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to create/update instances in any context;\n\t- Can create/update instances across all contexts within the infrastructure;\n\t- Receive complete, unfiltered metadata for the instance and all nested elements in the response;\n\t- Metadata includes all administrative fields without obfuscation.\n\n- **Infrastructure-Manager:**\n\t- Full access to create/update instances in any context;\n\t- Can create/update instances across all contexts within the infrastructure;\n\t- Receive complete, unfiltered metadata for the instance and all nested elements in the response;\n\t- Metadata includes all administrative fields without obfuscation.\n\n- **Context-Manager:**\n\t- Can create/update instances in the current context;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- Cannot create/update instances in contexts where they don't have Context-Manager role;\n\t- Receive complete, unfiltered metadata for the instance and all nested elements in the response;\n\t- Metadata includes all administrative fields without obfuscation.\n\n- **Other Users:**\n\t- Limited create/update permissions based on instance ownership and context access;\n\t- Only within contexts where they have authorized access through their token;\n\t- Receive metadata with sensitive information filtered when includeMeta=true:\n\t\t- Date fields (creation, modification) are visible;\n\t\t- User identifiers (createdBy, lastUpdateBy) are obfuscated or hidden;\n\t\t- Other administrative details may be filtered.\n\n\n**Operation Behavior:**\n- **Create**: If the instance with the specified UUID does not exist, creates a new instance;\n- **Update**: If the instance with the specified UUID exists, updates the existing instance;\n- The operation is idempotent and atomic.\n\n\n**Response Format:**\n- Returns a JSON object containing the created or updated instance;\n- Includes its properties, relations, and metadata (if requested);\n- Response structure depends on includeMeta, allMeta, and includeContexts parameters.\n\n**Example Metadata (filtered for non-admin users):**\n```json\n\"metadata\": {\n    \"type\": \"Metadata\",\n    \"creationTime\": \"2025-03-18 17:13:40.952 +0100\",\n    \"createdBy\": \"HIDDEN_FOR_PRIVACY\",\n    \"lastUpdateBy\": \"HIDDEN_FOR_PRIVACY\",\n    \"lastUpdateTime\": \"2025-03-19 16:21:16.805 +0100\"\n}\n```\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Instance successfully updated (existing instance modified)", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="201", description="Instance successfully created (new instance)", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid request body, malformed JSON, or schema validation failed"), @APIResponse(responseCode="403", description="Insufficient permissions to create/update the instance"), @APIResponse(responseCode="404", description="The specified type does not exist")})
    public String updateOrCreate(@PathParam(value="type-name") @Schema(description="The name of the Information System type (e.g., \"EService\", \"ContactFacet\")", example="EService") String type, @PathParam(value="instance-uuid") String instanceId, String json) throws ResourceRegistryException {
        this.logger.info("Requested to update/create {} with id {}", (Object)type, (Object)instanceId);
        this.logger.trace("Requested to update/create {} with id {} with json {}", new Object[]{type, instanceId, json});
        this.setAccountingMethod(Method.UPDATE, INSTANCE);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllIncludeQueryParameters();
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(instanceId));
        erManagement.setElementType(type);
        erManagement.setJson(json);
        return erManagement.createOrUpdate();
    }

    @DELETE
    @Path(value="/{type-name}/{instance-uuid}")
    @Operation(summary="Delete Instance", description="Deletes an instance with the specified type and UUID from the Resource Registry.\n\n\n**Request Examples:**\n- Delete resource (e.g., EService): DELETE /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f;\n- Delete facet (e.g., ContactFacet): DELETE /instances/ContactFacet/4023d5b2-8601-47a5-83ef-49ffcbfc7d86.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can delete any instance from any context;\n\t- Full administrative access to deletion operations across all contexts.\n\n- **Infrastructure-Manager:**\n\t- Can delete any instance from any context;\n\t- Full administrative access to deletion operations across all contexts.\n\n- **Context-Manager:**\n\t- Can delete instances if the request is made from a context where they have Context-Manager role;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- The current context must be one of the contexts where the instance exists.\n\n- **Other Users:**\n\t- Can delete instances if the request is made from a context where the instance is present;\n\t- The current context (derived from the authorization token) must be one of the contexts where the instance exists;\n\t- Only within contexts where they have authorized access through their token.\n\n\n**Operation Behavior:**\n- **Global Deletion**: The instance is deleted from all contexts where it exists, not just the current context;\n- **IsRelatedTo Relations Cleanup**: All IsRelatedTo relations involving the deleted instance (both as source and target) are deleted from all contexts to prevent broken relations and maintain referential integrity;\n- **Cascading Effects for IsRelatedTo**: Connected Resources are deleted only if propagation constraints require it and only for relations where the deleted instance is the source (relations are followed in their direction) and only within the current context;\n- **Complete ConsistsOf Deletion**: All ConsistsOf relations and their target Facets are deleted regardless of context;\n- **Facet/ConsistsOf Deletion Behavior**: When deleting a Facet or ConsistsOf relation, both the ConsistsOf relation and the Facet must be present in the current context. The source Resource is revalidated against its type schema after deletion - if the Resource becomes invalid, the deletion operation fails with a 400 Bad Request error (SchemaViolationException);\n- **Schema Validation**: When deleting Facets or ConsistsOf relations, the source Resource is validated against its type schema after deletion to ensure consistency - validation failures result in a 400 Bad Request error (SchemaViolationException);\n- **Permission Validation**: User permissions are validated against the current context;\n- **Atomicity**: The operation is atomic - either the instance and all cascaded deletions succeed, or the entire operation fails.\n")
    @APIResponses(value={@APIResponse(responseCode="204", description="Instance successfully deleted"), @APIResponse(responseCode="400", description="Schema validation failed after deletion (SchemaViolationException) - occurs when deleting a Facet or ConsistsOf relation would leave the source Resource in an invalid state according to its type schema"), @APIResponse(responseCode="404", description="Instance does not exist"), @APIResponse(responseCode="403", description="Instance exists but is available in another context (not accessible in current context)")})
    public Response delete(@PathParam(value="type-name") @Schema(description="The name of the Information System type (e.g., \"EService\", \"ContactFacet\")", example="EService") String type, @PathParam(value="instance-uuid") String instanceId) throws ResourceRegistryException {
        this.logger.info("Requested to delete {} with id {}", (Object)type, (Object)instanceId);
        this.setAccountingMethod(Method.DELETE, INSTANCE);
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(instanceId));
        erManagement.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="{type-name}/{instance-uuid}/contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Get Instance Contexts", description="Retrieves the list of contexts where a specific instance is present in the Resource Registry.\n\n\n**Request Examples:**\n- Get contexts for a resource: GET /instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f/contexts;\n- Get contexts for a facet: GET /instances/ContactFacet/4023d5b2-8601-47a5-83ef-49ffcbfc7d86/contexts.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can retrieve context information for any instance;\n\t- Full access to view contexts across the entire infrastructure.\n\n- **Infrastructure-Manager:**\n\t- Can retrieve context information for any instance;\n\t- Full access to view contexts across the entire infrastructure.\n\n- **Context-Manager:**\n\t- Can retrieve context information for any accessible instance;\n\t- Access depends on their Context-Manager role in relevant contexts.\n\n- **Other Users:**\n\t- Can retrieve context information for any accessible instance;\n\t- Access depends on their permissions and context availability through their token.\n\n\n**Response Format:**\n- Returns a JSON object containing the contexts where the instance is present;\n- Each key is a context UUID and each value is the current full context path;\n- Empty object is returned if the instance exists but is not present in any contexts.\n\n**Example Response:**\n```json\n{\n  \"3d846e2f-3582-4344-b03a-629d4cd34d53\": \"/gcube/devsec/devVRE\",\n  \"4eb849d5-efbb-4430-9eb6-1968123921b4\": \"/gcube\",\n  \"a7bc333f-84df-498d-ae9d-748b358267b5\": \"/gcube/devsec\"\n}\n```\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Context list successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Instance does not exist"), @APIResponse(responseCode="403", description="Instance exists but is available in another context (not accessible for context listing)")})
    public String getInstanceContexts(@PathParam(value="type-name") @Schema(description="The name of the Information System type (e.g., \"EService\", \"ContactFacet\")", example="EService") String type, @PathParam(value="instance-uuid") String instanceId) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        this.logger.info("Requested to get contexts of {} with UUID {}", (Object)type, (Object)instanceId);
        this.setAccountingMethod(GET_INSTANCE_CONTEXTS_METHOD);
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(instanceId));
        return erManagement.getContexts();
    }
}

