/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry;

import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.Mode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryManager
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(ResourceRegistryManager.class);

    public void onInit() {
        logger.info("The server is going to use OrientDB at {}", (Object)DatabaseEnvironment.DB_URI);
        if (ContextProvider.get().container().configuration().mode() == Mode.offline) {
            logger.debug("Resource Registry init called in offline mode");
        } else {
            Secret secret = SecretManagerProvider.get();
            if (secret != null) {
                logger.debug("Resource Registry init called in context {}", (Object)secret.getContext());
            } else {
                logger.debug("Resource Registry init called in null context");
            }
        }
    }

    public void onShutdown() {
        if (ContextProvider.get().container().configuration().mode() == Mode.offline) {
            logger.debug("Resource Registry shutDown called in offline mode");
        } else {
            Secret secret = SecretManagerProvider.get();
            if (secret != null) {
                logger.debug("Resource Registry shutDown called in context {}", (Object)secret.getContext());
            } else {
                logger.debug("Resource Registry shutDown called in null context");
            }
        }
    }
}

