/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import jakarta.ws.rs.ForbiddenException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.contexts.reference.ContextState;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.EntityAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.ServerContextCache;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.administration.AdminEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.instances.InstanceEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.Operation;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.rest.requests.RequestUtility;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.resourceregistry.utils.MetadataUtility;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.types.reference.entities.EntityType;

public abstract class EntityManagement<E extends Entity, ET extends EntityType>
extends EntityElementManagement<E, ET>
implements ERManagement {
    protected InstanceEnvironment sourceInstanceEnvironment;
    protected InstanceEnvironment targetInstanceEnvironment;
    protected boolean honourPropagationConstraintsInContextSharing;
    protected Map<String, RelationManagement<?, ?>> relationManagements;
    protected boolean forceAddToContext;
    protected boolean skipped;

    public void setSourceInstanceEnvironment(InstanceEnvironment source) {
        this.sourceInstanceEnvironment = source;
    }

    public InstanceEnvironment getSourceInstanceEnvironment() {
        return this.sourceInstanceEnvironment;
    }

    public void setTargetInstanceEnvironment(InstanceEnvironment target) {
        this.targetInstanceEnvironment = target;
    }

    public InstanceEnvironment getTargetInstanceEnvironment() {
        return this.sourceInstanceEnvironment;
    }

    public boolean isHonourPropagationConstraintsInContextSharing() {
        return this.honourPropagationConstraintsInContextSharing;
    }

    public void setHonourPropagationConstraintsInContextSharing(boolean honourPropagationConstraintsInContextSharing) {
        this.honourPropagationConstraintsInContextSharing = honourPropagationConstraintsInContextSharing;
    }

    protected EntityManagement(AccessType accessType) {
        super(accessType);
        this.ignoreStartWithKeys.add("in_".toLowerCase());
        this.ignoreStartWithKeys.add("out_".toLowerCase());
        this.ignoreStartWithKeys.add("in_".toUpperCase());
        this.ignoreStartWithKeys.add("out_".toUpperCase());
        this.relationManagements = new HashMap();
        this.honourPropagationConstraintsInContextSharing = true;
        this.skipped = false;
    }

    protected Environment getWorkingEnvironment() throws ResourceRegistryException {
        if (this.workingEnvironment == null) {
            Set allowedRoles;
            this.workingEnvironment = ContextUtility.getCurrentRequestEnvironment();
            Context context = ServerContextCache.getInstance().getFullInfoContextByUUID(this.workingEnvironment.getUUID());
            String state = context.getState();
            if (state.compareTo(ContextState.ACTIVE.getState()) != 0 && !this.workingEnvironment.isUserAllowed((Collection)(allowedRoles = this.workingEnvironment.getAllowedRoles()))) {
                throw new ForbiddenException("You are not allowed to operate in non " + ContextState.ACTIVE.getState() + " Contexts. Allowed roles are " + String.valueOf(allowedRoles));
            }
        }
        return this.workingEnvironment;
    }

    public OVertex getElement() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.element = super.getElement();
        }
        catch (NotFoundException e) {
            try {
                this.retrieveElementFromAnyContext();
                throw this.getSpecificAvailableInAnotherContextException((String)(this.typeName == null ? this.accessType.getName() : this.typeName + " with ID " + String.valueOf(this.uuid) + " is available in another " + Context.class.getSimpleName()));
            }
            catch (AvailableInAnotherContextException e1) {
                throw e1;
            }
            catch (Exception e1) {
                throw e;
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return (OVertex)this.element;
    }

    protected RelationManagement<?, ?> getRelationManagement(OEdge edge) throws ResourceRegistryException {
        String id = edge.getIdentity().toString();
        RelationManagement relationManagement = (RelationManagement)this.relationManagements.get(id);
        if (relationManagement == null) {
            relationManagement = ElementManagementUtility.getRelationManagement((Environment)this.getWorkingEnvironment(), (ODatabaseDocument)this.oDatabaseDocument, (OEdge)edge);
            this.relationManagements.put(id, relationManagement);
        }
        return relationManagement;
    }

    public void addToRelationManagements(RelationManagement<?, ?> relationManagement) throws ResourceRegistryException {
        OEdge elem = relationManagement.getElement();
        String id = elem.getIdentity().toString();
        if (this.relationManagements.get(id) != null && this.relationManagements.get(id) != relationManagement) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Two different instance of ");
            errorMessage.append(relationManagement.getClass().getSimpleName());
            errorMessage.append(" point to the same ");
            errorMessage.append(elem.getClass().getSimpleName());
            errorMessage.append(". ");
            errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(errorMessage.toString());
        }
        this.relationManagements.put(id, relationManagement);
    }

    protected static JsonNode addRelation(JsonNode sourceResource, JsonNode relation, String arrayKey) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode relationArray = objectMapper.createArrayNode();
        try {
            if (sourceResource.has(arrayKey)) {
                relationArray = (ArrayNode)sourceResource.get(arrayKey);
            }
            relationArray.add(relation);
            ((ObjectNode)sourceResource).replace(arrayKey, (JsonNode)relationArray);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return sourceResource;
    }

    protected OVertex createVertex() throws EntityAlreadyPresentException, ResourceRegistryException {
        this.logger.trace("Going to create {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.typeName, this.jsonNode});
        try {
            if (this.oClass.isAbstract()) {
                String error = "Trying to create an instance of %s of type %s which is abstract. The operation will be aborted.".formatted(this.accessType.getName(), this.typeName);
                throw new SchemaViolationException(error);
            }
            OVertex vertexEntity = this.oDatabaseDocument.newVertex(this.typeName);
            try {
                OVertex v;
                if (this.uuid != null && (v = this.getElement()) != null) {
                    String error = "A %s with UUID %s already exist".formatted(this.typeName, this.uuid.toString());
                    throw this.getSpecificAlreadyPresentException(error);
                }
            }
            catch (NotFoundException e) {
                try {
                    OElement el = ElementManagementUtility.getAnyElementByUUID((UUID)this.uuid);
                    String error = "UUID %s is already used by another %s. This is not allowed.".formatted(this.uuid.toString(), el instanceof OVertex ? "Entity" : "Relation");
                    throw this.getSpecificAvailableInAnotherContextException(error);
                }
                catch (NotFoundException notFoundException) {
                }
            }
            catch (AvailableInAnotherContextException e) {
                throw e;
            }
            this.element = vertexEntity;
            if (this.accessType != AccessType.RESOURCE) {
                this.updateProperties(this.oClass, this.element, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
            }
            this.logger.debug("Created {} is {}", (Object)OVertex.class.getSimpleName(), (Object)OrientDBUtility.getAsStringForLogging((ORecord)((OVertex)this.element)));
            return (OVertex)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.typeName, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.typeName + " with " + String.valueOf(this.jsonNode), e.getCause());
        }
    }

    protected void reallyAddToContext() throws ContextException, ResourceRegistryException {
        if (!this.forceAddToContext && !this.sourceInstanceEnvironment.isElementInContext((OElement)this.getElement())) {
            this.skipped = true;
            return;
        }
        this.targetInstanceEnvironment.addElement((OElement)this.getElement(), this.oDatabaseDocument);
        if (this.honourPropagationConstraintsInContextSharing) {
            Iterable edges = this.getElement().getEdges(ODirection.OUT);
            for (OEdge edge : edges) {
                RelationManagement relationManagement = this.getRelationManagement(edge);
                relationManagement.setDryRun(this.dryRun);
                relationManagement.setHonourPropagationConstraintsInContextSharing(this.honourPropagationConstraintsInContextSharing);
                relationManagement.setSourceInstanceEnvironment(this.sourceInstanceEnvironment);
                relationManagement.setTargetInstanceEnvironment(this.targetInstanceEnvironment);
                relationManagement.internalAddToContext();
                this.affectedInstances.putAll(relationManagement.getAffectedInstances());
            }
        }
    }

    public void internalAddToContext() throws ContextException, ResourceRegistryException {
        try {
            this.setOperation(Operation.ADD_TO_CONTEXT);
            this.reallyAddToContext();
            if (!this.skipped) {
                MetadataUtility.updateModifiedByAndLastUpdate((OElement)this.element);
                ((OVertex)this.element).save();
                this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
                this.sanityCheck();
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Adding " + this.typeName + " to " + this.targetInstanceEnvironment.toString(), e.getCause());
        }
    }

    public void addToContext(UUID contextUUID) throws SchemaViolationException, NotFoundException, ContextException, ResourceRegistryException {
        String contextFullName = ServerContextCache.getInstance().getContextFullNameByUUID(contextUUID);
        this.logger.info("Going to add {} with UUID {} to Context with UUID {} (i.e. {})", new Object[]{this.accessType.getName(), this.uuid, contextUUID, contextFullName});
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.workingEnvironment = AdminEnvironment.getInstance();
            this.oDatabaseDocument = this.workingEnvironment.getDatabaseDocument(Environment.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.setAsEntryPoint();
            this.sourceInstanceEnvironment = ContextUtility.getCurrentRequestEnvironment();
            this.targetInstanceEnvironment = ContextUtility.getInstance().getEnvironmentByUUID(contextUUID);
            this.internalAddToContext();
            if (!this.dryRun) {
                this.oDatabaseDocument.commit();
            } else {
                this.oDatabaseDocument.rollback();
            }
            this.logger.info("{} with UUID {} successfully added to Context with UUID {} (i.e. {})", new Object[]{this.typeName, this.uuid, contextUUID, contextFullName});
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {} (i.e. {}) - Reason is {}", new Object[]{this.typeName, this.uuid, contextUUID, contextFullName, e.getMessage()});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {} (i.e. {})", new Object[]{this.typeName, this.uuid, contextUUID, contextFullName, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public void internalRemoveFromContext() throws ContextException, ResourceRegistryException {
        try {
            this.setOperation(Operation.REMOVE_FROM_CONTEXT);
            this.reallyRemoveFromContext();
            MetadataUtility.updateModifiedByAndLastUpdate((OElement)this.element);
            ((OVertex)this.element).save();
            this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
            this.sanityCheck();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Removing " + this.typeName + " from " + this.targetInstanceEnvironment.toString(), e.getCause());
        }
    }

    protected void reallyRemoveFromContext() throws ContextException, ResourceRegistryException {
        if (!this.targetInstanceEnvironment.isElementInContext((OElement)this.getElement())) {
            return;
        }
        if (this.honourPropagationConstraintsInContextSharing) {
            Iterable edges = this.getElement().getEdges(ODirection.OUT);
            for (OEdge edge : edges) {
                RelationManagement relationManagement = this.getRelationManagement(edge);
                relationManagement.setDryRun(this.dryRun);
                relationManagement.setHonourPropagationConstraintsInContextSharing(this.honourPropagationConstraintsInContextSharing);
                relationManagement.setTargetInstanceEnvironment(this.targetInstanceEnvironment);
                relationManagement.internalRemoveFromContext();
                this.addToRelationManagements(relationManagement);
                this.affectedInstances.putAll(relationManagement.getAffectedInstances());
            }
        }
        this.targetInstanceEnvironment.removeElement((OElement)this.getElement(), this.oDatabaseDocument);
    }

    public void removeFromContext(UUID contextUUID) throws SchemaViolationException, NotFoundException, ContextException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {} from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID});
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.workingEnvironment = AdminEnvironment.getInstance();
            this.oDatabaseDocument = this.workingEnvironment.getDatabaseDocument(Environment.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.setAsEntryPoint();
            this.targetInstanceEnvironment = ContextUtility.getInstance().getEnvironmentByUUID(contextUUID);
            this.internalRemoveFromContext();
            if (!this.dryRun) {
                this.oDatabaseDocument.commit();
            } else {
                this.oDatabaseDocument.rollback();
            }
            this.logger.info("{} with UUID {} successfully removed from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID});
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        int limit = requestInfo.getLimit();
        int offset = requestInfo.getOffset();
        int position = -1;
        int count = 0;
        ORecordIteratorClass iterable = this.oDatabaseDocument.browseClass(this.typeName, polymorphic);
        for (ODocument vertex : iterable) {
            if (++position < offset) continue;
            EntityManagement entityManagement = ElementManagementUtility.getEntityManagement((Environment)this.getWorkingEnvironment(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)((OVertex)vertex));
            try {
                entityManagement.setAsEntryPoint();
                JsonNode jsonNode = entityManagement.serializeAsJsonNode();
                arrayNode.add(jsonNode);
                if (limit <= 0 || ++count < limit) continue;
                break;
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String reallyQuery(String relationType, String referenceType, UUID referenceUUID, ODirection direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        Integer offset;
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        if (referenceUUID != null) {
            constraint.put("id", referenceUUID.toString());
        }
        StringBuffer selectStringBuffer = new StringBuffer();
        selectStringBuffer.append("SELECT FROM (TRAVERSE ");
        selectStringBuffer.append(direction.name().toLowerCase());
        selectStringBuffer.append("V('");
        selectStringBuffer.append(this.typeName);
        selectStringBuffer.append("')");
        selectStringBuffer.append(", ");
        selectStringBuffer.append(direction.opposite().name().toLowerCase());
        selectStringBuffer.append("E('");
        selectStringBuffer.append(relationType);
        selectStringBuffer.append("')");
        selectStringBuffer.append(" FROM (SELECT FROM ");
        selectStringBuffer.append(referenceType);
        boolean first = true;
        for (String key : constraint.keySet()) {
            if (first) {
                selectStringBuffer.append(" WHERE ");
                first = false;
            } else {
                selectStringBuffer.append(" AND ");
            }
            selectStringBuffer.append(key);
            selectStringBuffer.append("=");
            String value = constraint.get(key).trim();
            selectStringBuffer.append("'");
            selectStringBuffer.append(value);
            selectStringBuffer.append("'");
        }
        selectStringBuffer.append(" ))");
        selectStringBuffer.append(" WHERE @class");
        if (polymorphic) {
            selectStringBuffer.append(" INSTANCEOF '");
        } else {
            selectStringBuffer.append("='");
        }
        selectStringBuffer.append(this.typeName);
        selectStringBuffer.append("'");
        ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        Integer limit = requestInfo.getLimit();
        if (limit == null) {
            limit = -1;
        }
        if ((offset = requestInfo.getOffset()) == null) {
            offset = 0;
        }
        selectStringBuffer.append(" SKIP :offset");
        selectStringBuffer.append(" LIMIT :limit");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("offset", offset);
        map.put("limit", limit);
        String select = selectStringBuffer.toString();
        this.logger.trace(select);
        OResultSet resultSet = this.oDatabaseDocument.command(select, map);
        while (resultSet.hasNext()) {
            OResult oResult = resultSet.next();
            OElement element = ElementManagementUtility.getElementFromOptional((Optional)oResult.getElement());
            OVertex vertex = (OVertex)element;
            EntityManagement entityManagement = ElementManagementUtility.getEntityManagement((Environment)this.getWorkingEnvironment(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)vertex);
            try {
                if (constraint.containsKey("id")) {
                    String uuid = constraint.get("id");
                    if (entityManagement.getUUID().compareTo(UUID.fromString(uuid)) == 0) continue;
                }
                entityManagement.setAsEntryPoint();
                JsonNode jsonNode = entityManagement.serializeAsJsonNode();
                arrayNode.add(jsonNode);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String query(String relationType, String referenceType, UUID referenceUUID, ODirection direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.workingEnvironment = AdminEnvironment.getInstance();
            this.oDatabaseDocument = this.workingEnvironment.getDatabaseDocument(Environment.PermissionMode.READER);
            this.setAsEntryPoint();
            this.setOperation(Operation.QUERY);
            TypesCache typesCache = TypesCache.getInstance();
            AccessType relationAccessType = typesCache.getCachedType(relationType).getAccessType();
            if (relationAccessType != AccessType.IS_RELATED_TO && relationAccessType != AccessType.CONSISTS_OF) {
                String error = "%s must be a relation type".formatted(relationType);
                throw new ResourceRegistryException(error);
            }
            AccessType referenceAccessType = typesCache.getCachedType(referenceType).getAccessType();
            if (referenceAccessType != AccessType.RESOURCE && referenceAccessType != AccessType.FACET) {
                String error = "%s must be a en entity type".formatted(referenceType);
                throw new ResourceRegistryException(error);
            }
            if (constraint == null) {
                constraint = new HashMap<String, String>();
            }
            switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[this.accessType.ordinal()]) {
                case 1: {
                    if (relationAccessType != AccessType.CONSISTS_OF) break;
                    if (direction != ODirection.OUT) {
                        String error = "%s can only goes %s from %s.".formatted(relationType, ODirection.OUT.name(), this.typeName);
                        throw new InvalidQueryException(error);
                    }
                    if (referenceAccessType == AccessType.FACET) break;
                    String error = "%s can only has as target a %s. Provided instead %s : %s".formatted(relationType, "Facet", referenceAccessType, referenceType);
                    throw new InvalidQueryException(error);
                }
                case 2: {
                    if (relationAccessType == AccessType.CONSISTS_OF && direction == ODirection.IN && referenceAccessType == AccessType.RESOURCE) break;
                    String error = "%s can only has %s %s from a %s.".formatted(this.typeName, ODirection.IN.name(), "ConsistsOf", "Resource");
                    throw new InvalidQueryException(error);
                }
            }
            String string = this.reallyQuery(relationType, referenceType, referenceUUID, direction, polymorphic, constraint);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public void setForceAddToContext(Boolean forceAddToContext) {
        this.forceAddToContext = forceAddToContext;
    }
}

