/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.Method;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.types.TypeManagement;
import org.gcube.informationsystem.types.TypeMapper;

@Path(value="types")
@Tag(name="Types", description="Operations for managing type definitions in the Resource Registry.")
public class TypeManager
extends BaseRest {
    public static final String TYPE_PATH_PARAMETER = "type-name";

    public Response cleanCache() {
        try {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{type-name}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Create Type Definition", description="Creates a new type definition in the Information System.\n\nOnly the highest level administrative users can perform this operation due to its system-wide impact.\n\n\n**Request Examples:**\n- PUT /types/ContactFacet (creates a new ContactFacet type definition);\n- PUT /types/MyCustomResource (creates a new custom resource type).\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can create any type definition without restrictions;\n\t- Has full administrative privileges across the entire Information System.\n\n- **Infrastructure-Manager:**\n\t- Can create any type definition without restrictions;\n\t- Has full administrative privileges across the entire Information System.\n\n- **All Other Users (including Context-Manager):**\n\t- Cannot create type definitions;\n\t- Will receive authorization errors if attempting these operations;\n\t- Type creation is restricted to prevent system-wide compatibility issues.\n\n\n**Operation Behavior:**\n\n**Type Update Policy:**\n\n**No REST Update Method Exposed:**\n- Although the underlying code supports type updates, the update functionality is intentionally NOT exposed via REST API;\n- Type modifications can break compatibility across the entire Information System;\n- Examples of breaking changes:\n\t- Making a previously optional facet property mandatory;\n\t- Changing property types or constraints;\n\t- Modifying validation rules that could invalidate existing instances.\n\n**Offline Update Process:**\n- Type updates must be performed offline after careful impact assessment;\n- Changes require evaluation of all existing instances and dependent systems;\n- Updates are applied through controlled maintenance procedures;\n- This ensures system stability and prevents breaking existing client applications.\n")
    @APIResponses(value={@APIResponse(responseCode="201", description="Type successfully created", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="409", description="Type already exists with the given name"), @APIResponse(responseCode="400", description="Invalid JSON schema or malformed request"), @APIResponse(responseCode="403", description="User lacks authorization to create types")})
    public Response create(@PathParam(value="type-name") @Parameter(name="type-name", in=ParameterIn.PATH, description="The name of the type to create.\n- Must be unique in the system (e.g., \"ContactFacet\", \"MyCustomResource\").\n", required=true, schema=@Schema(type=SchemaType.STRING, example="ContactFacet")) String typeName, String json) throws SchemaException, ResourceRegistryException {
        this.logger.info("Requested {} creation with schema {}", (Object)typeName, (Object)json);
        this.setAccountingMethod(Method.CREATE, "Type");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setIncludeMeta(true);
        serverRequestInfo.setAllMeta(true);
        TypeManagement typeManagement = new TypeManagement();
        typeManagement.setTypeName(typeName);
        typeManagement.setJson(json);
        String ret = typeManagement.create();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @GET
    @Path(value="{type-name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Read Type Schema(s)", description="Retrieves the schema definition(s) for the specified type.\n\nThe response can include subtypes and metadata based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /types/ContactFacet (returns basic ContactFacet type definition only);\n- GET /types/ContactFacet?polymorphic=true (returns ContactFacet and all its subtypes);\n- GET /types/ContactFacet?includeMeta=true (returns ContactFacet with metadata for authorized users);\n- GET /types/ContactFacet?polymorphic=true&includeMeta=true (returns ContactFacet, subtypes, and metadata).\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Receive basic type information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive complete type definitions with full metadata;\n\t- All metadata fields are included when includeMeta=true;\n\t- No obfuscation or filtering of sensitive information.\n\n- **Infrastructure-Manager:**\n\t- Receive basic type information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive complete type definitions with full metadata;\n\t- All metadata fields are included when includeMeta=true;\n\t- No obfuscation or filtering of sensitive information.\n\n- **All Other Users:**\n\t- Receive basic type information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive metadata with sensitive information filtered:\n\t\t- Date fields (creation, modification) are visible;\n\t\t- User identifiers (createdBy, lastUpdateBy) are obfuscated or hidden;\n\t\t- Other administrative details may be filtered.\n")
    @Parameters(value={@Parameter(name="polymorphic", in=ParameterIn.QUERY, description="Whether to include subtypes in the response.\n- Default: false (returns only the specified type);\n- When true: returns the specified type AND all its existing subtypes;\n- When false: returns only the specified type definition;\n- Note: No pagination is applied - ALL subtypes are returned when polymorphic=true;\n- Example: ?polymorphic=true (includes all subtypes of the requested type).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response.\n- Default: false (basic type information only);\n- Values: true|false;\n- Example: ?includeMeta=true (includes metadata based on user authorization).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Type successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Type with the specified name does not exist"), @APIResponse(responseCode="403", description="User lacks authorization to access type information")})
    public String read(@PathParam(value="type-name") @Parameter(name="type-name", in=ParameterIn.PATH, description="The name of the type to retrieve (case-sensitive)", required=true, schema=@Schema(type=SchemaType.STRING, example="ContactFacet")) String type, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        this.logger.info("Requested Schema for type {}", (Object)type);
        this.setAccountingMethod(Method.READ, "Type");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        TypeManagement typeManagement = new TypeManagement();
        typeManagement.setTypeName(type);
        List types = typeManagement.read(polymorphic.booleanValue());
        try {
            return TypeMapper.serializeTypeDefinitions((List)types);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }
}

