/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.instancestates;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.informationsystem.publisher.impl.generic.GCUBEGenericBulkPublisher;
import org.gcube.common.informationsystem.publisher.impl.instancestates.InstanceResource;
import org.gcube.common.informationsystem.publisher.impl.instancestates.WSRPDocument;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.BaseISPublisherHandler;
import org.gcube.informationsystem.collector.stubs.metadata.MetadataRecord;
import org.gcube.informationsystem.collector.stubs.metadata.MetadataWriter;
import org.w3c.dom.Document;

abstract class BaseInstanceStateHandler
extends BaseISPublisherHandler {
    protected final GCUBEWSResource resource;
    protected String[] name;
    protected GCUBEScope publishingScope;
    protected WSRPDocument rpd;
    protected Document metadata;
    protected static final String providerRPPrefix = "provider";
    protected static final String RPD_COLLECTION_NAME = "gcube://Properties";

    public BaseInstanceStateHandler(GCUBEWSResource gCUBEWSResource, GCUBEScope gCUBEScope, String string, String ... stringArray) throws Exception {
        this.resource = gCUBEWSResource;
        this.name = stringArray;
        this.publishingScope = gCUBEScope;
        this.rpd = new WSRPDocument(gCUBEWSResource);
        this.metadata = this.getMetadata(this.rpd, string).getAsDocument();
        logger.trace((Object)("Instance state handler created for resource " + this.rpd.getID() + " in scope " + this.publishingScope));
    }

    @Override
    public String getResourceID() {
        return ((GCUBEWSResourceKey)this.resource.getID()).toString();
    }

    public String getResourceName() {
        return this.rpd.getName();
    }

    protected MetadataRecord getMetadata(WSRPDocument wSRPDocument, String string) throws Exception {
        return new MetadataWriter(MetadataRecord.TYPE.INSTANCESTATE, wSRPDocument.getSource(), Integer.valueOf(wSRPDocument.getPollingInterval() * 3 / 1000), "", wSRPDocument.getSourceID(), "", wSRPDocument.getNamespace(), string).getRecord();
    }

    protected void register() throws Exception {
        String string = this.rpd.getName();
        logger.info((Object)("ISPublisher is going to publish the Resource Property document from " + string + ":\n" + this.rpd));
        try {
            GCUBEGenericBulkPublisher gCUBEGenericBulkPublisher = new GCUBEGenericBulkPublisher();
            gCUBEGenericBulkPublisher.register(InstanceResource.fromGCUBEWSResource(this.rpd), this.publishingScope, this.metadata);
        }
        catch (Exception exception) {
            throw new Exception("Unable to read RPs from the WSResource " + string, exception);
        }
    }
}

