/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.resources;

import java.io.StringWriter;
import java.io.Writer;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.BaseISPublisherHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryClient;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryServicePublisherHandler;

public class CreateResourceHandler
extends BaseISPublisherHandler {
    protected static final GCUBELog logger = new GCUBELog(CreateResourceHandler.class);
    private GCUBEScope scope;
    private ISRegistryClient registryClient;
    private final GCUBEResource profile;

    public CreateResourceHandler(GCUBEScope gCUBEScope, ISRegistryClient iSRegistryClient, GCUBEResource gCUBEResource) {
        this.scope = gCUBEScope;
        this.registryClient = iSRegistryClient;
        this.profile = gCUBEResource;
    }

    @Override
    public String getResourceID() {
        return this.profile.getID();
    }

    @Override
    protected void submitRequest() throws Exception {
        this.registryClient.setScope(this.scope);
        try {
            ISRegistryServicePublisherHandler iSRegistryServicePublisherHandler = new ISRegistryServicePublisherHandler();
            iSRegistryServicePublisherHandler.setResourceType(this.profile.getType());
            iSRegistryServicePublisherHandler.setResourceID(this.profile.getID());
            StringWriter stringWriter = new StringWriter();
            this.profile.store((Writer)stringWriter);
            iSRegistryServicePublisherHandler.setProfile(stringWriter.toString());
            iSRegistryServicePublisherHandler.setHandled((Object)this.registryClient);
            iSRegistryServicePublisherHandler.run();
            logger.trace((Object)("Resource with ID=" + this.profile.getID() + " successfully published"));
            return;
        }
        catch (GCUBEUnrecoverableException gCUBEUnrecoverableException) {
            logger.warn((Object)"Registration failed", (Throwable)gCUBEUnrecoverableException);
            return;
        }
        catch (Exception exception) {
            logger.warn((Object)"Registration failed, trying again in a few time...");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }
}

