/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.generic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.informationsystem.publisher.ISGenericPublisher;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.informationsystem.publisher.ISResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;
import org.gcube.common.informationsystem.publisher.impl.context.ISPublisherContext;
import org.gcube.common.informationsystem.publisher.impl.generic.CollectorClient;
import org.gcube.common.informationsystem.publisher.impl.generic.SinkLoader;
import org.w3c.dom.Document;

public class GCUBEGenericBulkPublisher
implements ISGenericPublisher {
    protected static final GCUBELog logger = new GCUBELog(GCUBEGenericBulkPublisher.class);
    static Map<GCUBEScope, Map<String, Set<ResourceData>>> toRegisterQueue = Collections.synchronizedMap(new HashMap());
    static Map<GCUBEScope, Map<String, Set<ISResource>>> toRemoveQueue = Collections.synchronizedMap(new HashMap());
    static final long PUBLICATION_INTERVAL = 20000L;
    private static Map<GCUBEScope, Set<EndpointReferenceType>> rpdSinks = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();
    private static Map<GCUBEScope, Set<EndpointReferenceType>> profileSinks = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();
    private static Map<GCUBEScope, Set<EndpointReferenceType>> daixSinks = new HashMap<GCUBEScope, Set<EndpointReferenceType>>();

    public synchronized void register(ISResource iSResource, GCUBEScope gCUBEScope, Document document) throws ISPublisherException {
        logger.trace((Object)("Schedule registration of resource " + iSResource.getID() + " to  " + iSResource.getCollection() + " in scope " + gCUBEScope));
        if (!toRegisterQueue.containsKey(gCUBEScope)) {
            toRegisterQueue.put(gCUBEScope, new HashMap());
        }
        if (!toRegisterQueue.get(gCUBEScope).containsKey(iSResource.getCollection())) {
            toRegisterQueue.get(gCUBEScope).put(iSResource.getCollection(), new HashSet());
        }
        ResourceData resourceData = new ResourceData(iSResource, document);
        logger.trace((Object)("Queue size before clean up is " + toRegisterQueue.get(gCUBEScope).get(iSResource.getCollection()).size()));
        if (toRegisterQueue.get(gCUBEScope).get(iSResource.getCollection()).contains(resourceData)) {
            toRegisterQueue.get(gCUBEScope).get(iSResource.getCollection()).remove(resourceData);
        }
        logger.trace((Object)("Adding " + iSResource.getID() + " to the registration queue"));
        logger.trace((Object)("Queue size before is " + toRegisterQueue.get(gCUBEScope).get(iSResource.getCollection()).size()));
        toRegisterQueue.get(gCUBEScope).get(iSResource.getCollection()).add(resourceData);
        logger.trace((Object)("Queue size after is " + toRegisterQueue.get(gCUBEScope).get(iSResource.getCollection()).size()));
    }

    public synchronized void register(ISResource iSResource, GCUBEScope gCUBEScope) throws ISPublisherException {
        this.register(iSResource, gCUBEScope, null);
    }

    public void register(List<ISResource> list, GCUBEScope gCUBEScope) throws ISPublisherException {
        for (ISResource iSResource : list) {
            this.register(iSResource, gCUBEScope);
        }
    }

    public void update(List<ISResource> list, GCUBEScope gCUBEScope) throws ISPublisherException {
        for (ISResource iSResource : list) {
            this.update(iSResource, gCUBEScope);
        }
    }

    public void remove(List<ISResource> list, GCUBEScope gCUBEScope) throws ISPublisherException {
        for (ISResource iSResource : list) {
            this.remove(iSResource, gCUBEScope);
        }
    }

    public synchronized void update(ISResource iSResource, GCUBEScope gCUBEScope) throws ISPublisherException {
        this.register(iSResource, gCUBEScope);
    }

    public synchronized void remove(ISResource iSResource, GCUBEScope gCUBEScope) throws ISPublisherException {
        logger.trace((Object)("Schedule removal of resource " + iSResource.getID() + " from  " + iSResource.getCollection() + " in scope " + gCUBEScope));
        if (!toRemoveQueue.containsKey(gCUBEScope)) {
            toRemoveQueue.put(gCUBEScope, new HashMap());
        }
        if (!toRemoveQueue.get(gCUBEScope).containsKey(iSResource.getCollection())) {
            toRemoveQueue.get(gCUBEScope).put(iSResource.getCollection(), new HashSet());
        }
        toRemoveQueue.get(gCUBEScope).get(iSResource.getCollection()).add(iSResource);
    }

    static {
        new ParallelPublisher("BulkPublisher").start();
    }

    static class ParallelPublisher
    extends Thread {
        public ParallelPublisher(String string) {
            super(string);
        }

        @Override
        public void run() {
            int n = this.getInterval();
            while (true) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    new ParallelPublisher("BulkPublisher").start();
                    break;
                }
                this.manageRegistrations();
                this.manageDeletions();
            }
        }

        private int getInterval() {
            try {
                return (Integer)ISPublisherContext.getContext().getProperty("BULK_PUBLICATIONS_INTERVAL");
            }
            catch (Exception exception) {
                return 20000;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageRegistrations() {
            Map<GCUBEScope, Map<String, Set<ResourceData>>> map = toRegisterQueue;
            synchronized (map) {
                for (GCUBEScope gCUBEScope : toRegisterQueue.keySet()) {
                    Map<String, Set<ResourceData>> map2 = toRegisterQueue.get(gCUBEScope);
                    for (String string : map2.keySet()) {
                        if (map2.get(string).size() <= 0) continue;
                        try {
                            logger.trace((Object)("Re-publishing " + map2.get(string).size() + " documents in " + string));
                            this.publish(gCUBEScope, string, map2.get(string));
                            map2.get(string).clear();
                        }
                        catch (Exception exception) {
                            logger.error((Object)("Unable to publish resources for " + string + " in scope " + gCUBEScope), (Throwable)exception);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            new ParallelPublisher("BulkPublisher").start();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageDeletions() {
            Map<GCUBEScope, Map<String, Set<ISResource>>> map = toRemoveQueue;
            synchronized (map) {
                for (GCUBEScope gCUBEScope : toRemoveQueue.keySet()) {
                    Map<String, Set<ISResource>> map2 = toRemoveQueue.get(gCUBEScope);
                    for (String string : map2.keySet()) {
                        if (map2.get(string).size() <= 0) continue;
                        try {
                            this.erase(gCUBEScope, string, map2.get(string));
                            map2.get(string).clear();
                        }
                        catch (Exception exception) {
                            logger.error((Object)("Unable to remove resources for " + string + " in scope " + gCUBEScope), (Throwable)exception);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            new ParallelPublisher("BulkPublisher").start();
                        }
                    }
                }
            }
        }

        private void publish(GCUBEScope gCUBEScope, String string, Set<ResourceData> set) throws Exception {
            Document[] documentArray = new Document[set.size()];
            Document[] documentArray2 = new Document[set.size()];
            String[] stringArray = new String[set.size()];
            int n = 0;
            for (ResourceData object2 : set) {
                documentArray[n] = object2.resource.getDocument();
                documentArray2[n] = object2.metadata;
                stringArray[n] = object2.resource.getID();
                ++n;
            }
            Set<EndpointReferenceType> set2 = this.getSinks(set.iterator().next().resource.getType(), gCUBEScope);
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                EndpointReferenceType endpointReferenceType = (EndpointReferenceType)iterator.next();
                int n2 = 0;
                boolean bl = false;
                while (n2++ < 3 && !bl) {
                    logger.trace((Object)("Adding " + set.size() + " resources to " + string + " in scope " + gCUBEScope));
                    try {
                        CollectorClient.addDocuments(endpointReferenceType, gCUBEScope, new URI("gcube://unused"), new URI("gcube://" + string), stringArray, documentArray, documentArray2);
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Failed to send the Resource to the IC instance in scope " + gCUBEScope), (Throwable)exception);
                    }
                }
                if (bl) continue;
                throw new GCUBEPublisherException("Failed to send the Resource to the IC instance in scope " + gCUBEScope);
            }
        }

        private void erase(GCUBEScope gCUBEScope, String string, Set<ISResource> set) throws Exception {
            String[] stringArray = new String[set.size()];
            int n = 0;
            for (ISResource object2 : set) {
                stringArray[n++] = object2.getID();
            }
            Set<EndpointReferenceType> set2 = this.getSinks(set.iterator().next().getType(), gCUBEScope);
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                EndpointReferenceType endpointReferenceType = (EndpointReferenceType)iterator.next();
                int n2 = 0;
                boolean bl = false;
                while (n2++ < 3 && !bl) {
                    logger.trace((Object)("Removing " + set.size() + " resources from " + string + " in scope " + gCUBEScope));
                    try {
                        CollectorClient.removeDocuments(endpointReferenceType, gCUBEScope, new URI("gcube://unused"), new URI("gcube://" + string), stringArray);
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Failed to remove the Resources from the IC instance in scope " + gCUBEScope), (Throwable)exception);
                    }
                }
                if (bl) continue;
                throw new GCUBEPublisherException("Failed to remove the Resources from the IC instance in scope " + gCUBEScope);
            }
        }

        private Set<EndpointReferenceType> getSinks(ISResource.ISRESOURCETYPE iSRESOURCETYPE, GCUBEScope gCUBEScope) throws ISPublisherException {
            switch (iSRESOURCETYPE) {
                case PROFILE: {
                    if (!profileSinks.containsKey(gCUBEScope)) {
                        profileSinks.put(gCUBEScope, SinkLoader.loadResourceSinks(gCUBEScope));
                    }
                    return (Set)profileSinks.get(gCUBEScope);
                }
                case RPD: {
                    if (!rpdSinks.containsKey(gCUBEScope)) {
                        rpdSinks.put(gCUBEScope, SinkLoader.loadStateSinks(gCUBEScope));
                    }
                    return (Set)rpdSinks.get(gCUBEScope);
                }
                case WSDAIX: {
                    if (!daixSinks.containsKey(gCUBEScope)) {
                        daixSinks.put(gCUBEScope, SinkLoader.loadWSDAIXSinks(gCUBEScope));
                    }
                    return (Set)daixSinks.get(gCUBEScope);
                }
            }
            throw new GCUBEPublisherException("Unable to find any IC instance to publish");
        }
    }

    class ResourceData {
        ISResource resource;
        Document metadata;

        ResourceData(ISResource iSResource, Document document) {
            this.resource = iSResource;
            this.metadata = document;
        }

        public int hashCode() {
            return this.resource.getID().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ResourceData resourceData = (ResourceData)object;
            return !(this.resource == null ? resourceData.resource != null : !this.resource.getID().equals(resourceData.resource.getID()));
        }
    }
}

