/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.instancestates;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.gcube.common.core.state.GCUBEPublicationProfile;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.state.GCUBEWSResourcePropertySet;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.utils.AnyHelper;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

final class WSRPDocument {
    private static final GCUBELog logger = new GCUBELog(WSRPDocument.class);
    private GCUBEWSResource resource;
    private PublicationProfileParser parser;
    private int pollingInterval = 600;
    private List<QName> resourcePropertyNames;

    WSRPDocument(GCUBEWSResource gCUBEWSResource) throws Exception {
        this.resource = gCUBEWSResource;
        this.parser = new PublicationProfileParser(gCUBEWSResource.getPorttypeContext().getPublicationProfile());
        this.parser.parse();
        this.initializetResourcePropertyNames();
        this.pollingInterval = this.parser.getPollingInterval();
    }

    void initializetResourcePropertyNames() throws Exception {
        this.resourcePropertyNames = new ArrayList<QName>();
        GCUBEWSResourcePropertySet gCUBEWSResourcePropertySet = this.resource.getResourcePropertySet();
        if (gCUBEWSResourcePropertySet == null) {
            throw new Exception("Null property set from " + this.getName());
        }
        try {
            List<QName> list = this.parser.getRPNames();
            for (QName qName : list) {
                logger.trace((Object)("found RP " + qName));
                this.resourcePropertyNames.add(qName);
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Unable to retrieve the RP names from " + this.getName()), (Throwable)exception);
            throw exception;
        }
    }

    Map<QName, SOAPElement[]> getResourcePropertyValues() throws Exception {
        LinkedHashMap<QName, SOAPElement[]> linkedHashMap = new LinkedHashMap<QName, SOAPElement[]>();
        GCUBEWSResourcePropertySet gCUBEWSResourcePropertySet = this.resource.getResourcePropertySet();
        for (QName qName : this.resourcePropertyNames) {
            try {
                ResourceProperty resourceProperty = gCUBEWSResourcePropertySet.get(qName);
                if (resourceProperty == null) {
                    logger.warn((Object)("Null value for RP " + qName));
                    continue;
                }
                linkedHashMap.put(qName, resourceProperty.toSOAPElements());
            }
            catch (Exception exception) {
                logger.error((Object)("Failed to retrieve the value of RP " + qName), (Throwable)exception);
            }
        }
        for (String string : GCUBEWSResourcePropertySet.getSystemRPNames()) {
            try {
                ResourceProperty resourceProperty = gCUBEWSResourcePropertySet.getSystemRP(string);
                if (resourceProperty == null) {
                    logger.warn((Object)("Null value for RP " + string));
                    continue;
                }
                linkedHashMap.put(new QName("http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider", string), resourceProperty.toSOAPElements());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.error((Object)("Failed to retrieve the value of RP " + string), (Throwable)exception);
            }
        }
        logger.trace((Object)"Resource Property values successfully read");
        return linkedHashMap;
    }

    int getPollingInterval() {
        return this.pollingInterval;
    }

    String getSource() throws Exception {
        return this.resource.getEPR().getAddress().toString();
    }

    String getName() {
        return this.resource.getClass().getSimpleName() + "(" + this.resource.getID() + ")";
    }

    Document query() throws Exception {
        logger.trace((Object)("Querying RPs for " + this.getName()));
        int n = 0;
        Exception exception = null;
        while (n++ < 3) {
            try {
                Map<QName, SOAPElement[]> map = this.getResourcePropertyValues();
                if (map == null) {
                    logger.warn((Object)"No RPs' values available at registration time");
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<ResourceProperties>");
                ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>();
                for (QName qName : map.keySet()) {
                    if (qName == null) continue;
                    if (map.get(qName) == null) {
                        logger.trace((Object)("Skipping null values for RP " + qName));
                        continue;
                    }
                    for (SOAPElement sOAPElement : map.get(qName)) {
                        if (sOAPElement == null) {
                            logger.warn((Object)("Skipping null value for " + qName));
                            continue;
                        }
                        arrayList.add((MessageElement)sOAPElement);
                    }
                }
                stringBuilder.append(AnyHelper.toSingleString((MessageElement[])arrayList.toArray(new MessageElement[arrayList.size()])));
                stringBuilder.append("</ResourceProperties>");
                logger.trace((Object)("Resource property document is " + stringBuilder));
                return this.getAsDocument(stringBuilder.toString());
            }
            catch (Exception exception2) {
                logger.warn((Object)"Failed to read the RPs", (Throwable)exception2);
                exception = exception2;
                Thread.sleep(1000L);
            }
        }
        throw exception;
    }

    private Document getAsDocument(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        return documentBuilder.parse(inputSource);
    }

    String getID() throws Exception {
        String string = this.resource.getEPR().getAddress().toString();
        String string2 = ((GCUBEWSResourceKey)this.resource.getID()).getValue();
        return string.replace("http://", "").replace(":", "").replace("/", "-") + "-" + string2.replace("http://", "").replace(":", "").replace("/", "-");
    }

    String getSourceID() throws Exception {
        return ((GCUBEWSResourceKey)this.resource.getID()).getValue();
    }

    static String getID(GCUBEWSResource gCUBEWSResource) throws Exception {
        String string = gCUBEWSResource.getEPR().getAddress().toString();
        String string2 = ((GCUBEWSResourceKey)gCUBEWSResource.getID()).getValue();
        return string.replace("http://", "").replace(":", "").replace("/", "-") + "-" + string2.replace("http://", "").replace(":", "").replace("/", "-");
    }

    String getNamespace() throws Exception {
        return ((GCUBEWSResourceKey)this.resource.getID()).getName().getNamespaceURI();
    }

    private static class PublicationProfileParser {
        private GCUBEPublicationProfile profile;
        private List<QName> names;
        private Integer pollInterval;

        PublicationProfileParser(GCUBEPublicationProfile gCUBEPublicationProfile) {
            this.profile = gCUBEPublicationProfile;
            this.names = new ArrayList<QName>();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void parse() throws Exception {
            logger.trace((Object)("Parsing pubblication profile " + this.profile.getAbsoluteFileName()));
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.profile.getAbsoluteFileName()));
            KXmlParser kXmlParser = new KXmlParser();
            kXmlParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                kXmlParser.setInput((Reader)bufferedReader);
                boolean bl = false;
                boolean bl2 = false;
                block8: while (true) {
                    switch (kXmlParser.next()) {
                        case 2: {
                            for (int i = kXmlParser.getNamespaceCount(kXmlParser.getDepth() - 1); i < kXmlParser.getNamespaceCount(kXmlParser.getDepth()); ++i) {
                                logger.trace((Object)("Found namespace " + kXmlParser.getNamespacePrefix(i) + ", uri " + kXmlParser.getNamespaceUri(i)));
                                hashMap.put(kXmlParser.getNamespacePrefix(i), kXmlParser.getNamespaceUri(i));
                                hashMap.put(kXmlParser.getNamespacePrefix(i), kXmlParser.getNamespaceUri(i));
                            }
                            if (kXmlParser.getName().equalsIgnoreCase("ResourcePropertyNames")) {
                                bl = true;
                            }
                            if (!kXmlParser.getName().equalsIgnoreCase("PollIntervalMillis")) break;
                            bl2 = true;
                            break;
                        }
                        case 4: {
                            if (bl) {
                                Object[] objectArray = kXmlParser.getText().split(":");
                                logger.trace((Object)("Parsing RP: " + Arrays.toString(objectArray)));
                                this.names.add(new QName(kXmlParser.getNamespace((String)objectArray[0]), (String)objectArray[objectArray.length - 1]));
                                bl = false;
                            }
                            if (!bl2) break;
                            this.pollInterval = Integer.valueOf(kXmlParser.getText());
                            bl2 = false;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 1: {
                            break block8;
                        }
                    }
                }
                bufferedReader.close();
                return;
            }
            catch (Exception exception) {
                logger.warn((Object)("Could not configure resource publication because " + exception.getMessage()));
                throw exception;
            }
        }

        List<QName> getRPNames() {
            return this.names;
        }

        int getPollingInterval() {
            return this.pollInterval;
        }
    }
}

