/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.resources;

import java.util.List;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.ServiceMap;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.local.GCUBELocalPublisher;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryClient;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstance;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstanceGroup;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryLookup;
import org.gcube.common.informationsystem.publisher.impl.resources.CreateResourceHandler;
import org.gcube.common.informationsystem.publisher.impl.resources.RemoveResourceHandler;
import org.gcube.common.informationsystem.publisher.impl.resources.UpdateResourceHandler;
import org.gcube.informationsystem.registry.stubs.RegistryFactoryPortType;

public final class RegistryResourcePublisher {
    protected static final GCUBELog logger = new GCUBELog(RegistryResourcePublisher.class);
    protected RegistryFactoryPortType registryFactoryPortType;
    private GCUBEScope scope;
    protected List<EndpointReferenceType> ICEprs;
    protected ISRegistryClient registryClient = ISRegistryClient.getISRegistryClient();

    public RegistryResourcePublisher(GCUBEScope gCUBEScope) throws Exception {
        this.scope = gCUBEScope;
    }

    public void create(GCUBEResource gCUBEResource) throws Exception {
        if (this.useLocalEventsForResource(gCUBEResource.getType())) {
            GCUBELocalPublisher.getManager().notifyResourceRegistered(gCUBEResource, this.scope);
        } else {
            logger.trace((Object)("Trying to publish resource with ID=" + gCUBEResource.getID() + " in scope " + this.scope));
            CreateResourceHandler createResourceHandler = new CreateResourceHandler(this.scope, this.registryClient, gCUBEResource);
            createResourceHandler.execute();
        }
    }

    public void remove(String string, String string2) throws Exception {
        if (this.useLocalEventsForResource(string2)) {
            GCUBELocalPublisher.getManager().notifyResourceRemoved(string, string2, this.scope);
        } else {
            logger.trace((Object)("Trying to unpublish resource with ID=" + string + " in scope " + this.scope));
            RemoveResourceHandler removeResourceHandler = new RemoveResourceHandler(this.scope, this.registryClient, string, string2);
            removeResourceHandler.execute();
        }
    }

    public void update(GCUBEResource gCUBEResource) throws Exception {
        if (this.useLocalEventsForResource(gCUBEResource.getType())) {
            GCUBELocalPublisher.getManager().notifyResourceRegistered(gCUBEResource, this.scope);
        } else {
            logger.trace((Object)("Trying to update resource with ID=" + gCUBEResource.getID() + " in scope " + this.scope));
            UpdateResourceHandler updateResourceHandler = new UpdateResourceHandler(this.scope, this.registryClient, gCUBEResource);
            updateResourceHandler.execute();
        }
    }

    private boolean useLocalEventsForResource(String string) throws ISRegistryLookup.NoRegistryAvailableException {
        Set<ISRegistryInstance> set;
        try {
            set = this.scope.getServiceMap().getEndpoints((Object)ServiceMap.ServiceType.ISRegistry);
            if (set != null && !set.isEmpty()) {
                logger.trace((Object)"Configured ISRegistry instances detected");
                for (EndpointReferenceType object : set) {
                    logger.trace((Object)("Checking local configuration for " + object.getAddress().toString()));
                    if (!object.getAddress().toString().contains(GHNContext.getContext().getPublishedHostnameAndPort())) continue;
                    logger.trace((Object)"Local ISRegistry instance detected");
                    return true;
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error while detecting local ISRegistry instances", (Throwable)exception);
            throw new ISRegistryLookup.NoRegistryAvailableException();
        }
        set = ISRegistryInstanceGroup.getInstanceGroup().getRegistryInstancesForTypeAndScope(string, this.scope);
        for (ISRegistryInstance iSRegistryInstance : set) {
            if (!iSRegistryInstance.getEndpoint().toString().contains(GHNContext.getContext().getPublishedHostnameAndPort())) continue;
            return true;
        }
        return false;
    }
}

