/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.resources;

import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.registrations.handlers.BaseISPublisherHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryClient;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryServiceUnpublisherHandler;

public class RemoveResourceHandler
extends BaseISPublisherHandler {
    protected static final GCUBELog logger = new GCUBELog(RemoveResourceHandler.class);
    private GCUBEScope scope;
    private ISRegistryClient registryClient;
    private String resourceID;
    private String type;

    public RemoveResourceHandler(GCUBEScope gCUBEScope, ISRegistryClient iSRegistryClient, String string, String string2) {
        this.scope = gCUBEScope;
        this.registryClient = iSRegistryClient;
        this.resourceID = string;
        this.type = string2;
    }

    @Override
    public String getResourceID() {
        return this.resourceID;
    }

    @Override
    protected void submitRequest() throws Exception {
        this.registryClient.setScope(this.scope);
        try {
            ISRegistryServiceUnpublisherHandler iSRegistryServiceUnpublisherHandler = new ISRegistryServiceUnpublisherHandler();
            iSRegistryServiceUnpublisherHandler.setResourceType(this.type);
            iSRegistryServiceUnpublisherHandler.setResourceID(this.resourceID);
            iSRegistryServiceUnpublisherHandler.setHandled((Object)this.registryClient);
            iSRegistryServiceUnpublisherHandler.run();
            logger.trace((Object)("Resource with ID=" + this.resourceID + " successfully unpublished"));
        }
        catch (GCUBEUnrecoverableException gCUBEUnrecoverableException) {
            logger.warn((Object)"Unregistration failed", (Throwable)gCUBEUnrecoverableException);
        }
    }
}

