/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.contexts;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.publisher.ISLocalPublisher;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.informationsystem.registry.impl.local.LocalProfileConsumerImpl;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.AvailablePurgers;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.GHNPurger;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.RIPurger;
import org.gcube.informationsystem.registry.impl.postprocessing.update.AvailableUpdaters;
import org.gcube.informationsystem.registry.impl.postprocessing.update.GHNUpdater;
import org.gcube.informationsystem.registry.impl.postprocessing.update.RIUpdater;

public class ServiceContext
extends GCUBEServiceContext {
    public static final String JNDI_NAME = "gcube/informationsystem/registry";
    protected static final ServiceContext cache = new ServiceContext();
    protected ISClient client = null;
    protected GCUBERIQuery queryRI = null;
    protected boolean isNotifierCodeployed = false;
    protected boolean isICCodeployed = false;
    protected GCUBEProducer<RegistryTopic, GCUBEResource> topicProducer;

    private ServiceContext() {
    }

    public static ServiceContext getContext() {
        return cache;
    }

    public String getJNDIName() {
        return JNDI_NAME;
    }

    public GCUBEProducer<RegistryTopic, GCUBEResource> getTopicProducer() {
        return this.topicProducer;
    }

    protected void onReady() throws Exception {
        if (GHNContext.getContext().getMode() == GHNContext.Mode.ROOT) {
            this.subscribeToLocalRegistrationEvents();
        }
        AvailablePurgers.register(new GHNPurger());
        AvailablePurgers.register(new RIPurger());
        AvailableUpdaters.register(new GHNUpdater());
        AvailableUpdaters.register(new RIUpdater());
    }

    protected void onInitialisation() throws Exception {
        this.client = (ISClient)GHNContext.getImplementation(ISClient.class);
        this.topicProducer = new GCUBEProducer();
    }

    private void subscribeToLocalRegistrationEvents() throws Exception {
        ISLocalPublisher pub = (ISLocalPublisher)GHNContext.getImplementation(ISLocalPublisher.class);
        this.logger.debug((Object)"Subscribing IS-Registry for local profiles' events");
        pub.subscribeLocalProfileEvents((ISLocalPublisher.LocalProfileConsumer)new LocalProfileConsumerImpl());
    }

    public void waitUntilReady() {
        while (ServiceContext.getContext().getStatus() != GCUBEServiceContext.Status.READIED) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    protected class NotificationResourceScheduler
    extends GCUBEScheduledHandler {
        public NotificationResourceScheduler(long interval, GCUBEScheduledHandler.Mode mode) {
            super(interval, mode, new GCUBEHandler[0]);
        }

        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception != null) {
                ServiceContext.this.logger.warn((Object)("Failed to create the notification resource (attempt " + exceptionCount + " out of 20)"), (Throwable)exception);
                if (exceptionCount >= 20) {
                    ServiceContext.this.logger.error((Object)"Max attempts reached, no more chance to register the notification resource");
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static enum RegistryTopic implements GCUBETopic
    {
        CREATE,
        UPDATE,
        REMOVE;

    }
}

