/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.porttypes;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.RemoteException;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.registry.impl.contexts.ServiceContext;
import org.gcube.informationsystem.registry.impl.porttypes.LocalResourceRegistration;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.FilterExecutor;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.FilterManager;
import org.gcube.informationsystem.registry.impl.state.Definitions;
import org.gcube.informationsystem.registry.stubs.resourceregistration.CreateFault;
import org.gcube.informationsystem.registry.stubs.resourceregistration.CreateMessage;
import org.gcube.informationsystem.registry.stubs.resourceregistration.CreateResponse;
import org.gcube.informationsystem.registry.stubs.resourceregistration.InvalidResourceFault;
import org.gcube.informationsystem.registry.stubs.resourceregistration.RemoveFault;
import org.gcube.informationsystem.registry.stubs.resourceregistration.RemoveMessage;
import org.gcube.informationsystem.registry.stubs.resourceregistration.RemoveResponse;
import org.gcube.informationsystem.registry.stubs.resourceregistration.ResourceNotAcceptedFault;
import org.gcube.informationsystem.registry.stubs.resourceregistration.UpdateFault;
import org.gcube.informationsystem.registry.stubs.resourceregistration.UpdateMessage;
import org.gcube.informationsystem.registry.stubs.resourceregistration.UpdateResponse;

public class ResourceRegistration
extends GCUBEPortType {
    protected final GCUBELog logger = new GCUBELog(ResourceRegistration.class);
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();

    public CreateResponse create(CreateMessage message) throws InvalidResourceFault, ResourceNotAcceptedFault, CreateFault {
        this.logger.info((Object)("CreateResource operation invoked in scope " + ServiceContext.getContext().getScope()));
        GCUBEResource resource = this.load(message.getType(), message.getProfile(), new String[0]);
        this.applyFilters(resource);
        try {
            new LocalResourceRegistration().create(resource);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to register the resource", (Throwable)e);
            throw new CreateFault();
        }
        return new CreateResponse();
    }

    public UpdateResponse update(UpdateMessage message) throws InvalidResourceFault, ResourceNotAcceptedFault, UpdateFault {
        this.logger.info((Object)("UpdateResource operation invoked in scope " + ServiceContext.getContext().getScope()));
        GCUBEResource resource = this.load(message.getType(), message.getXmlProfile(), message.getUniqueID());
        this.applyFilters(resource);
        try {
            new LocalResourceRegistration().update(resource);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to update the resource", (Throwable)e);
            throw new UpdateFault();
        }
        return new UpdateResponse();
    }

    public RemoveResponse remove(RemoveMessage message) throws RemoveFault, RemoteException {
        String ID = message.getUniqueID();
        String type = message.getType();
        this.logger.info((Object)("RemoveResource operation invoked on resource ID=" + ID + ", type=" + type));
        if (ID == null || ID.compareTo("") == 0) {
            this.logger.warn((Object)"Resource ID is missing, cannot manage the resource");
            throw new RemoteException("Resource ID is missing, cannot manage the resource");
        }
        try {
            new LocalResourceRegistration().remove(ID, type);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to remove the resource " + ID), (Throwable)e);
            throw new UpdateFault();
        }
        return new RemoveResponse();
    }

    private GCUBEResource load(String type, String profile, String ... id) throws InvalidResourceFault, ResourceNotAcceptedFault {
        if (profile == null || profile.compareTo("") == 0) {
            this.logger.error((Object)"The input resource is null");
            throw new InvalidResourceFault();
        }
        try {
            GCUBEResource resource = Definitions.ResourceMappings.valueOf(type).getResourceImplementation();
            resource.load((Reader)new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(profile.getBytes("UTF-8")), "UTF-8")));
            if (resource.getID() == null || resource.getID().compareTo("") == 0) {
                String newid;
                String string = newid = id != null && id.length > 0 ? id[0] : uuidgen.nextUUID();
                if (!resource.setID(newid)) {
                    this.logger.error((Object)"Unable to set a new ID to the resource");
                    throw new ResourceNotAcceptedFault();
                }
            }
            return resource;
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error trying to load  profile", (Throwable)ex);
            throw new InvalidResourceFault();
        }
    }

    private void applyFilters(GCUBEResource resource) throws ResourceNotAcceptedFault {
        try {
            if (!FilterManager.getExecutor(resource.getType()).accept(resource)) {
                this.logger.warn((Object)("Resource " + resource.getID() + " NOT accepted "));
                throw new ResourceNotAcceptedFault();
            }
            this.logger.trace((Object)("Resource " + resource.getID() + " accepted "));
        }
        catch (FilterExecutor.InvalidFilterException e) {
            this.logger.warn((Object)("Invalid filter selected, the resource " + resource.getID() + " CANNOT be filtered "));
        }
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }
}

