/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.postprocessing.update;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.AvailablePurgers;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.Purger;
import org.gcube.informationsystem.registry.impl.postprocessing.update.Updater;

public class RIUpdater
implements Updater<GCUBERunningInstance> {
    protected final GCUBELog logger = new GCUBELog(RIUpdater.class);

    @Override
    public void update(GCUBEResource resource, GCUBEScope scope) {
        if (!(resource instanceof GCUBERunningInstance)) {
            return;
        }
        GCUBERunningInstance ri = (GCUBERunningInstance)resource;
        this.logger.trace((Object)("The Running Instance is currently in state " + ri.getDeploymentData().getState()));
        if (ri.getDeploymentData().getState().equals(GCUBEServiceContext.Status.DOWN.toString()) || ri.getDeploymentData().getState().equals(GCUBEServiceContext.Status.FAILED.toString())) {
            this.logger.trace((Object)"Looking for purger for RunningInstance");
            Purger<?> purger = AvailablePurgers.getPurger("RunningInstance");
            if (purger != null) {
                try {
                    this.logger.debug((Object)"Applying purger for RunningInstance");
                    purger.purge(ri.getID(), scope);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error while removing the profiles related to the resource", (Throwable)e);
                }
            } else {
                this.logger.trace((Object)"No purger found");
            }
        }
    }

    @Override
    public String getName() {
        return "RunningInstance";
    }
}

