/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.preprocessing.filters;

import java.util.List;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.Filter;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.FilterExecutor;

public class GHNFilterExecutor
extends FilterExecutor {
    private List<Filter> filters = null;
    private GCUBEHostingNode node = null;

    protected GHNFilterExecutor(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public boolean accept(GCUBEResource resource) throws FilterExecutor.InvalidFilterException {
        if (resource.getType().compareTo("GHN") != 0) {
            throw new FilterExecutor.InvalidFilterException("Cannot apply " + this.getClass().getName() + " filter to " + resource.getType());
        }
        this.node = (GCUBEHostingNode)resource;
        this.logger.trace((Object)("Applying N." + this.filters.size() + " filters to GHN"));
        for (Filter filter : this.filters) {
            if (this._accept(filter)) continue;
            return false;
        }
        return true;
    }

    private boolean _accept(Filter filter) {
        if (filter.getTarget().compareToIgnoreCase("Site/Domain") == 0 && (filter.getOperation() == Filter.FILTEROPERATION.exclude || filter.getOperation() == Filter.FILTEROPERATION.exclude_if_contains)) {
            return !this.isExcludedDomain(filter.getValue());
        }
        if (filter.getTarget().compareToIgnoreCase("GHNDescription/Name") == 0 && (filter.getOperation() == Filter.FILTEROPERATION.exclude || filter.getOperation() == Filter.FILTEROPERATION.exclude_if_contains)) {
            return !this.isExcludedHost(filter.getValue());
        }
        this.logger.warn((Object)("Target " + filter.getTarget() + " or Operation " + filter.getOperation().name() + " not supported by the GHNFilter"));
        return true;
    }

    private boolean isExcludedHost(String host) {
        this.logger.trace((Object)("Checking host " + this.node.getNodeDescription().getName()));
        if (this.node.getNodeDescription().getName().split(":")[0].compareToIgnoreCase(host) == 0) {
            this.logger.warn((Object)("Detected banned hostname " + host + " for GHN " + this.node.getID()));
            return true;
        }
        return false;
    }

    private boolean isExcludedDomain(String domain) {
        this.logger.trace((Object)("Checking domain " + this.node.getSite().getDomain()));
        if (this.node.getSite().getDomain().compareToIgnoreCase(domain) == 0) {
            this.logger.warn((Object)("Detected banned domain " + domain + " for GHN " + this.node.getID()));
            return true;
        }
        return false;
    }
}

