/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.cache.ISRetriever;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.informationsystem.cache.consistency.manager.ConsistencyManagerIF;

public class Srv
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -2699724529778231761L;
    private String srvClass;
    private String srvName;
    private String portTypeName = null;
    private ConsistencyManagerIF myManager = null;
    private GCUBEScope scope = null;
    private HashMap<String, Set<EndpointReference>> eprs;
    private HashMap<String, HashMap<String, String>> filterCriteria = new HashMap();
    private static GCUBELog log = new GCUBELog(Srv.class);

    public Srv(String srvClass, String srvName) {
        this.setSrvClass(srvClass);
        this.setSrvName(srvName);
        this.setEprs(new HashMap<String, Set<EndpointReference>>());
    }

    public Srv(String srvClass, String srvName, String portTypeName) {
        this.setSrvClass(srvClass);
        this.setSrvName(srvName);
        this.setPortTypeName(portTypeName);
        this.setEprs(new HashMap<String, Set<EndpointReference>>());
    }

    public Srv(String srvClass, String srvName, HashMap<String, Set<EndpointReference>> h) {
        this.setSrvClass(srvClass);
        this.setSrvName(srvName);
        this.setEprs(h);
    }

    public Srv(String srvClass, String srvName, String portTypeName, HashMap<String, Set<EndpointReference>> h) {
        this.setSrvClass(srvClass);
        this.setSrvName(srvName);
        this.setPortTypeName(portTypeName);
        this.setEprs(h);
    }

    public boolean equals(Object o) {
        if (o instanceof Srv) {
            if (((Srv)o).getSrvName().compareTo(this.getSrvName()) != 0) {
                return false;
            }
            if (((Srv)o).getSrvClass().compareTo(this.getSrvClass()) != 0) {
                return false;
            }
            if (((Srv)o).getPortTypeName() == null && this.getPortTypeName() != null) {
                return false;
            }
            if (((Srv)o).getPortTypeName() != null && this.getPortTypeName() == null) {
                return false;
            }
            if (((Srv)o).getPortTypeName() == null && this.getPortTypeName() == null) {
                return true;
            }
            return ((Srv)o).getPortTypeName().compareTo(this.getPortTypeName()) == 0;
        }
        return false;
    }

    public void setSrv(String srvClass, String srvName) {
        this.setSrvClass(srvClass);
        this.setSrvName(srvName);
    }

    public void setSrv(String srvClass, String srvName, String portTypeName) {
        this.setSrvClass(srvClass);
        this.setSrvName(srvName);
        this.setPortTypeName(portTypeName);
    }

    public Object clone() throws CloneNotSupportedException {
        Srv cloned = (Srv)super.clone();
        cloned.myManager = this.myManager;
        return cloned;
    }

    public String toString() {
        return "ServiceClass: " + this.getSrvClass() + "\tServiceName: " + this.getSrvName() + "\tPortTypeName: " + this.getPortTypeName() + ".";
    }

    public Set<EndpointReference> goForSimple() throws ISClient.ISUnsupportedQueryException, InstantiationException, IllegalAccessException, Exception {
        log.debug((Object)("SimpleRefresh for " + this.toString()));
        HashSet<EndpointReference> ret = new HashSet<EndpointReference>();
        LinkedList<AtomicCondition> riACs = new LinkedList<AtomicCondition>();
        riACs.add(new AtomicCondition("//ServiceClass", this.getSrvClass()));
        riACs.add(new AtomicCondition("//ServiceName", this.getSrvName()));
        if (this.getFilterCriteria().get(SrvType.SIMPLE.toString()) != null) {
            for (String string : this.getFilterCriteria().get(SrvType.SIMPLE.toString()).keySet()) {
                String val = this.getFilterCriteria().get(SrvType.SIMPLE.toString()).get(string);
                log.debug((Object)("Adding " + string + ":" + val));
                riACs.add(new AtomicCondition(string, val));
            }
        }
        GCUBERIQuery query = ISRetriever.getRIQuery();
        for (AtomicCondition ac : riACs) {
            query.addAtomicConditions(new AtomicCondition[]{ac});
        }
        log.info((Object)("GetEPRs query: " + query.getExpression()));
        List list = ISRetriever.getISClient().execute((ISQuery)query, this.getScope());
        log.info((Object)("Number of results: " + list.size()));
        for (GCUBERunningInstance rpd : list) {
            if (this.portTypeName != null) {
                EndpointReferenceType epr = rpd.getAccessPoint().getEndpoint(this.portTypeName);
                if (epr == null) continue;
                log.debug((Object)("Simple - adding epr for specific portType: " + epr.getAddress().toString()));
                ret.add(new EndpointReference(new Address(epr.getAddress().toString())));
                continue;
            }
            List lis = rpd.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
            for (Endpoint e : lis) {
                log.debug((Object)("Simple - adding epr: " + e.getValue()));
                EndpointReference epr = new EndpointReference(new Address(e.getValue()));
                ret.add(epr);
            }
        }
        return ret;
    }

    private Set<EndpointReference> goForSimple(String scope) throws ISClient.ISUnsupportedQueryException, InstantiationException, IllegalAccessException, Exception {
        String serviceClass = this.getSrvClass();
        String serviceName = this.getSrvName();
        HashSet<EndpointReference> ret = new HashSet<EndpointReference>();
        String queryStr = "declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry';declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider';for $result in collection(\"/db/Profiles/RunningInstance\")//Document/Data/is:Profile/Resource where ($result/Profile/DeploymentData/Status/string() eq \"ready\") and ($result//ServiceClass/string() eq \"" + serviceClass + "\") and ($result//ServiceName/string() eq \"" + serviceName + "\") and ($result//Scope = \"" + scope + "\") ";
        if (this.getFilterCriteria().get(SrvType.SIMPLE.toString()) != null) {
            for (String var : this.getFilterCriteria().get(SrvType.SIMPLE.toString()).keySet()) {
                String val = this.getFilterCriteria().get(SrvType.SIMPLE.toString()).get(var);
                queryStr = queryStr + " ($result//" + var + "/string() eq \"" + val + "\")";
            }
        }
        queryStr = queryStr + " return $result";
        GCUBERIQuery query = ISRetriever.getRIQuery();
        query.setExpression(queryStr);
        log.info((Object)("GetEPRss query: " + query.getExpression()));
        List rp = ISRetriever.getISClient().execute((ISQuery)query, this.getScope());
        log.info((Object)("Number of results: " + rp.size()));
        for (GCUBERunningInstance rpd : rp) {
            if (this.portTypeName != null) {
                EndpointReferenceType epr = rpd.getAccessPoint().getEndpoint(this.portTypeName);
                if (epr == null) continue;
                log.debug((Object)("Simple(private) - adding epr for specific portType: " + epr.getAddress().toString()));
                ret.add(new EndpointReference(new Address(epr.getAddress().toString())));
                continue;
            }
            List lis = rpd.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
            for (Endpoint e : lis) {
                log.debug((Object)("Simple(private) - adding epr: " + e.getValue()));
                EndpointReference epr = new EndpointReference(new Address(e.getValue()));
                ret.add(epr);
            }
        }
        return ret;
    }

    public Set<EndpointReference> goForFactory() throws ISClient.ISUnsupportedQueryException, InstantiationException, IllegalAccessException, Exception {
        log.debug((Object)("FactoryRefresh for " + this.toString()));
        HashSet<EndpointReference> ret = new HashSet<EndpointReference>();
        LinkedList<AtomicCondition> riACs = new LinkedList<AtomicCondition>();
        riACs.add(new AtomicCondition("//ServiceClass", this.getSrvClass()));
        riACs.add(new AtomicCondition("//ServiceName", this.getSrvName()));
        if (this.getFilterCriteria().get(SrvType.FACTORY.toString()) != null) {
            for (String string : this.getFilterCriteria().get(SrvType.FACTORY.toString()).keySet()) {
                String val = this.getFilterCriteria().get(SrvType.FACTORY.toString()).get(string);
                log.debug((Object)("Adding " + string + ":" + val));
                riACs.add(new AtomicCondition(string, val));
            }
        }
        GCUBERIQuery query = ISRetriever.getRIQuery();
        for (AtomicCondition ac : riACs) {
            query.addAtomicConditions(new AtomicCondition[]{ac});
        }
        log.info((Object)("GetEPRs query: " + query.getExpression()));
        List list = ISRetriever.getISClient().execute((ISQuery)query, this.getScope());
        log.info((Object)("Number of results: " + list.size()));
        for (GCUBERunningInstance rpd : list) {
            if (this.portTypeName != null) {
                EndpointReferenceType epr = rpd.getAccessPoint().getEndpoint(this.portTypeName);
                if (epr == null) continue;
                log.debug((Object)("Factory - adding epr for specific portType: " + epr.getAddress().toString()));
                ret.add(new EndpointReference(new Address(epr.getAddress().toString())));
                continue;
            }
            List lis = rpd.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
            for (Endpoint endpoint : lis) {
                if (endpoint.getEntryName().indexOf("Factory") == -1) continue;
                log.debug((Object)("Factory - adding epr: " + endpoint.getValue()));
                EndpointReference epr = new EndpointReference(new Address(endpoint.getValue()));
                ret.add(epr);
            }
        }
        return ret;
    }

    private Set<EndpointReference> goForFactory(String scope) throws ISClient.ISUnsupportedQueryException, InstantiationException, IllegalAccessException, Exception {
        log.debug((Object)("FactoryRefresh for " + this.toString()));
        String serviceClass = this.getSrvClass();
        String serviceName = this.getSrvName();
        HashSet<EndpointReference> ret = new HashSet<EndpointReference>();
        String queryStr = "declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry';declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider';for $result in collection(\"/db/Profiles/RunningInstance\")//Document/Data/is:Profile/Resource where ($result/Profile/DeploymentData/Status/string() eq \"ready\") and ($result//ServiceClass/string() eq \"" + serviceClass + "\") and ($result//ServiceName/string() eq \"" + serviceName + "\") and ($result//Scope = \"" + scope + "\") ";
        if (this.getFilterCriteria().get(SrvType.FACTORY.toString()) != null) {
            for (String var : this.getFilterCriteria().get(SrvType.FACTORY.toString()).keySet()) {
                String val = this.getFilterCriteria().get(SrvType.FACTORY.toString()).get(var);
                queryStr = queryStr + " ($result//" + var + "/string() eq \"" + val + "\")";
            }
        }
        queryStr = queryStr + " return $result";
        GCUBERIQuery query = ISRetriever.getRIQuery();
        query.setExpression(queryStr);
        log.info((Object)("GetEPRss query: " + query.getExpression()));
        List rp = ISRetriever.getISClient().execute((ISQuery)query, this.getScope());
        log.info((Object)("Number of results: " + rp.size()));
        for (GCUBERunningInstance rpd : rp) {
            if (this.portTypeName != null) {
                EndpointReferenceType epr = rpd.getAccessPoint().getEndpoint(this.portTypeName);
                if (epr == null) continue;
                log.debug((Object)("Factory(private) - adding epr for specific portType: " + epr.getAddress().toString()));
                ret.add(new EndpointReference(new Address(epr.getAddress().toString())));
                continue;
            }
            List lis = rpd.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
            for (Endpoint endpoint : lis) {
                if (endpoint.getEntryName().indexOf("Factory") == -1) continue;
                log.debug((Object)("Factory(private) - adding epr: " + endpoint.getValue()));
                EndpointReference epr = new EndpointReference(new Address(endpoint.getValue()));
                ret.add(epr);
            }
        }
        return ret;
    }

    public Set<EndpointReference> goForStateful() throws ISClient.ISUnsupportedQueryException, InstantiationException, IllegalAccessException, Exception {
        log.debug((Object)"**************************************************");
        log.debug((Object)("StatefulRefresh for " + this.toString()));
        HashSet<EndpointReference> ret = new HashSet<EndpointReference>();
        if (this.portTypeName != null) {
            log.debug((Object)"Statefull - return an empty set, since a specific portType of the RI that created a WS resource is not published");
            return ret;
        }
        LinkedList<AtomicCondition> wsPropDocACs = new LinkedList<AtomicCondition>();
        wsPropDocACs.add(new AtomicCondition("//gc:ServiceClass", this.getSrvClass()));
        wsPropDocACs.add(new AtomicCondition("//gc:ServiceName", this.getSrvName()));
        if (this.getFilterCriteria().get(SrvType.STATEFULL.toString()) != null) {
            for (String string : this.getFilterCriteria().get(SrvType.STATEFULL.toString()).keySet()) {
                String val = this.getFilterCriteria().get(SrvType.STATEFULL.toString()).get(string);
                log.debug((Object)("Adding " + string + ":" + val));
                wsPropDocACs.add(new AtomicCondition(string, val));
            }
        }
        WSResourceQuery query = ISRetriever.getWSResourceQuery();
        for (AtomicCondition ac : wsPropDocACs) {
            query.addAtomicConditions(new AtomicCondition[]{ac});
        }
        log.info((Object)("EPR query: " + query.getExpression()));
        List list = ISRetriever.getISClient().execute((ISQuery)query, this.getScope());
        log.debug((Object)("Number of results " + list.size()));
        for (RPDocument rpd : list) {
            ret.add(new EndpointReference(rpd.getEndpoint()));
        }
        log.debug((Object)"**************************************************");
        return ret;
    }

    private Set<EndpointReference> goForStateful(String scope) throws ISClient.ISUnsupportedQueryException, InstantiationException, IllegalAccessException, Exception {
        HashSet<EndpointReference> ret = new HashSet<EndpointReference>();
        if (this.portTypeName != null) {
            log.debug((Object)"Statefull(private) - return an empty set, since a specific portType of the RI that created a WS resource is not published");
            return ret;
        }
        LinkedList<AtomicCondition> wsPropDocACs = new LinkedList<AtomicCondition>();
        wsPropDocACs.add(new AtomicCondition("//gc:ServiceClass", this.getSrvClass()));
        wsPropDocACs.add(new AtomicCondition("//gc:ServiceName", this.getSrvName()));
        wsPropDocACs.add(new AtomicCondition("//gc:Scope", scope));
        if (this.getFilterCriteria().get(SrvType.STATEFULL.toString()) != null) {
            for (String string : this.getFilterCriteria().get(SrvType.STATEFULL.toString()).keySet()) {
                String val = this.getFilterCriteria().get(SrvType.STATEFULL.toString()).get(string);
                log.debug((Object)("Adding " + string + ":" + val));
                wsPropDocACs.add(new AtomicCondition(string, val));
            }
        }
        WSResourceQuery query = ISRetriever.getWSResourceQuery();
        for (AtomicCondition ac : wsPropDocACs) {
            query.addAtomicConditions(new AtomicCondition[]{ac});
        }
        log.info((Object)("EPR query: " + query.getExpression()));
        List list = ISRetriever.getISClient().execute((ISQuery)query, this.getScope());
        log.debug((Object)("Number of results " + list.size()));
        for (RPDocument rpd : list) {
            ret.add(new EndpointReference(rpd.getEndpoint()));
        }
        return ret;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void forceRefreshService() throws Exception {
        this.getEprs().put(SrvType.FACTORY.toString(), this.goForFactory());
        this.getEprs().put(SrvType.SIMPLE.toString(), this.goForSimple());
        this.getEprs().put(SrvType.STATEFULL.toString(), this.goForStateful());
    }

    public static void main(String[] args) {
        Srv srv1 = null;
        srv1 = new Srv("1", "2");
        Srv srv2 = null;
        srv2 = new Srv("1", "2");
        System.out.println(srv1.equals(srv2));
        System.out.println(srv1.equals(srv1));
        System.out.println(srv2.equals(srv2));
        if (args.length != 0) {
            Srv.printUsageAndExit();
        }
    }

    private static void printUsageAndExit() {
        System.err.println("Wrong number of arguments.\nUsage: java\nAborting...\n");
        System.exit(1);
    }

    public String getSrvClass() {
        return this.srvClass;
    }

    public String getSrvName() {
        return this.srvName;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setSrvClass(String srvClass) {
        this.srvClass = srvClass;
    }

    public void setSrvName(String srvName) {
        this.srvName = srvName;
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    public void setEprs(HashMap<String, Set<EndpointReference>> eprs) {
        this.eprs = eprs;
    }

    public HashMap<String, Set<EndpointReference>> getEprs() {
        return this.eprs;
    }

    public Set<EndpointReference> getEPRs() throws Exception {
        return this.getMyManager().getEPRs(this);
    }

    public Set<EndpointReference> getEPRs(String serviceType) throws Exception {
        return this.getMyManager().getEPRs(this, serviceType);
    }

    public void setFilterCriteria(HashMap<String, HashMap<String, String>> filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public HashMap<String, HashMap<String, String>> getFilterCriteria() {
        return this.filterCriteria;
    }

    protected void setMyManager(ConsistencyManagerIF myManager) {
        this.myManager = myManager;
    }

    protected ConsistencyManagerIF getMyManager() {
        return this.myManager;
    }

    public static boolean isServiceTypeValid(String srvType) {
        return srvType.equals(SrvType.SIMPLE.toString()) || srvType.equals(SrvType.FACTORY.toString()) || srvType.equals(SrvType.STATEFULL.toString());
    }

    protected void setScope(GCUBEScope scope) {
        this.scope = scope;
    }

    protected GCUBEScope getScope() {
        return this.scope;
    }
}

