/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.cache.consistency.manager.poll;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReference;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.cache.Srv;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.informationsystem.cache.consistency.manager.poll.PollManager;

public class CacheRefreshUtil {
    private static GCUBELog log = new GCUBELog(CacheRefreshUtil.class);

    private static Set<EndpointReference> getEPRsFor(Srv service) throws Exception {
        if (service.getEprs() != null && service.getEprs().size() != 0) {
            Iterator<String> it = service.getEprs().keySet().iterator();
            HashSet<EndpointReference> eprSet = new HashSet<EndpointReference>();
            while (it.hasNext()) {
                eprSet.addAll((Collection<EndpointReference>)service.getEprs().get(it.next()));
            }
            return eprSet;
        }
        return null;
    }

    public static Set<EndpointReference> getEPRs(Srv service) throws Exception {
        log.debug((Object)("Retrieving eprs for service {" + service.toString() + "}"));
        if (service.getEprs().size() != 0) {
            log.debug((Object)"It seems that this service has been examined before. Returning already registered eprs");
            return CacheRefreshUtil.getEPRsFor(service);
        }
        log.debug((Object)("This is the first time that service {" + service.toString() + "} is examined."));
        PollManager.refreshService(service);
        log.debug((Object)"Refresh complete.");
        if (service.getEprs().size() != 0) {
            Set<EndpointReference> s = CacheRefreshUtil.getEPRsFor(service);
            log.debug((Object)("Number of EPRs: " + s.size()));
            return s;
        }
        log.error((Object)"After service refresh I still cannot find any ");
        throw new Exception("This should not have happened");
    }

    public static Set<EndpointReference> getEPRs(Srv service, String serviceType) throws Exception {
        if (!(serviceType.equals(SrvType.FACTORY.toString()) || serviceType.equals(SrvType.SIMPLE.toString()) || serviceType.equals(SrvType.STATEFULL.toString()))) {
            throw new Exception("Given service type is not valid.");
        }
        if (service.getEprs().size() != 0 && service.getEprs().get(serviceType) != null) {
            return service.getEprs().get(serviceType);
        }
        PollManager.refreshService(service);
        if (service.getEprs().size() != 0 && service.getEprs().get(serviceType) != null) {
            return service.getEprs().get(serviceType);
        }
        throw new Exception("This should not have happened");
    }

    protected static void refreshService(Srv service) throws Exception {
        service.forceRefreshService();
    }
}

