/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.notifier.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.notifier.impl.entities.Consumer;
import org.gcube.informationsystem.notifier.impl.entities.Producer;
import org.gcube.informationsystem.notifier.util.EPR;
import org.gcube.informationsystem.notifier.util.RegistrationEventHandler;
import org.gcube.informationsystem.notifier.util.Subscription;
import org.globus.wsrf.NoSuchResourceException;

public class RegistrationEventHandlerImpl
implements RegistrationEventHandler<Producer, Consumer>,
Serializable {
    private static final long serialVersionUID = -5127492772936157364L;
    public static GCUBELog logger = new GCUBELog(RegistrationEventHandlerImpl.class);
    private List<Subscription> subscriptionList = Collections.synchronizedList(new ArrayList());
    private QName topic;

    public RegistrationEventHandlerImpl(QName topic) {
        this.topic = topic;
    }

    public void setSubscriptionList(List<Subscription> subscriptionList) {
        this.subscriptionList = subscriptionList;
    }

    public List<Subscription> getSubscriptionList() {
        return this.subscriptionList;
    }

    public QName getTopic() {
        return this.topic;
    }

    public void setTopic(QName topic) {
        this.topic = topic;
    }

    @Override
    public synchronized void onNewConsumer(Consumer consumer, List<Producer> registeredProducerList) throws Exception {
        logger.trace((Object)("onNewConsumer method with " + registeredProducerList.size() + " producers"));
        for (EPR ePR : registeredProducerList) {
            try {
                logger.debug((Object)("creating subscription for consumer " + consumer.getEpr() + " to prducer " + ePR.getEpr()));
                Subscription subscription = new Subscription(consumer, ePR);
                subscription.subscribe(this.topic);
                logger.debug((Object)("creating subscription, is consumer null? " + (subscription.getConsumer() == null)));
                this.subscriptionList.add(subscription);
            }
            catch (Exception e) {
                logger.error((Object)("error registering consumer " + consumer.getEpr() + " to the producer"));
            }
        }
    }

    @Override
    public synchronized void onNewProducer(Producer newProducer, List<Consumer> registeredConsumerList) throws Exception {
        logger.trace((Object)("onNewProducer method with " + registeredConsumerList.size() + " consumers"));
        for (Consumer consumer : registeredConsumerList) {
            try {
                logger.debug((Object)("creating subscription for consumer " + consumer.getEpr() + " to prducer " + newProducer.getEpr()));
                Subscription subscription = new Subscription(consumer, newProducer);
                logger.debug((Object)"subscription created");
                subscription.subscribe(this.topic);
                logger.debug((Object)"adding it to the subscription list");
                this.subscriptionList.add(subscription);
            }
            catch (Exception e) {
                logger.error((Object)("error registering producer " + newProducer.getEpr() + " with the consumer"), (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void onProducerExist(Producer newProducer, Producer oldProducer, List<Consumer> registeredConsumerList) throws Exception {
        logger.trace((Object)"onProducerExist method");
        this.onRemoveProducer(oldProducer);
        this.onNewProducer(newProducer, registeredConsumerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onRemoveConsumer(Consumer consumer) throws Exception {
        logger.trace((Object)"onRemoveConsumer method");
        ArrayList<Subscription> subscriptionToRemove = new ArrayList<Subscription>();
        List<Subscription> list = this.subscriptionList;
        synchronized (list) {
            for (Subscription subscription : this.subscriptionList) {
                if (subscription.getConsumer() == null) {
                    subscriptionToRemove.add(subscription);
                    logger.trace((Object)"a subscription has a null consumer, will be removed");
                    continue;
                }
                if (!((Consumer)subscription.getConsumer()).equals(consumer)) continue;
                logger.trace((Object)("stopping subscription from " + ((EPR)subscription.getProducer()).getEpr() + " to " + ((Consumer)subscription.getConsumer()).getEpr()));
                try {
                    subscription.removeSubscription();
                }
                catch (NoSuchResourceException re) {
                    logger.error((Object)("resource not found  for subscription: " + consumer.getEpr()));
                }
                catch (Exception e) {
                    logger.error((Object)("failed stopping subscription from consumer " + consumer.getEpr()), (Throwable)e);
                }
                finally {
                    subscriptionToRemove.add(subscription);
                }
            }
            this.subscriptionList.removeAll(subscriptionToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onRemoveProducer(Producer producer) throws Exception {
        logger.trace((Object)"onRemoveProducer method");
        ArrayList<Subscription> subscriptionToRemove = new ArrayList<Subscription>();
        List<Subscription> list = this.subscriptionList;
        synchronized (list) {
            for (Subscription subscription : this.subscriptionList) {
                if (subscription.getProducer() != null && ((EPR)subscription.getProducer()).equals(producer)) {
                    logger.trace((Object)("stopping subscription from " + producer.getEpr() + " to " + ((Consumer)subscription.getConsumer()).getEpr()));
                    try {
                        subscription.removeSubscription();
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("failed stopping subscription from producer " + producer.getEpr()), (Throwable)e);
                        continue;
                    }
                    finally {
                        subscriptionToRemove.add(subscription);
                        logger.trace((Object)"removing the subscription");
                        continue;
                    }
                }
                logger.warn((Object)("the producer " + producer.getEpr() + " seems not exist "));
            }
            this.subscriptionList.removeAll(subscriptionToRemove);
        }
    }

    @Override
    public List<EndpointReferenceType> getSubscriptionEPRByProducer(Producer producer) {
        ArrayList<EndpointReferenceType> eprSubscriptions = new ArrayList<EndpointReferenceType>();
        for (Subscription subscription : this.subscriptionList) {
            if (!subscription.isSubscribed() || !((EPR)subscription.getProducer()).equals(producer)) continue;
            eprSubscriptions.add(subscription.getNotificationResourceEnpoint().getEpr());
        }
        return eprSubscriptions;
    }

    @Override
    public List<EndpointReferenceType> getSubscriptionEPRByConsumer(Consumer consumer) {
        ArrayList<EndpointReferenceType> eprSubscriptions = new ArrayList<EndpointReferenceType>();
        for (Subscription subscription : this.subscriptionList) {
            if (!subscription.isSubscribed() || !((Consumer)subscription.getConsumer()).equals(consumer)) continue;
            eprSubscriptions.add(subscription.getNotificationResourceEnpoint().getEpr());
        }
        return eprSubscriptions;
    }
}

