/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.event;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import org.gcube.keycloak.event.OrchestratorEventPublisherProvider;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;

public class KeycloakEvent
extends org.gcube.event.publisher.Event {
    private static final long serialVersionUID = 4072256389444123291L;
    public static final String TYPE = "keycloak";
    public static final String REALM = "realm";
    public static final String USER = "user";
    public static final String CLIENT = "client";
    public static final String RESOURCE = "resource";
    public static final String RESOURCE_TYPE = "resource-type";
    public static final String OPERATION = "operation";
    public static final String ADMIN_NAME = "ADMIN";

    public KeycloakEvent(String name, String sender, String realm) {
        this(name, sender, realm, null);
    }

    public KeycloakEvent(String name, String sender, String realm, Map<String, String> data) {
        super(name, TYPE, sender, data);
        this.setRealm(realm);
    }

    public static KeycloakEvent newKeycloakEvent(Event event) {
        KeycloakEvent keycloakEvent = new KeycloakEvent(event.getType().name(), event.getIpAddress(), event.getRealmId(), event.getDetails());
        keycloakEvent.setTimestamp(KeycloakEvent.convertEventDate(event.getTime()));
        keycloakEvent.setClient(event.getClientId());
        keycloakEvent.setUser(event.getUserId());
        return keycloakEvent;
    }

    public static KeycloakEvent newKeycloakAdminEvent(AdminEvent adminEvent) {
        KeycloakEvent keycloakEvent = new KeycloakEvent(ADMIN_NAME, adminEvent.getResourcePath(), adminEvent.getRealmId());
        keycloakEvent.setTimestamp(KeycloakEvent.convertEventDate(adminEvent.getTime()));
        keycloakEvent.setResource(adminEvent.getResourcePath());
        keycloakEvent.setResourceType(adminEvent.getResourceTypeAsString());
        keycloakEvent.setOperation(adminEvent.getOperationType().name());
        return keycloakEvent;
    }

    private static OffsetDateTime convertEventDate(long millis) {
        OrchestratorEventPublisherProvider.logger.infof("Creating offset date time from millis: %l", (Object)millis);
        return Instant.ofEpochMilli(millis).atZone(ZoneOffset.systemDefault()).toOffsetDateTime();
    }

    public void setRealm(String realm) {
        this.set(REALM, realm);
    }

    public String getRealm() {
        return (String)this.get(REALM);
    }

    public void setUser(String user) {
        this.set(USER, user);
    }

    public String getUser() {
        return (String)this.get(USER);
    }

    public void setClient(String client) {
        this.set(CLIENT, client);
    }

    public String getClient() {
        return (String)this.get(CLIENT);
    }

    public void setResource(String resource) {
        this.set(RESOURCE, resource);
    }

    public String getResource() {
        return (String)this.get(RESOURCE);
    }

    public void setResourceType(String resourceType) {
        this.set(RESOURCE_TYPE, resourceType);
    }

    public String getResourceType() {
        return (String)this.get(RESOURCE_TYPE);
    }

    public void setOperation(String operation) {
        this.set(OPERATION, operation);
    }

    public String getOperation() {
        return (String)this.get(OPERATION);
    }
}

