/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.event;

import java.net.MalformedURLException;
import java.net.URL;
import org.gcube.keycloak.event.OrchestratorEventPublisherProvider;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class OrchestratorEventPublisherProviderFactory
implements EventListenerProviderFactory {
    public static final String REALM_NAME = "d4science";
    public static final String ORCHESTRATOR_CLIENT_ID = "orchestrator";
    private static final Logger logger = Logger.getLogger(OrchestratorEventPublisherProviderFactory.class);
    public static URL endpoint;
    protected OrchestratorEventPublisherProvider oepp;

    public OrchestratorEventPublisherProviderFactory() {
        logger.info((Object)"New OrchestratorEventPublisherProviderFactory has been created");
    }

    public void close() {
    }

    public EventListenerProvider create(KeycloakSession keycloakSession) {
        logger.debugf("Getting configured endpoint address for client '%s' in realm '%s'", (Object)ORCHESTRATOR_CLIENT_ID, (Object)REALM_NAME);
        String address = keycloakSession.realms().getRealmByName(REALM_NAME).getClientByClientId(ORCHESTRATOR_CLIENT_ID).getBaseUrl();
        try {
            URL newEndpoint = new URL(address);
            if (this.oepp == null || !newEndpoint.equals(endpoint)) {
                logger.infof("Creating new orchestrator event publisher provider for endpoint: %s", (Object)address);
                endpoint = newEndpoint;
                this.oepp = new OrchestratorEventPublisherProvider();
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Can't create new orchestrator event publisher provider with endpoint address: " + address), (Throwable)e);
            this.oepp = null;
        }
        return this.oepp;
    }

    public String getId() {
        return "orchestrator-event-publisher";
    }

    public void init(Config.Scope scope) {
    }

    public void postInit(KeycloakSessionFactory keycloakSessionFactory) {
    }
}

