/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.persistence;

import java.io.Serializable;
import org.gcube.common.accounting.node.persistence.StatisticsData;
import org.gcube.common.accounting.node.persistence.TopCallerData;

public class RIAccountingData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private String serviceClass;
    private StatisticsData avgInvocationTime = null;
    private StatisticsData avgCallsNumber = null;
    private long totalCalls = 0L;
    private TopCallerData topCallerData = null;
    private long interval = 0L;

    public RIAccountingData(Long l) {
        this.interval = l;
    }

    public StatisticsData getAvgInvocationTime() {
        if (this.avgInvocationTime == null) {
            this.avgInvocationTime = new StatisticsData(statisticsType.InvocationTime, this.interval);
        }
        return this.avgInvocationTime;
    }

    public StatisticsData getAvgCallsNumber() {
        if (this.avgCallsNumber == null) {
            this.avgCallsNumber = new StatisticsData(statisticsType.IncomingCalls, this.interval);
        }
        return this.avgCallsNumber;
    }

    public void addCalls(long l) {
        this.totalCalls += l;
    }

    public long getTotalCalls() {
        return this.totalCalls;
    }

    public TopCallerData getTopCallerData() {
        if (this.topCallerData == null) {
            this.topCallerData = new TopCallerData(this.interval);
        }
        return this.topCallerData;
    }

    public int hashcode() {
        return (this.serviceClass + this.serviceName).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RIAccountingData rIAccountingData = (RIAccountingData)object;
        if (this.serviceName == null ? rIAccountingData.serviceName != null : !this.serviceName.equals(rIAccountingData.serviceName)) {
            return false;
        }
        return !(this.serviceClass == null ? rIAccountingData.serviceClass != null : !this.serviceClass.equals(rIAccountingData.serviceClass));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String string) {
        this.serviceClass = string;
    }

    public static enum statisticsType {
        InvocationTime("INVOCATIONTIME"),
        IncomingCalls("INCOMINGCALLS");

        String type;

        private statisticsType(String string2) {
            this.type = string2;
        }

        public String toString() {
            return this.type;
        }
    }
}

