/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.probes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.gcube.common.accounting.node.persistence.PersistenceAdapter;
import org.gcube.common.accounting.node.probes.RIProfileUpdater;
import org.gcube.common.accounting.node.util.DateInterval;
import org.gcube.common.accounting.node.util.Util;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBETestProbe;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.messages.NodeAccountingMessage;
import org.gcube.messaging.common.messages.records.IntervalRecord;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class NodeAccountingProbe
extends GCUBETestProbe {
    private String logsLocation = System.getenv("GLOBUS_LOCATION") + File.separator + "logs";
    private PersistenceAdapter persistenceAdapter = null;
    private Util util = null;
    private Long interval = null;
    private boolean updateIS = true;
    private Properties properties = new Properties();

    private File[] getLogFileToParse() {
        File file = new File(this.logsLocation);
        return file.listFiles(new AccessLogFilter());
    }

    public void run() throws Exception {
        Object object;
        try {
            this.properties.load(new FileInputStream(System.getenv("GLOBUS_LOCATION") + File.separator + "config" + File.separator + "NodeAccounting.properties"));
            this.setInterval(Long.valueOf((String)this.properties.get("PROBING_INTERVAL")));
            this.updateIS = Boolean.valueOf((String)this.properties.get("PUBLISH_ON_IS"));
            if (GHNContext.getContext().getStatus().compareTo((Enum)GHNContext.Status.CERTIFIED) != 0) {
                this.setInterval(40L);
                GCUBELocalProducer.logger.debug((Object)"GHN not YET Ready, retrying in 40 seconds");
                return;
            }
            this.util = new Util((GCUBELog)GCUBELocalProducer.logger);
            this.interval = this.getInterval() / 1000L;
            this.persistenceAdapter = new PersistenceAdapter((GCUBELog)GCUBELocalProducer.logger, this.interval);
            this.persistenceAdapter.load();
            if (this.persistenceAdapter.alreadyUpdated()) {
                GCUBELocalProducer.logger.debug((Object)"Node Accounting info already updated, skip to next execution");
                return;
            }
        }
        catch (Exception exception) {
            GCUBELocalProducer.logger.debug((Object)"Error on initialization", (Throwable)exception);
            throw exception;
        }
        HashMap<DateInterval, ArrayList<NodeAccountingMessage<IntervalRecord>>> hashMap = new HashMap<DateInterval, ArrayList<NodeAccountingMessage<IntervalRecord>>>();
        ArrayList<DateInterval> arrayList = this.util.generateDateIntervals(this.persistenceAdapter, this.interval);
        HashMap<File, ArrayList<DateInterval>> hashMap2 = this.util.matchIntervalsWithLogFiles(this.getLogFileToParse(), arrayList);
        if (hashMap2.size() == 0) {
            GCUBELocalProducer.logger.warn((Object)"No log File to parse");
            return;
        }
        for (File object2 : hashMap2.keySet()) {
            for (DateInterval dateInterval : hashMap2.get(object2)) {
                try {
                    GCUBELocalProducer.logger.debug((Object)("Trying to aggregate logs from " + dateInterval.getStartDateAsString() + " to " + dateInterval.getEndDateAsString() + " from File " + object2));
                    hashMap.put(dateInterval, this.util.createAccountingInfo(object2, dateInterval));
                    if (hashMap.get(dateInterval) != null) {
                        if (((ArrayList)hashMap.get(dateInterval)).size() != 0) {
                            for (GCUBEScope gCUBEScope : GCUBELocalProducer.getMonitoredScope()) {
                                for (NodeAccountingMessage nodeAccountingMessage : (ArrayList)hashMap.get(dateInterval)) {
                                    nodeAccountingMessage.setScope(gCUBEScope.toString());
                                    nodeAccountingMessage.setSourceGHN(GHNContext.getContext().getHostnameAndPort());
                                    nodeAccountingMessage.createTopicName(gCUBEScope);
                                    this.sendMessage((GCUBEMessage)nodeAccountingMessage);
                                }
                            }
                            continue;
                        }
                        GCUBELocalProducer.logger.debug((Object)"No messages to send");
                        continue;
                    }
                    GCUBELocalProducer.logger.debug((Object)"No messages to send");
                }
                catch (IOException iOException) {
                    GCUBELocalProducer.logger.error((Object)("Error Reading log file:" + object2), (Throwable)iOException);
                }
                catch (Exception exception) {
                    GCUBELocalProducer.logger.error((Object)("Error Executing Node Accounting probe on logFile:" + object2), (Throwable)exception);
                }
            }
        }
        for (DateInterval dateInterval : arrayList) {
            object = (ArrayList)hashMap.get(dateInterval);
            try {
                this.util.updateAccoutingInfo((ArrayList<NodeAccountingMessage<IntervalRecord>>)object, this.persistenceAdapter, dateInterval);
            }
            catch (Exception exception) {
                GCUBELocalProducer.logger.error((Object)"Error Updating Accounting info", (Throwable)exception);
            }
        }
        if (this.updateIS) {
            for (String string : this.persistenceAdapter.getMap().keySet()) {
                try {
                    object = new RIProfileUpdater(this.persistenceAdapter.getMap().get(string));
                    ((RIProfileUpdater)((Object)object)).run();
                }
                catch (Exception exception) {
                    GCUBELocalProducer.logger.error((Object)"Error Updating RIProfile", (Throwable)exception);
                }
            }
        }
    }

    public void sendMessage(GCUBEMessage gCUBEMessage) {
        ActiveMQClient.getSingleton().sendMessageToQueue(gCUBEMessage);
    }

    private class AccessLogFilter
    implements FilenameFilter {
        private AccessLogFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("access.log");
        }
    }
}

