/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.logparser;

import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.gcube.common.accounting.node.logparser.RIInvocationParser;
import org.gcube.common.accounting.node.util.Util;
import org.gcube.common.core.scope.GCUBEScope;

public class LogEntry {
    RIInvocationParser.EntryType type = null;
    String line;
    CallInfo info;
    GCUBEScope scope;
    double invocationTime;
    Date startDate;
    String time;
    private static final String tokensSeparator = ",";

    public LogEntry(RIInvocationParser.EntryType entryType, String string, String string2) throws ParseException {
        this.type = entryType;
        this.line = string;
        this.startDate = this.createStartDate(string2);
        this.time = string2;
        this.parse(string);
    }

    private void parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, tokensSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith(RIInvocationParser.EntryType.ENDCALL.type)) {
                this.info = new CallInfo(string2.substring(string2.indexOf("(") + 1, string2.indexOf(")")), string2.substring(string2.lastIndexOf("(") + 1, string2.lastIndexOf(")")));
                continue;
            }
            if (string2.startsWith("/")) {
                this.scope = GCUBEScope.getScope((String)string2);
                continue;
            }
            if (!string2.startsWith("[")) continue;
            this.invocationTime = Double.valueOf(string2.substring(string2.indexOf("[") + 1, string2.indexOf("]")));
        }
    }

    private Date createStartDate(String string) throws ParseException {
        return Util.format.parse(string);
    }

    public CallInfo getInfo() {
        return this.info;
    }

    public void setInfo(CallInfo callInfo) {
        this.info = callInfo;
    }

    public double getInvocationTime() {
        return this.invocationTime;
    }

    public void setInvocationTime(double d) {
        this.invocationTime = d;
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    public void setScope(GCUBEScope gCUBEScope) {
        this.scope = gCUBEScope;
    }

    public RIInvocationParser.EntryType getType() {
        return this.type;
    }

    public void setType(RIInvocationParser.EntryType entryType) {
        this.type = entryType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String string) {
        this.time = string;
    }

    public class CallInfo {
        private String serviceName;
        private String serviceClass;
        private String callerIP;

        public CallInfo(String string, String string2) {
            this.serviceClass = string2.substring(0, string2.indexOf(":"));
            String string3 = string2.substring(string2.indexOf(":") + 1);
            this.serviceName = string3 = string3.substring(0, string3.indexOf(":"));
            this.callerIP = string;
        }

        public String toString() {
            return this.serviceClass + "_" + this.serviceName;
        }

        public String getServiceClass() {
            return this.serviceClass;
        }

        public void setServiceClass(String string) {
            this.serviceClass = string;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String string) {
            this.serviceName = string;
        }

        public String getCallerIP() {
            return this.callerIP;
        }

        public void setCallerIP(String string) {
            this.callerIP = string;
        }
    }
}

